/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.mod.fvtm.entity.RailMarker;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.entity.RailMarkerModel;
import net.fexcraft.mod.fvtm.model.program.DefaultPrograms;
import net.fexcraft.mod.fvtm.sys.rail.RailPlacingUtil;
import net.fexcraft.mod.fvtm.util.TexUtil;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import org.lwjgl.opengl.GL11;

public class RenderRailMarker
extends Render<RailMarker>
implements IRenderFactory<RailMarker> {
    private ResourceLocation texture = new ResourceLocation("fvtm:textures/entity/railmarker.png");
    public static final RGB CYAN = new RGB(0, 255, 255);
    private static final DecimalFormat df = new DecimalFormat("#.#");

    public RenderRailMarker(RenderManager renderManager) {
        super(renderManager);
        this.field_76989_e = 0.125f;
    }

    public void func_110776_a(ResourceLocation rs) {
        TexUtil.bindTexture(rs);
    }

    public void doRender(RailMarker entity, double x, double y, double z, float entity_yaw, float ticks) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glPushMatrix();
        TexUtil.bindTexture(this.texture);
        RailMarkerModel.INST.base.render();
        DefaultPrograms.GLOW.pre(RailMarkerModel.INST.glow, DefaultModel.RENDERDATA);
        RailMarkerModel.INST.glow.render();
        DefaultPrograms.GLOW.post(RailMarkerModel.INST.glow, DefaultModel.RENDERDATA);
        RailPlacingUtil.NewTrack track = RailPlacingUtil.QUEUE.get(entity.queueid);
        if (track != null) {
            boolean arrow;
            int index = track.indexOf(entity.position);
            boolean bl = arrow = index == track.selected || index == 0 || index == track.points.size() - 1;
            if (arrow) {
                (index == track.selected ? CYAN : (index == 0 ? RGB.GREEN : RGB.RED)).glColorApply();
                DefaultPrograms.GLOW.pre(RailMarkerModel.INST.glow, DefaultModel.RENDERDATA);
                RailMarkerModel.INST.arrow.render();
                DefaultPrograms.GLOW.post(RailMarkerModel.INST.glow, DefaultModel.RENDERDATA);
                RGB.glColorReset();
            }
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    protected String getPosString(RailMarker entity) {
        return df.format(entity.field_70165_t) + ", " + df.format(entity.field_70163_u) + ", " + df.format(entity.field_70161_v) + " / ";
    }

    protected ResourceLocation getEntityTexture(RailMarker entity) {
        return this.texture;
    }

    public Render<RailMarker> createRenderFor(RenderManager manager) {
        return new RenderRailMarker(manager);
    }

    static {
        df.setRoundingMode(RoundingMode.CEILING);
    }
}

