/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import java.util.ArrayList;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.block.generated.BlockTileEntity;
import net.fexcraft.mod.fvtm.data.Capabilities;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.model.DebugModels;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.Model;
import net.fexcraft.mod.fvtm.model.RenderCache;
import net.fexcraft.mod.fvtm.render.RenderView;
import net.fexcraft.mod.fvtm.render.SeparateRenderCache;
import net.fexcraft.mod.fvtm.util.TexUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class TileRenderer {
    private static final ArrayList<TileEntity> entities = new ArrayList();
    private static AxisAlignedBB box;

    public static void renderBlocks(World world, double cx, double cy, double cz, float ticks) {
        if (!Config.RENDER_BLOCKS_SEPARATELY) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        entities.clear();
        entities.addAll(world.field_147482_g);
        for (TileEntity entity : entities) {
            BlockTileEntity tile;
            if (!(entity instanceof BlockTileEntity) || !RenderView.FRUSTUM.func_78546_a((box = (AxisAlignedBB)((Block)(tile = (BlockTileEntity)entity).getBlockData().getType()).getAABB("render", "").get(0)).func_186670_a(tile.func_174877_v()))) continue;
            SeparateRenderCache.SORTED_BLK_ENTITY.add(tile);
            SeparateRenderCache.SORTED_BLK_DATA.add(tile.getBlockData());
            GL11.glPushMatrix();
            GL11.glTranslated((double)((double)tile.func_174877_v().func_177958_n() - cx + 0.5), (double)((double)tile.func_174877_v().func_177956_o() - cy), (double)((double)tile.func_174877_v().func_177952_p() - cz + 0.5));
            float i = TileRenderer.getBrightness(tile.func_174877_v());
            float j = i % 65536.0f;
            float k = i / 65536.0f;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
            RenderCache cache = (RenderCache)tile.getCapability(Capabilities.RENDERCACHE, null);
            Model modVehicle = ((Block)tile.getBlockData().getType()).getModel();
            if (modVehicle != null) {
                GL11.glPushMatrix();
                TexUtil.bindTexture(tile.getBlockData().getCurrentTexture());
                modVehicle.render(DefaultModel.RENDERDATA.set(tile.getBlockData(), null, null).rc(cache));
                GL11.glPopMatrix();
            } else {
                TexUtil.bindTexture(tile.getBlockData().getCurrentTexture());
                DebugModels.SPHERE_RED.render(0.5f);
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    @Deprecated
    public static int getBrightness(BlockPos pos) {
        if (Minecraft.func_71410_x().field_71441_e.func_175667_e(pos)) {
            return Minecraft.func_71410_x().field_71441_e.func_175626_b(pos, 0);
        }
        return 0;
    }
}

