/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.block.VehicleLiftEntity;
import net.fexcraft.mod.fvtm.data.block.BlockType;
import net.fexcraft.mod.fvtm.data.vehicle.LiftingPoint;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.block.Lift2024Model;
import net.fexcraft.mod.fvtm.render.EffectRenderer;
import net.fexcraft.mod.fvtm.render.VehicleRenderer;
import net.fexcraft.mod.fvtm.util.TexUtil;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class VehicleLiftRenderer
extends TileEntitySpecialRenderer<VehicleLiftEntity> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("fvtm:textures/block/lift2024.png");
    private VehicleData data;

    public void render(VehicleLiftEntity tile, double x, double y, double z, float ticks, int stage, float a) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GL11.glRotated((double)BlockType.GENERIC_4ROT.getRotationFor(tile.func_145832_p()), (double)0.0, (double)1.0, (double)0.0);
        TexUtil.bindTexture(TEXTURE);
        Lift2024Model.center.render();
        this.data = tile.getVehicleData();
        if (this.data != null) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)(tile.liftstate + 0.3125), (double)0.0);
            if (((Vehicle)this.data.getType()).getModel() != null) {
                TexUtil.bindTexture(this.data.getCurrentTexture());
                ((Vehicle)this.data.getType()).getModel().render(DefaultModel.RENDERDATA.set(this.data, null, ticks));
            }
            if (this.data.getParts().size() > 0) {
                VehicleRenderer.renderPoint(this.data.getRotationPoint("vehicle"), null, this.data, null, ticks);
            }
            EffectRenderer.renderVehicleInfo(null, tile.getVehicleDataPos(), this.data);
            GL11.glPopMatrix();
            TexUtil.bindTexture(TEXTURE);
            for (LiftingPoint[] point : ((Vehicle)this.data.getType()).getGroupedLiftingPoints().values()) {
                GL11.glPushMatrix();
                V3D vec = point.length == 1 ? point[0].pos : point[0].pos.add(point[1].pos).multiply(0.5);
                double dis = point.length > 1 ? Math.abs(point[0].pos.z) + Math.abs(point[1].pos.z) : 0.0;
                float m = 0.0f;
                if (point.length == 1 || dis <= 0.75) {
                    if (vec.x > 0.0) {
                        GL11.glTranslated((double)(1.75 + vec.x), (double)0.0, (double)vec.z);
                        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    } else {
                        GL11.glTranslated((double)(-1.75 + vec.x), (double)0.0, (double)vec.z);
                        Lift2024Model.motor.render();
                    }
                    Lift2024Model.struct.render();
                    GL11.glTranslated((double)0.0, (double)(tile.liftstate + vec.y), (double)0.0);
                    Lift2024Model.lift.render();
                    Lift2024Model.arm_n.rotate(0.0f, -90.0f, 0.0f, true);
                    Lift2024Model.arm_n_e.rotate(0.0f, -90.0f, 0.0f, true);
                    Lift2024Model.arm_s.rotate(0.0f, 90.0f, 0.0f, true);
                    Lift2024Model.arm_s_e.rotate(0.0f, 90.0f, 0.0f, true);
                    Lift2024Model.arm_n.render();
                    Lift2024Model.arm_n_e.render();
                    Lift2024Model.arm_s.render();
                    Lift2024Model.arm_s_e.render();
                } else {
                    float r = (float)(2.0 - dis - 0.75) * 0.5f;
                    if (vec.x > 0.0) {
                        GL11.glTranslated((double)((double)(dis < 2.75 ? -r : 0.0f) + 0.75 + vec.x), (double)0.0, (double)vec.z);
                        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    } else {
                        GL11.glTranslated((double)((double)(dis < 2.75 ? r : 0.0f) - 0.75 + vec.x), (double)0.0, (double)vec.z);
                        Lift2024Model.motor.render();
                    }
                    Lift2024Model.struct.render();
                    GL11.glTranslated((double)0.0, (double)(tile.liftstate + vec.y), (double)0.0);
                    Lift2024Model.lift.render();
                    if (dis < 2.75) {
                        Lift2024Model.arm_n.rotate(0.0f, r *= 90.0f, 0.0f, true);
                        Lift2024Model.arm_n_e.rotate(0.0f, r, 0.0f, true);
                        Lift2024Model.arm_s.rotate(0.0f, -r, 0.0f, true);
                        Lift2024Model.arm_s_e.rotate(0.0f, -r, 0.0f, true);
                    } else {
                        m = dis > 4.75 ? 1.0f : (float)((dis - 2.75) * 0.5);
                        Lift2024Model.arm_n_e.translate(0.0f, 0.0f, -m, false);
                        Lift2024Model.arm_s_e.translate(0.0f, 0.0f, m, false);
                    }
                    Lift2024Model.arm_n.render();
                    Lift2024Model.arm_n_e.render();
                    Lift2024Model.arm_s.render();
                    Lift2024Model.arm_s_e.render();
                    if (m != 0.0f) {
                        Lift2024Model.arm_n_e.translate(0.0f, 0.0f, m, false);
                        Lift2024Model.arm_s_e.translate(0.0f, 0.0f, -m, false);
                    }
                }
                GL11.glPopMatrix();
            }
            Lift2024Model.arm_n.rotate(0.0f, 0.0f, 0.0f, true);
            Lift2024Model.arm_n_e.rotate(0.0f, 0.0f, 0.0f, true);
            Lift2024Model.arm_s.rotate(0.0f, 0.0f, 0.0f, true);
            Lift2024Model.arm_s_e.rotate(0.0f, 0.0f, 0.0f, true);
        } else {
            GL11.glTranslated((double)-2.0, (double)0.0, (double)0.0);
            Lift2024Model.struct.render();
            Lift2024Model.motor.render();
            Lift2024Model.lift.render();
            Lift2024Model.arm_n.render();
            Lift2024Model.arm_n_e.render();
            Lift2024Model.arm_s.render();
            Lift2024Model.arm_s_e.render();
            GL11.glTranslated((double)4.0, (double)0.0, (double)0.0);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            Lift2024Model.struct.render();
            Lift2024Model.lift.render();
            Lift2024Model.arm_n.render();
            Lift2024Model.arm_n_e.render();
            Lift2024Model.arm_s.render();
            Lift2024Model.arm_s_e.render();
        }
        GL11.glPopMatrix();
    }
}

