/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.TexturedPolygon;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.tmt.ModelRendererTurbo;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.block.generated.BlockTileEntity;
import net.fexcraft.mod.fvtm.data.ToolboxType;
import net.fexcraft.mod.fvtm.data.WireDeco;
import net.fexcraft.mod.fvtm.item.ToolboxItem;
import net.fexcraft.mod.fvtm.item.WireItem;
import net.fexcraft.mod.fvtm.model.DebugModels;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.ModelGroup;
import net.fexcraft.mod.fvtm.model.Program;
import net.fexcraft.mod.fvtm.model.content.WireModel;
import net.fexcraft.mod.fvtm.model.program.WirePrograms;
import net.fexcraft.mod.fvtm.render.EffectRenderer;
import net.fexcraft.mod.fvtm.render.PathModelGenerator;
import net.fexcraft.mod.fvtm.render.RenderView;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;
import net.fexcraft.mod.fvtm.sys.wire.RelayHolder;
import net.fexcraft.mod.fvtm.sys.wire.Wire;
import net.fexcraft.mod.fvtm.sys.wire.WireRelay;
import net.fexcraft.mod.fvtm.sys.wire.WireSystem;
import net.fexcraft.mod.fvtm.util.Command;
import net.fexcraft.mod.fvtm.util.TexUtil;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class WireRenderer {
    public static Wire CURRENT;
    public static double ANGLE;
    public static double ANGLE_DOWN;
    protected static final ModelRendererTurbo model;
    protected static final ModelRendererTurbo model0;
    protected static final ModelRendererTurbo model1;
    protected static final ModelRendererTurbo[] all;
    private static WireSystem wiredata;
    private static ItemStack held;
    private static boolean holding_wire;
    private static boolean holding_slack;
    private static V3D cubepos;
    private static float size;

    public static void renderWires(World world, double cx, double cy, double cz, float partialticks) {
        if (Config.DISABLE_WIRES) {
            return;
        }
        wiredata = (WireSystem)SystemManager.get(SystemManager.Systems.WIRE, WrapperHolder.getWorld((Object)world));
        if (wiredata == null || wiredata.getRegions() == null) {
            return;
        }
        held = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
        holding_wire = held.func_77973_b() instanceof WireItem || held.func_77973_b() instanceof ToolboxItem && ToolboxType.WIRE_REMOVAL.eq(held.func_77952_i());
        holding_slack = held.func_77973_b() instanceof ToolboxItem && ToolboxType.WIRE_SLACK.eq(held.func_77952_i());
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (SystemRegion reg : wiredata.getRegions().values()) {
            for (RelayHolder holder : reg.getObjects().values()) {
                for (WireRelay relay : holder.relays.values()) {
                    if (!RenderView.FRUSTUM.func_78546_a((AxisAlignedBB)relay.getAABB().local())) continue;
                    if (Command.OTHER || holding_wire) {
                        GL11.glPushMatrix();
                        GL11.glTranslated((double)(relay.pos.x - cx), (double)(relay.pos.y - cy), (double)(relay.pos.z - cz));
                        size = holder.hasRef() ? holder.ref().getSize(relay.getKey()) * 2.0f : 0.25f;
                        GL11.glScalef((float)size, (float)size, (float)size);
                        DebugModels.CUBE_CYN.render(1.0f);
                        GL11.glPopMatrix();
                    }
                    if ((Command.OTHER || holding_slack) && relay.wires.size() > 0) {
                        for (Wire wire : relay.wires) {
                            if (wire.copy) continue;
                            cubepos = wire.getVectorPosition((double)wire.length * 0.5, false);
                            GL11.glPushMatrix();
                            GL11.glTranslated((double)(WireRenderer.cubepos.x - cx), (double)(WireRenderer.cubepos.y - cy), (double)(WireRenderer.cubepos.z - cz));
                            size = holder.hasRef() ? holder.ref().getSize(relay.getKey()) * 2.0f : 0.25f;
                            GL11.glScalef((float)size, (float)size, (float)size);
                            DebugModels.CUBE_ORG.render(1.0f);
                            GL11.glPopMatrix();
                        }
                    }
                    WireRenderer.renderWires(relay, cx, cy, cz);
                }
            }
        }
        GL11.glPopMatrix();
    }

    private static void renderWires(WireRelay relay, double cx, double cy, double cz) {
        if (Command.OTHER) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            for (int o = 0; o < relay.wires.size(); ++o) {
                Wire conn = relay.wires.get(o);
                if (conn.vecpath == null) {
                    return;
                }
                float flfl = conn.copy ? 1.0f : 0.0f;
                float glgl = conn.copy ? 0.0f : 1.0f;
                GL11.glPushMatrix();
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187441_d((float)2.0f);
                GlStateManager.func_179090_x();
                GlStateManager.func_179132_a((boolean)false);
                for (int j = 0; j < conn.vecpath.length - 1; ++j) {
                    V3D vec0 = conn.vecpath[j];
                    V3D vec1 = conn.vecpath[j + 1];
                    bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
                    bufferbuilder.func_181662_b(vec0.x - cx, vec0.y + (double)(conn.copy ? 0.1f : 0.0f) - cy, vec0.z - cz).func_181666_a(0.0f, glgl, flfl, 1.0f).func_181675_d();
                    bufferbuilder.func_181662_b(vec1.x - cx, vec1.y + (double)(conn.copy ? 0.1f : 0.0f) - cy, vec1.z - cz).func_181666_a(0.0f, glgl, flfl, 1.0f).func_181675_d();
                    tessellator.func_78381_a();
                }
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179098_w();
                GlStateManager.func_179084_k();
                GL11.glPopMatrix();
            }
        } else {
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int i = 0; i < relay.size(); ++i) {
                if (relay.wires.get((int)i).copy) continue;
                Wire wire = relay.wires.get(i);
                if (wire.vecpath == null || wire.getWireType() == null) continue;
                WireModel model = wire.getWireType().getModel();
                if (wire.wiremodel == null) {
                    PathModelGenerator.generateWireModel(wire, model);
                }
                TexUtil.bindTexture(wire.getWireType().getTexture());
                GL11.glTranslated((double)(wire.vecpath[0].x - cx), (double)(wire.vecpath[0].y - cy), (double)(wire.vecpath[0].z - cz));
                wire.wiremodel.render();
                if (relay.getTile() == null) continue;
                CURRENT = wire;
                ANGLE = wire.model_end_angle;
                if (wire.deco_s != null) {
                    ANGLE_DOWN = wire.model_start_angle_down;
                    GL11.glPushMatrix();
                    GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                    GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)wire.model_start_angle, (double)0.0, (double)1.0, (double)0.0);
                    TexUtil.bindTexture(wire.deco_s.getTexture());
                    wire.deco_s.getModel().render(DefaultModel.RENDERDATA.set(((BlockTileEntity)relay.getTile()).getBlockData(), relay.getTile(), null));
                    GL11.glPopMatrix();
                }
                if (wire.deco_e != null) {
                    ANGLE_DOWN = wire.model_end_angle_down;
                    int l = wire.vecpath.length - 1;
                    GL11.glPushMatrix();
                    GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                    GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                    GL11.glRotated((double)wire.model_end_angle, (double)0.0, (double)1.0, (double)0.0);
                    TexUtil.bindTexture(wire.deco_e.getTexture());
                    wire.deco_e.getModel().render(DefaultModel.RENDERDATA.set(((BlockTileEntity)relay.getTile()).getBlockData(), relay.getTile(), null));
                    GL11.glPopMatrix();
                }
                if (wire.deco_m == null) {
                    WireRenderer.genWireDeco(relay, wire);
                }
                if (wire.deco_m.size() <= 0) continue;
                for (Map.Entry<String, WireDeco> dm : wire.deco_m.entrySet()) {
                    WireModel wm = dm.getValue().getModel();
                    for (ModelGroup list : wm.groups) {
                        if (wire.deco_d.get(dm.getKey()).containsKey(list.name)) {
                            ArrayList<ModelRendererTurbo> tlist = wire.deco_g.containsKey(dm.getKey()) ? wire.deco_g.get(dm.getKey()).get(list.name) : null;
                            int didx = 0;
                            for (V3D vec : wire.deco_d.get(dm.getKey()).get(list.name)) {
                                GL11.glPushMatrix();
                                GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                                wm.transforms.apply();
                                TexUtil.bindTexture(dm.getValue().getTexture());
                                list.render(DefaultModel.RENDERDATA.set(((BlockTileEntity)relay.getTile()).getBlockData(), relay.getTile(), null));
                                if (tlist != null) {
                                    TexUtil.bindTexture(wire.getWireType().getTexture());
                                    tlist.get(didx++).render();
                                }
                                wm.transforms.deapply();
                                GL11.glPopMatrix();
                            }
                            continue;
                        }
                        GL11.glPushMatrix();
                        GL11.glTranslated((double)wire.vecpath[0].x, (double)wire.vecpath[0].y, (double)wire.vecpath[0].z);
                        GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                        GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                        wm.transforms.apply();
                        TexUtil.bindTexture(dm.getValue().getTexture());
                        list.render(DefaultModel.RENDERDATA.set(((BlockTileEntity)relay.getTile()).getBlockData(), relay.getTile(), null));
                        wm.transforms.deapply();
                        GL11.glPopMatrix();
                    }
                }
            }
            if (Command.OTHER) {
                for (int i = 0; i < relay.size(); ++i) {
                    Wire wire = relay.wires.get(i);
                    V3D pos = wire.getVectorPosition((double)wire.length * 0.5, false);
                    double off = wire.copy ? 0.125 : -0.125;
                    double deg = (double)Minecraft.func_71410_x().field_71439_g.func_174811_aO().func_176736_b() * 90.0;
                    EffectRenderer.drawString(wire.getUnit().section().getUID() + "", pos.x + off, pos.y + 0.5, pos.z, true, true, 0.8f, wire.copy ? 12106808 : 3319890, deg);
                }
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    private static void genWireDeco(WireRelay relay, Wire wire) {
        wire.deco_m = new HashMap();
        wire.deco_d = new HashMap();
        wire.deco_g = new HashMap();
        if (wire.decos == null) {
            return;
        }
        for (Map.Entry<String, String> entry : wire.decos.entrySet()) {
            WireDeco deco = FvtmRegistry.WIREDECOS.get(entry.getValue());
            if (deco == null) continue;
            wire.deco_m.put(entry.getKey(), deco);
            wire.deco_d.put(entry.getKey(), new HashMap());
            wire.deco_g.put(entry.getKey(), new HashMap());
            block1: for (ModelGroup list : deco.getModel().groups) {
                for (Program program : list.getAllPrograms()) {
                    if (!(program instanceof WirePrograms.SpacedDeco)) continue;
                    wire.deco_d.get(entry.getKey()).put(list.name, ((WirePrograms.SpacedDeco)program).generate(relay, wire, list, entry.getKey(), true));
                    continue block1;
                }
            }
        }
    }

    static {
        model = new ModelRendererTurbo(null, 0, 0, 32, 32).addSphere(0.0f, 0.0f, 0.0f, 2.0f, 6, 6, 1, 1).setLines(new RGB(56831));
        model0 = new ModelRendererTurbo(null, 0, 0, 32, 32).addSphere(0.0f, 0.0f, 0.0f, 0.5f, 8, 8, 32, 32).setTextured(false).setColor(new RGB(245, 234, 128));
        model1 = new ModelRendererTurbo(null, 0, 0, 32, 32).addSphere(0.0f, 0.0f, 0.0f, 0.5f, 8, 8, 32, 32).setTextured(false).setColor(new RGB(123, 245, 126));
        for (ModelRendererTurbo turbo : all = new ModelRendererTurbo[]{model, model0, model1}) {
            for (TexturedPolygon poly : turbo.getFaces()) {
                poly.setColor(turbo.polygonColor);
            }
        }
    }
}

