/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.pro;

import java.util.ArrayList;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.mc.api.packet.IPacketReceiver;
import net.fexcraft.lib.mc.network.packet.PacketEntityUpdate;
import net.fexcraft.lib.mc.utils.Static;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.data.vehicle.WheelSlot;
import net.fexcraft.mod.fvtm.sys.pro.NLandVehicle;
import net.fexcraft.mod.fvtm.sys.pro.NWheelEntity;
import net.fexcraft.mod.fvtm.sys.uni.Axle;
import net.fexcraft.mod.fvtm.sys.uni.RootVehicle;
import net.fexcraft.mod.fvtm.sys.uni.UniWheel;
import net.fexcraft.mod.fvtm.sys.uni.WheelTireData;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ULandVehicle
extends RootVehicle
implements IEntityAdditionalSpawnData,
IPacketReceiver<PacketEntityUpdate> {
    public ArrayList<Axle> axles = new ArrayList();
    public Axle ax_fron;
    public Axle ax_rear;
    public double wheelbase;
    public double cg_height;
    public int rpm;
    public int orpm;
    public int crpm;
    private ArrayList<Double> avsp = new ArrayList();
    public static final float TICKA = 0.05f;
    public static final float o132 = 0.03125f;
    private double appmass = 0.0;
    private double accx = 0.0;

    public ULandVehicle(World world) {
        super(world);
        this.field_70156_m = true;
        this.func_70105_a(1.0f, 1.0f);
        this.field_70158_ak = true;
        this.field_70138_W = 1.0f;
        if (world.field_72995_K) {
            ULandVehicle.func_184227_b((double)1.0);
        }
    }

    public ULandVehicle(World world, VehicleData data, V3D pos, EntityPlayer placer, int meta) {
        this(world);
        this.func_70107_b(pos.x, pos.y, pos.z);
        this.vehicle.init(data, null);
        if (placer != null) {
            this.vehicle.setPlacer(placer.func_146103_bH().getId());
        }
        float prot = placer != null ? (float)(MathHelper.func_76128_c((double)((double)((placer.field_70177_z + 180.0f) * 16.0f / 360.0f) + 0.5)) & 0xF) * 22.5f : 0.0f;
        this.vehicle.pivot().set_yaw((placer == null || meta >= 0 ? (float)meta * 90.0f : prot) + -90.0f, true);
        this.init(null);
    }

    public ULandVehicle(NLandVehicle truck, VehicleData data, EntityPlayer placer) {
        this(truck.field_70170_p, data, truck.vehicle.getV3D(), placer, 0);
        this.vehicle.front = truck.vehicle;
        truck.vehicle.rear = this.vehicle;
        this.vehicle.point.updatePrevAxe();
        this.vehicle.point.getPivot().copy(truck.vehicle.point.getPivot());
        this.vehicle.sendUpdate("vehicle_front");
    }

    @Override
    public boolean isAdv() {
        return true;
    }

    @Override
    protected void func_70088_a() {
    }

    @Override
    protected void init(TagCW com) {
        super.init(com);
        this.setupAxles();
    }

    private void setupAxles() {
        this.axles.clear();
        for (WheelTireData wheel : this.vehicle.wheeldata.values()) {
            Axle axle2 = null;
            if (this.axles.stream().anyMatch(a -> a.pos.x == wheel.pos.x && a.pos.y == wheel.pos.y)) {
                axle2 = this.axles.stream().filter(a -> a.pos.x == wheel.pos.x && a.pos.y == wheel.pos.y).findFirst().get();
            } else {
                axle2 = new Axle(this.axles.size(), new V3D(wheel.pos.x, wheel.pos.y, 0.0));
                this.axles.add(axle2);
            }
            axle2.wheels.add(wheel);
            wheel.axle = axle2;
        }
        this.axles.forEach(axle -> axle.initCenter());
        double amin = 0.0;
        double amax = 0.0;
        for (Axle axle3 : this.axles) {
            if (axle3.pos.x < amin) {
                amin = axle3.pos.x;
                this.ax_rear = axle3;
            }
            if (!(axle3.pos.x > amax)) continue;
            amax = axle3.pos.x;
            this.ax_fron = axle3;
        }
        this.wheelbase = Math.abs(amin) + Math.abs(amax);
        this.cg_height = 0.0;
        for (Axle axle3 : this.axles) {
            axle3.weight_ratio = Math.abs(axle3.pos.x) / this.wheelbase;
            this.cg_height = axle3.pos.y;
        }
        this.cg_height /= (double)this.axles.size();
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.vehicle.pbrake = compound.func_74767_n("ParkingBrake");
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("ParkingBrake", this.vehicle.pbrake);
    }

    @Override
    public void writeSpawnData(TagCW com) {
        if (this.vehicle.front != null) {
            com.set("TruckId", this.vehicle.front.entity.getId());
        }
    }

    @Override
    public void readSpawnData(TagCW com) {
        if (com.has("TruckId")) {
            this.vehicle.front = ((ULandVehicle)this.field_70170_p.func_73045_a((int)com.getInteger((String)"TruckId"))).vehicle;
            this.vehicle.front.rear = this.vehicle;
        }
    }

    public void func_70108_f(Entity entity) {
    }

    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.vehicle.data == null) {
            return;
        }
        if (this.field_70170_p.field_72995_K) {
            this.vehicle.data.getAttribute("rpm").set(this.crpm / 100 * 100);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSounds() {
    }

    public void onUpdateMovement() {
        EntityW driver = this.vehicle.driver();
        if (!this.field_70170_p.field_72995_K) {
            if (driver == null || !driver.isCreative() && this.vehicle.data.getAttribute("fuel_stored").asInteger() <= 0) {
                this.vehicle.throttle *= (double)0.98f;
            }
            if (this.vehicle.front == null) {
                if (((Vehicle)this.vehicle.data.getType()).isTrailer()) {
                    this.relign();
                } else {
                    this.onUpdateMovement1(driver);
                }
            }
        } else {
            this.updateSounds();
        }
        double x = this.field_70165_t - this.field_70169_q;
        double y = this.field_70163_u - this.field_70167_r;
        double z = this.field_70161_v - this.field_70166_s;
        while (this.avsp.size() < 10) {
            this.avsp.add(this.vehicle.speed);
        }
        this.avsp.add(Math.sqrt(x * x + y * y + z * z) * 1000.0 / 20.0);
        this.avsp.remove(0);
        this.vehicle.speed = 0.0;
        for (double d : this.avsp) {
            this.vehicle.speed += d;
        }
        this.vehicle.speed /= (double)this.avsp.size();
    }

    public void onUpdateMovement1(EntityW driver) {
        ULandVehicle trailer;
        double val;
        if (this.vehicle.rear != null) {
            ULandVehicle trailer2 = (ULandVehicle)((Object)this.vehicle.rear.entity.local());
            while (trailer2.vehicle.rear != null) {
                trailer2 = (ULandVehicle)((Object)trailer2.vehicle.rear.entity.local());
            }
            ULandVehicle truck = (ULandVehicle)((Object)trailer2.vehicle.front.entity.local());
            trailer2.appmass = trailer2.vehicle.data.getAttributeFloat("weight", 1000.0f);
            while (truck != null) {
                truck.appmass = truck.vehicle.data.getAttributeFloat("weight", 1000.0f);
                truck.appmass += ((ULandVehicle)((Object)truck.vehicle.rear.entity.direct())).appmass * (double)truck.vehicle.rear.data.getAttributeFloat("trailer_weight_ratio", 0.2f);
                truck = (ULandVehicle)((Object)truck.vehicle.front.entity.local());
            }
        } else {
            this.appmass = this.vehicle.data.getAttributeFloat("weight", 1000.0f);
        }
        double mass = this.appmass;
        double rr = this.vehicle.data.getAttributeFloat("roll_resistance", 8.0f);
        double ar = this.vehicle.data.getAttributeFloat("air_resistance", 2.5f);
        for (Axle axle : this.axles) {
            axle.calc(mass, this.accx, this.cg_height, this.wheelbase, 1.0);
        }
        boolean overloaded = this.appmass - (double)this.vehicle.data.getAttributeFloat("weight", 1000.0f) > (double)this.vehicle.data.getAttributeFloat("max_towing", 3500.0f);
        V3D atmc = new V3D(0.0, 0.0, 0.0);
        boolean consumed = this.vehicle.consumeFuel();
        boolean nopass = this.func_184188_bt().isEmpty();
        float brkf = this.vehicle.data.getAttributeFloat("brake_force", 10000.0f);
        double brake = Math.min((this.vehicle.braking ? brkf : 0.0f) + (this.vehicle.pbrake ? this.vehicle.data.getAttributeFloat("parking_brake_force", 5000.0f) : 0.0f), brkf);
        int gear = this.vehicle.data.getAttributeInteger("gear", 0);
        float diff = this.vehicle.data.getAttributeFloat("differential_ratio", 3.5f);
        if (this.vehicle.engine != null && this.vehicle.transmission != null) {
            this.orpm = this.rpm;
            this.rpm = (int)(this.vehicle.speed / (double)this.axles.get((int)0).wheels.get((int)0).radius * (double)this.vehicle.transmission.getRatio(gear) * (double)diff * 60.0 / 6.2831854820251465);
            this.rpm = (this.orpm + this.rpm) / 2;
            if (this.rpm < 0) {
                this.rpm = -this.rpm;
            }
            if (this.rpm < this.vehicle.engine.minRPM()) {
                this.rpm = this.vehicle.engine.minRPM();
            }
            if (this.rpm > this.vehicle.engine.maxRPM()) {
                this.rpm = this.vehicle.engine.maxRPM();
            }
        }
        float force = 0.0f;
        if (!overloaded && this.vehicle.engine != null && this.vehicle.transmission != null) {
            force = this.vehicle.engine.getTorque(this.rpm) * this.vehicle.transmission.getRatio(gear) * diff * this.vehicle.transmission.getEfficiency() / this.axles.get((int)0).wheels.get((int)0).radius;
            if (this.vehicle.transmission.isAutomatic() && this.vehicle.autogear_timer <= 0) {
                int ngear = this.vehicle.transmission.processAutoShift(gear, this.rpm, this.vehicle.engine.maxRPM(), this.vehicle.throttle);
                if (ngear != gear) {
                    this.vehicle.data.getAttribute("gear").set(ngear);
                    this.vehicle.updateAttr("gear");
                }
                this.vehicle.autogear_timer += this.vehicle.transmission.getShiftSpeed();
            }
        }
        if (overloaded) {
            driver.bar("&cTEMP: Towing limit reached, vehicle is overloaded.");
        }
        double thr = this.vehicle.throttle * (double)force;
        double cos = Math.cos(this.vehicle.pivot().yaw());
        double sin = Math.sin(this.vehicle.pivot().yaw());
        boolean slowdown = this.vehicle.throttle < (double)0.001f || gear == 0;
        this.field_70122_E = true;
        this.accx = 0.0;
        for (UniWheel ent : this.vehicle.wheels.values()) {
            NWheelEntity wheel = (NWheelEntity)ent;
            if (wheel == null) continue;
            WheelSlot slot = this.vehicle.data.getWheelSlots().get(wheel.wheelid);
            wheel.field_70122_E = true;
            wheel.field_70177_z = this.vehicle.pivot().deg_yaw();
            double wheelrot = Math.toRadians(wheel.field_70177_z);
            BlockPos wheelpos = new BlockPos(wheel.field_70165_t, wheel.field_70163_u - 0.03125, wheel.field_70161_v);
            boolean rainfall = this.field_70170_p.func_175727_C(wheelpos);
            Material mat = this.field_70170_p.func_180495_p(wheelpos).func_185904_a();
            if (slowdown || this.vehicle.speed < 3.0 || nopass) {
                boolean brk;
                boolean bl = brk = this.vehicle.braking || this.vehicle.pbrake;
                double by = brk && !slowdown ? 0.0 : (this.vehicle.speed < 3.0 ? 0.9 : 0.99);
                wheel.field_70159_w *= by;
                wheel.field_70181_x *= by;
                wheel.field_70179_y *= by;
            }
            wheel.field_70181_x -= 0.04905000329017639;
            double motx = cos * wheel.field_70159_w + sin * wheel.field_70179_y;
            double moty = cos * wheel.field_70179_y - sin * wheel.field_70159_w;
            double stew = Math.toRadians(this.vehicle.steer_yaw);
            double steer = slot.steering ? Math.signum(motx) * stew : 0.0;
            double slip_angle = Math.atan2(moty + wheel.wheel.axle.yaw_speed, Math.abs(motx)) - steer;
            double grip = wheel.wheel.function.getGripFor(mat, rainfall) * (slot.braking && this.vehicle.pbrake ? wheel.wheel.function.brake_grip : 1.0f);
            double frict = Static.clamp((double)((double)wheel.wheel.function.getCornerStiffnessFor(mat, slot.steering) * slip_angle), (double)(-grip), (double)grip) * wheel.wheel.axle.weight_on;
            double trac = (double)wheel.wheel.function.getGripFor(mat, rainfall) * ((consumed ? thr : 0.0) - brake * Math.signum(motx));
            double dragx = -rr * motx - ar * motx * Math.abs(motx);
            double dragy = -rr * moty - ar * moty * Math.abs(moty);
            double totalx = dragx + trac;
            double totaly = dragy + (slot.steering ? Math.cos(stew) * frict : 0.0);
            double acx = totalx / mass * (double)0.05f;
            double acy = totaly / mass * (double)0.05f;
            this.accx += acx;
            val = acx * (double)Config.MOTION_SCALE;
            wheel.field_70159_w *= 0.25;
            wheel.field_70179_y *= 0.25;
            wheel.field_70159_w -= Math.sin(-wheelrot) * (val + motx * 0.75);
            wheel.field_70179_y -= Math.cos(-wheelrot) * (val + motx * 0.75);
            if (slot.steering) {
                val = acy * (double)0.05f;
                wheel.field_70159_w -= Math.sin(-wheelrot) * val * stew;
                wheel.field_70179_y -= Math.cos(-wheelrot) * val * stew;
            }
            wheel.func_70091_d(MoverType.SELF, wheel.field_70159_w, wheel.field_70181_x, wheel.field_70179_y);
            atmc = ULandVehicle.alignWheel(this, wheel, wheel.wheel.pos, atmc, false);
        }
        this.func_70091_d(MoverType.SELF, atmc.x, atmc.y, atmc.z);
        this.accx /= (double)this.vehicle.wheels.size();
        this.rerot();
        ULandVehicle uLandVehicle = trailer = this.vehicle.rear == null ? null : (ULandVehicle)((Object)this.vehicle.rear.entity.local());
        while (trailer != null) {
            NWheelEntity wheel;
            atmc = new V3D(0.0, 0.0, 0.0);
            V3D opos = new V3D(trailer.field_70165_t, trailer.field_70163_u, trailer.field_70161_v);
            V3D conn = trailer.vehicle.front.pivot().get_vector(V3D.NULL);
            conn = conn.add(trailer.vehicle.front.getV3D());
            val = opos.dis(conn);
            V3D trax = trailer.vehicle.pivot().get_vector(trailer.ax_rear.pos).add(trailer.field_70165_t, trailer.field_70163_u, trailer.field_70161_v);
            trailer.vehicle.pivot().set_yaw((float)Math.atan2(conn.z - trax.z, conn.x - trax.x), false);
            trailer.field_70122_E = true;
            for (UniWheel ent : trailer.vehicle.wheels.values()) {
                wheel = (NWheelEntity)ent;
                if (wheel == null) continue;
                wheel.field_70122_E = true;
                wheel.field_70177_z = trailer.vehicle.pivot().deg_yaw();
                wheel.field_70179_y = 0.0;
                wheel.field_70159_w = 0.0;
                if (val < 0.04905000329017639) {
                    wheel.field_70181_x = 0.0;
                }
                wheel.field_70159_w += Math.cos(wheel.field_70177_z * (float)Math.PI / 180.0f) * val;
                wheel.field_70179_y += Math.sin(wheel.field_70177_z * (float)Math.PI / 180.0f) * val;
                wheel.field_70181_x -= 0.04905000329017639;
                atmc = ULandVehicle.alignWheel(trailer, wheel, wheel.wheel.pos, atmc, true);
            }
            trailer.func_70091_d(MoverType.SELF, atmc.x, atmc.y, atmc.z);
            trailer.opos();
            trailer.func_70107_b(conn.x, conn.y, conn.z);
            for (UniWheel ent : trailer.vehicle.wheels.values()) {
                wheel = (NWheelEntity)ent;
                wheel.func_70091_d(MoverType.SELF, 0.0, -0.04905000329017639, 0.0);
            }
            trailer.rerot();
            trailer = this.vehicle.rear == null ? null : (ULandVehicle)((Object)this.vehicle.rear.entity.local());
        }
    }

    private void relign() {
        int wheelid = 0;
        V3D atmc = new V3D(0.0, 0.0, 0.0);
        for (UniWheel ent : this.vehicle.wheels.values()) {
            NWheelEntity wheel = (NWheelEntity)ent;
            if (wheel == null) continue;
            this.field_70122_E = true;
            wheel.field_70122_E = true;
            wheel.field_70177_z = this.vehicle.pivot().deg_yaw();
            wheel.field_70159_w *= (double)0.9f;
            wheel.field_70181_x *= (double)0.9f;
            wheel.field_70179_y *= (double)0.9f;
            wheel.field_70181_x -= 0.4905000329017639;
            wheel.func_70091_d(MoverType.SELF, wheel.field_70159_w, wheel.field_70181_x, wheel.field_70179_y);
            atmc = ULandVehicle.alignWheel(this, wheel, wheel.wheel.pos, atmc, true);
            ++wheelid;
        }
        this.func_70091_d(MoverType.SELF, atmc.x, atmc.y, atmc.z);
        this.rerot();
    }

    private void opos() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
    }

    private static V3D alignWheel(ULandVehicle vehicle, NWheelEntity wheel, V3D vec, V3D atmc, boolean corrcheck) {
        V3D targetpos = vehicle.vehicle.pivot().get_vector(vec);
        V3D current = new V3D(wheel.field_70165_t - vehicle.field_70165_t, wheel.field_70163_u - vehicle.field_70163_u, wheel.field_70161_v - vehicle.field_70161_v);
        V3D despos = new V3D(targetpos.x - current.x, targetpos.y - current.y, targetpos.z - current.z).scale(0.5);
        if (despos.length() > (double)0.001f) {
            wheel.func_70091_d(MoverType.SELF, despos.x, despos.y, despos.z);
            despos = despos.scale(0.5);
            return atmc.sub(despos);
        }
        if (corrcheck && wheel.func_174791_d().func_72438_d(vehicle.func_174791_d()) > 8.0) {
            wheel.field_70165_t = despos.x;
            wheel.field_70163_u = despos.y;
            wheel.field_70161_v = despos.z;
        }
        return atmc;
    }

    public void rerot() {
        NWheelEntity fl = (NWheelEntity)this.vehicle.wheels.getWheel(this.vehicle.w_front_l.id);
        NWheelEntity fr = (NWheelEntity)this.vehicle.wheels.getWheel(this.vehicle.w_front_r.id);
        NWheelEntity rl = (NWheelEntity)this.vehicle.wheels.getWheel(this.vehicle.w_rear_l.id);
        NWheelEntity rr = (NWheelEntity)this.vehicle.wheels.getWheel(this.vehicle.w_rear_r.id);
        V3D fron = new V3D((fl.field_70165_t + fr.field_70165_t) * 0.5, (fl.field_70163_u + fr.field_70163_u) * 0.5, (fl.field_70161_v + fr.field_70161_v) * 0.5);
        V3D rear = new V3D((rl.field_70165_t + rr.field_70165_t) * 0.5, (rl.field_70163_u + rr.field_70163_u) * 0.5, (rl.field_70161_v + rr.field_70161_v) * 0.5);
        V3D left = new V3D((fl.field_70165_t + rl.field_70165_t) * 0.5, (fl.field_70163_u + rl.field_70163_u) * 0.5, (fl.field_70161_v + rl.field_70161_v) * 0.5);
        V3D righ = new V3D((fr.field_70165_t + rr.field_70165_t) * 0.5, (fr.field_70163_u + rr.field_70163_u) * 0.5, (fr.field_70161_v + rr.field_70161_v) * 0.5);
        double dx = rear.x - fron.x;
        double dy = rear.y - fron.y;
        double dz = rear.z - fron.z;
        double drx = righ.x - left.x;
        double dry = righ.y - left.y;
        double drz = righ.z - left.z;
        double dxz = Math.sqrt(dx * dx + dz * dz);
        double y = -Math.atan2(dx, dz);
        double p = -Math.atan2(dy, dxz);
        double r = Math.atan2(dry, Math.sqrt(drx * drx + drz * drz));
        this.vehicle.pivot().set_rotation(y, p, r, false);
    }
}

