/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.uni;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPoint;
import net.fexcraft.mod.fvtm.entity.ParticleEntity;
import net.fexcraft.mod.fvtm.function.part.ParticleEmitterFunction;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.sys.particle.Particle;
import net.fexcraft.mod.fvtm.sys.uni.DetachedSystem;
import net.fexcraft.mod.fvtm.sys.uni.RootVehicle;
import net.fexcraft.mod.fvtm.sys.uni.SysObj;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;
import net.fexcraft.mod.uni.world.ChunkW;
import net.fexcraft.mod.uni.world.WorldW;
import net.minecraft.client.Minecraft;

public class EntitySystem
extends DetachedSystem {
    public Thread thread;
    public static final int TARGET_TICKS = 20;
    public static final float RATE = 0.04761905f;
    private ConcurrentLinkedQueue<Emitter> emitters = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<ParticleEntity> particles = new ConcurrentLinkedQueue();
    public ConcurrentLinkedQueue<ParticleEntity> expired = new ConcurrentLinkedQueue();

    public EntitySystem(WorldW world) {
        super(world);
    }

    @Override
    public SystemManager.Systems getType() {
        return SystemManager.Systems.ENTITY;
    }

    @Override
    public boolean hasTimer() {
        return false;
    }

    @Override
    public String getRegFolderName() {
        return "entities";
    }

    @Override
    public void setupTimer(long time) {
    }

    private void update() {
        for (ParticleEntity part2 : this.particles) {
            part2.update();
        }
        this.particles.removeIf(part -> {
            if (part.expired()) {
                if (part.particle.next != null) {
                    this.expired.add((ParticleEntity)part);
                }
                return true;
            }
            return false;
        });
        if (this.expired.size() > 0) {
            for (ParticleEntity part2 : this.expired) {
                Particle particle = FvtmRegistry.PARTICLES.get(part2.particle.next);
                if (particle == null) continue;
                this.particles.add(new ParticleEntity(particle, new V3D(part2.pos), null, null));
            }
            this.expired.clear();
        }
        int mul = Minecraft.func_71410_x().field_71474_y.field_74362_aa == 0 ? 1 : (Minecraft.func_71410_x().field_71474_y.field_74362_aa == 1 ? 2 : 4);
        this.emitters.removeIf(emi -> emi.invalid(this.particles, mul));
    }

    @Override
    public void stopTimer() {
    }

    @Override
    public void unload() {
        this.emitters.clear();
        this.particles.clear();
    }

    @Override
    public void onChunkLoad(ChunkW chunk) {
    }

    @Override
    public void onChunkUnload(ChunkW chunk) {
    }

    @Override
    public void onServerTick() {
    }

    @Override
    public void onClientTick() {
        this.update();
    }

    public SysObj create(SystemRegion region, V3I pos) {
        return null;
    }

    public void add(RootVehicle vehicle) {
        if (Config.DISABLE_PARTICLES) {
            return;
        }
        for (Map.Entry<String, PartData> entry : vehicle.vehicle.data.getParts().entrySet()) {
            if (!entry.getValue().hasFunction("fvtm:particle_emitter")) continue;
            ParticleEmitterFunction func = (ParticleEmitterFunction)entry.getValue().getFunction("fvtm:particle_emitter");
            for (ParticleEmitterFunction.EmitterData data : func.emitters) {
                this.emitters.add(new Emitter(vehicle, entry.getKey(), entry.getValue(), data));
            }
        }
    }

    public static class Emitter {
        private RootVehicle vehicle;
        private ParticleEmitterFunction.EmitterData edata;
        private PartData data;
        private String part;
        private V3D off;
        private V3D dir;
        private int freq;
        private int cool;
        private double speed;

        public Emitter(RootVehicle vehicle, String key, PartData data, ParticleEmitterFunction.EmitterData edata) {
            this.vehicle = vehicle;
            this.part = key;
            this.data = data;
            this.edata = edata;
            this.freq = edata.frequency == 0 ? edata.particle.frequency : edata.frequency;
            this.dir = edata.dir == null ? edata.particle.dir : edata.dir;
            this.speed = edata.speed == null ? (double)edata.particle.speed : (double)edata.speed.floatValue();
        }

        public boolean invalid(Collection<ParticleEntity> particles, int mul) {
            if (this.edata.getConditional() == null || this.edata.getConditional().isMet(DefaultModel.RENDERDATA.set(this.vehicle.vehicle, this.data, this.part, 0.0f))) {
                ++this.cool;
                if (this.cool >= this.freq * mul) {
                    SwivelPoint point = this.vehicle.vehicle.data.getRotationPoint(this.data.getSwivelPointInstalledOn());
                    V3D pos = point.getRelativeVector(this.off).add(this.vehicle.field_70165_t, this.vehicle.field_70163_u, this.vehicle.field_70161_v);
                    V3D vdr = point.getRelativeVector(this.dir.x, this.dir.y, this.dir.z);
                    particles.add(new ParticleEntity(this.edata.particle, new V3D(pos.x, pos.y, pos.z), new V3D(vdr.x, vdr.y, vdr.z), this.speed));
                    this.cool = 0;
                }
            }
            return this.vehicle.field_70128_L;
        }
    }
}

