/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.uni;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.sign.SignSystem;
import net.fexcraft.mod.fvtm.sys.uni.DetachedSystem;
import net.fexcraft.mod.fvtm.sys.wire.WireSystem;
import net.fexcraft.mod.uni.world.ChunkW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.WorldW;
import net.fexcraft.mod.uni.world.WrapperHolder;

public class SystemManager {
    public static boolean SINGLEPLAYER;
    public static boolean PLAYERON;
    private static ConcurrentHashMap<Systems, ConcurrentHashMap<String, DetachedSystem>> SYSTEMS;
    private static ConcurrentHashMap<String, ConcurrentHashMap<Systems, DetachedSystem>> SYSTEMS_DIM;
    private static ConcurrentHashMap<String, Boolean> LOADED_DIM;

    public static void onServerTick() {
        for (ConcurrentHashMap<String, DetachedSystem> sys : SYSTEMS.values()) {
            for (DetachedSystem det : sys.values()) {
                det.onServerTick();
            }
        }
    }

    public static void onClientTick() {
        for (ConcurrentHashMap<String, DetachedSystem> sys : SYSTEMS.values()) {
            for (DetachedSystem det : sys.values()) {
                det.onClientTick();
            }
        }
    }

    public static void onChunkLoad(WorldW world, ChunkW chunk) {
        if (!SystemManager.loaded(world.dimkey())) {
            SystemManager.onAttachWorldCapabilities(world);
        }
        if (chunk == null) {
            return;
        }
        for (DetachedSystem sys : SYSTEMS_DIM.get(world.dimkey()).values()) {
            sys.onChunkLoad(chunk);
        }
    }

    public static void onChunkUnload(WorldW world, ChunkW chunk) {
        ConcurrentHashMap<Systems, DetachedSystem> systems = SYSTEMS_DIM.get(world.dimkey());
        if (systems == null) {
            return;
        }
        for (DetachedSystem sys : systems.values()) {
            sys.onChunkUnload(chunk);
        }
    }

    public static <T extends DetachedSystem> T get(Systems sysid, WorldW world) {
        if (!SYSTEMS.containsKey((Object)sysid)) {
            return null;
        }
        return (T)SYSTEMS.get((Object)sysid).get(world.dimkey());
    }

    public static <T extends DetachedSystem> T get(Systems sysid, WorldW world, Class<T> clazz) {
        if (!SYSTEMS.containsKey((Object)sysid)) {
            return null;
        }
        return (T)SYSTEMS.get((Object)sysid).get(world.dimkey());
    }

    private static boolean loaded(Object dimension) {
        Boolean bool = LOADED_DIM.get(dimension);
        return bool != null && bool != false;
    }

    public static void onAttachWorldCapabilities(WorldW world) {
        DetachedSystem sys;
        if (SystemManager.loaded(world.dimkey())) {
            return;
        }
        SINGLEPLAYER = WrapperHolder.isSinglePlayer();
        String dim = world.dimkey();
        if (!SYSTEMS_DIM.containsKey(dim)) {
            SYSTEMS_DIM.put(dim, new ConcurrentHashMap());
        }
        FvtmLogger.debug((Object)("dimension remote = " + world.isClient() + "/" + SINGLEPLAYER));
        if (world.isClient() || SINGLEPLAYER) {
            // empty if block
        }
        if (!Config.DISABLE_RAILS) {
            if (!SYSTEMS.containsKey((Object)Systems.RAIL)) {
                SYSTEMS.put(Systems.RAIL, new ConcurrentHashMap());
            }
            sys = new RailSystem(world);
            SYSTEMS.get((Object)Systems.RAIL).put(dim, sys);
            SYSTEMS_DIM.get(dim).put(Systems.RAIL, sys);
        }
        if (!Config.DISABLE_WIRES) {
            if (!SYSTEMS.containsKey((Object)Systems.WIRE)) {
                SYSTEMS.put(Systems.WIRE, new ConcurrentHashMap());
            }
            sys = new WireSystem(world);
            SYSTEMS.get((Object)Systems.WIRE).put(dim, sys);
            SYSTEMS_DIM.get(dim).put(Systems.WIRE, sys);
        }
        if (!Config.DISABLE_SIGNS) {
            if (!SYSTEMS.containsKey((Object)Systems.SIGN)) {
                SYSTEMS.put(Systems.SIGN, new ConcurrentHashMap());
            }
            sys = new SignSystem(world);
            SYSTEMS.get((Object)Systems.SIGN).put(dim, sys);
            SYSTEMS_DIM.get(dim).put(Systems.SIGN, sys);
        }
        LOADED_DIM.put(dim, true);
    }

    private static long getDate() {
        LocalDateTime midnight = LocalDateTime.of(LocalDate.now(ZoneOffset.systemDefault()), LocalTime.MIDNIGHT);
        long mid = midnight.toInstant(ZoneOffset.UTC).toEpochMilli();
        long date = Time.getDate();
        while ((mid += (long)Config.UNLOAD_INTERVAL) < date) {
        }
        return mid;
    }

    public static void onServerStarting() {
        long mid = SystemManager.getDate();
        for (Map map : SYSTEMS.values()) {
            for (DetachedSystem sys : map.values()) {
                sys.setupTimer(mid);
            }
        }
    }

    public static void onWorldLoad(WorldW world) {
        long mid = SystemManager.getDate();
        for (DetachedSystem sys : SYSTEMS_DIM.get(world.dimkey()).values()) {
            sys.setupTimer(mid);
        }
    }

    public static void onServerStopping() {
        for (Map map : SYSTEMS.values()) {
            for (DetachedSystem sys : map.values()) {
                sys.stopTimer();
                sys.unload();
            }
        }
        SYSTEMS.clear();
        SYSTEMS_DIM.clear();
        LOADED_DIM.clear();
    }

    public static void onWorldUnload(WorldW world) {
        String dim = world.dimkey();
        ConcurrentHashMap<Systems, DetachedSystem> map = SYSTEMS_DIM.get(dim);
        if (map != null) {
            for (Map.Entry<Systems, DetachedSystem> sys : map.entrySet()) {
                sys.getValue().stopTimer();
                sys.getValue().unload();
                SYSTEMS.get((Object)sys.getKey()).remove(dim);
            }
        }
        SYSTEMS_DIM.remove(dim);
        LOADED_DIM.remove(dim);
    }

    public static void syncPlayer(String dimkey, EntityW entity) {
        ConcurrentHashMap<Systems, DetachedSystem> sys = SYSTEMS_DIM.get(dimkey);
        if (sys == null) {
            return;
        }
        for (DetachedSystem value : sys.values()) {
            value.syncPlayer(entity);
        }
    }

    public static boolean active(Systems sys) {
        return SYSTEMS.containsKey((Object)sys);
    }

    static {
        SYSTEMS = new ConcurrentHashMap();
        SYSTEMS_DIM = new ConcurrentHashMap();
        LOADED_DIM = new ConcurrentHashMap();
    }

    public static enum Systems {
        RAIL,
        ROAD,
        WIRE,
        ENTITY,
        SIGN;

    }
}

