/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.uni;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.packet.Packet_TagListener;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.fvtm.sys.uni.DetachedSystem;
import net.fexcraft.mod.fvtm.sys.uni.RegionKey;
import net.fexcraft.mod.fvtm.sys.uni.SysObj;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.ChunkW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.WrapperHolder;

public class SystemRegion<R extends DetachedSystem<R, V>, V extends SysObj> {
    protected ConcurrentHashMap<V3I, V> objects = new ConcurrentHashMap();
    public ConcurrentHashMap<RegionKey, ChunkW> chucks = new ConcurrentHashMap();
    public final RegionKey key;
    public final R system;
    public long lastaccess;
    public boolean loaded;
    public int timer;

    public SystemRegion(R root, RegionKey rk) {
        this.system = root;
        this.key = rk;
    }

    public SystemRegion<R, V> load() {
        if (((DetachedSystem)this.system).getWorld().isClient()) {
            TagCW compound = TagCW.create();
            compound.set("xz", this.key.toArray());
            compound.set("sys", ((DetachedSystem)this.system).getType().ordinal());
            Packets.send(Packet_TagListener.class, "sync_reg", compound);
            return this;
        }
        File file = new File(((DetachedSystem)this.system).getSaveRoot(), "/" + ((DetachedSystem)this.system).getRegFolderName() + "/" + this.key.x + "_" + this.key.z + ".dat");
        TagCW compound = null;
        boolean failed = false;
        if (file.exists()) {
            try {
                compound = WrapperHolder.read((File)file);
            }
            catch (Throwable e) {
                failed = true;
                e.printStackTrace();
                FvtmLogger.log((Object)("FAILED TO LOAD " + (Object)((Object)((DetachedSystem)this.system).getType()) + " REGION [ " + this.key.x + ", " + this.key.z + " ]! THIS MAY BE NOT GOOD."));
                try {
                    File newfile = new File(((DetachedSystem)this.system).getSaveRoot(), "/" + ((DetachedSystem)this.system).getRegFolderName() + "/" + this.key.x + "_" + this.key.z + "_" + Time.getAsString(null, (boolean)true) + ".dat");
                    Files.copy(file.toPath(), newfile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    FvtmLogger.log((Object)"If things have gone well, created a backup copy of the 'broken' file!");
                }
                catch (Throwable thr) {
                    thr.printStackTrace();
                    FvtmLogger.log((Object)("FAILED TO CREATE BACKUP OF BROKEN " + (Object)((Object)((DetachedSystem)this.system).getType()) + " REGION"));
                }
            }
        }
        if (!file.exists() || failed) {
            compound = TagCW.create();
        }
        return this.read(compound).setAccessed();
    }

    public SystemRegion<R, V> read(TagCW compound) {
        ((DetachedSystem)this.system).readRegion(this, compound);
        this.loaded = true;
        return this;
    }

    public SystemRegion<R, V> setAccessed() {
        this.lastaccess = Time.getDate();
        return this;
    }

    public SystemRegion<R, V> save() {
        TagCW compound;
        File file = new File(((DetachedSystem)this.system).getSaveRoot(), "/" + ((DetachedSystem)this.system).getRegFolderName() + "/" + this.key.x + "_" + this.key.z + ".dat");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if ((compound = this.write(false)).empty()) {
            FvtmLogger.debug((Object)((Object)((Object)((DetachedSystem)this.system).getType()) + "-Region [" + this.key + "] has no data to save, skipping."));
            return this;
        }
        compound.set("Saved", Time.getDate());
        WrapperHolder.write((TagCW)compound, (File)file);
        FvtmLogger.debug((Object)("Saved " + (Object)((Object)((DetachedSystem)this.system).getType()) + "-Region [" + this.key + "]."));
        return this;
    }

    private TagCW write(boolean syncpkt) {
        TagCW compound = TagCW.create();
        ((DetachedSystem)this.system).writeRegion(this, compound, syncpkt);
        if (syncpkt) {
            compound.set("xz", this.key.toArray());
            compound.set("sys", ((DetachedSystem)this.system).getType().ordinal());
        }
        return compound;
    }

    public void sendSync(V3I pos) {
        Packets.sendToAllTrackingPos(Packet_TagListener.class, ((DetachedSystem)this.system).getWorld(), pos, "sync_reg", this.write(true));
    }

    public void sendSync(EntityW ent) {
        Packets.sendTo(Packet_TagListener.class, ent, "sync_reg", this.write(true));
    }

    public V get(V3I pos) {
        if (!this.key.isInRegion(pos)) {
            return ((DetachedSystem)this.system).get(pos);
        }
        return (V)((SysObj)this.objects.get(pos));
    }

    public V add(V3I pos) {
        if (!this.objects.containsKey(pos)) {
            this.objects.put(pos, ((DetachedSystem)this.system).create(this, pos));
        }
        return (V)((SysObj)this.objects.get(pos));
    }

    public void del(V3I pos) {
        V val = this.get(pos);
        if (val == null) {
            return;
        }
        val.delete();
        this.objects.remove(pos);
    }

    public Map<V3I, V> getObjects() {
        return this.objects;
    }
}

