/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.wire;

import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.sys.wire.WireRelay;
import net.fexcraft.mod.uni.tag.TagCW;

public class WireKey {
    public final V3I start_pos;
    public final V3I end_pos;
    public final String start_relay;
    public final String end_relay;

    public WireKey(WireRelay start, WireRelay end) {
        this.start_pos = start.holder.pos;
        this.start_relay = start.key;
        this.end_pos = end.holder.pos;
        this.end_relay = end.key;
    }

    public WireKey(TagCW compound) {
        this.start_pos = compound.getV3I("spos");
        this.end_pos = compound.getV3I("epos");
        this.start_relay = compound.getString("skey");
        this.end_relay = compound.getString("ekey");
    }

    public WireKey(V3I spos, String skey, V3I epos, String ekey) {
        this.start_pos = spos;
        this.start_relay = skey;
        this.end_pos = epos;
        this.end_relay = ekey;
    }

    public WireKey(V3I pos, String string) {
        this.start_pos = this.end_pos = pos;
        this.start_relay = this.end_relay = string;
    }

    public TagCW save(TagCW compound) {
        if (compound == null) {
            compound = TagCW.create();
        }
        compound.set("spos", this.start_pos, true);
        compound.set("epos", this.end_pos, true);
        compound.set("skey", this.start_relay);
        compound.set("ekey", this.end_relay);
        return compound;
    }

    public String toString() {
        return WireKey.str(this.start_pos) + ":" + this.start_relay + ":" + this.end_relay + ":" + WireKey.str(this.end_pos);
    }

    public static String str(V3I pos) {
        return pos.x + "," + pos.y + "," + pos.z;
    }

    public boolean equals(Object obj) {
        if (obj instanceof WireKey) {
            WireKey o = (WireKey)obj;
            return this.start_pos.equals((Object)o.start_pos) && this.end_pos.equals((Object)o.end_pos) && this.start_relay.endsWith(o.start_relay) && this.end_relay.equals(o.end_relay);
        }
        return String.valueOf(obj).equals(this.toString());
    }

    public WireKey opposite() {
        return new WireKey(this.end_pos, this.end_relay, this.start_pos, this.start_relay);
    }
}

