/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.ui.road;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.ui.road.RoadToolCon;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniInventory;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;

public class RoadToolCustomCon
extends ContainerInterface {
    protected int[] size = new int[]{1, 0, 0, 0, 0, 0};
    protected StackWrapper stack;
    protected String tagname;
    protected int offset;
    protected int scroll;

    public RoadToolCustomCon(JsonMap map, UniEntity player, V3I pos) {
        super(map, player, pos);
        this.stack = player.entity.getHeldItem(true);
        if (!this.stack.directTag().has("RoadLayers")) {
            this.stack.updateTag(tag -> tag.set("RoadLayers", this.size));
        } else {
            this.size = this.stack.directTag().getIntArray("RoadLayers");
        }
        this.tagname = "Custom" + RoadToolCon.fills[pos.x];
        this.offset = this.size[0] > 9 ? 81 : this.size[0] * 9;
        this.inventory = UniInventory.create((int)(this.size[0] >= 9 ? 9 : this.size[0]));
    }

    public void init() {
        int is = this.size[0] > 9 ? 9 : this.size[0];
        for (int i = 0; i < is; ++i) {
            this.root.addSlot("fvtm:roadfill", new Object[]{this.player.entity.getWorld(), this.inventory, i, 88 - this.offset + 1 + i * 18, 8, true, this.pos.x > 0});
        }
        this.fillStacks();
    }

    public Object get(String key, Object ... objs) {
        return null;
    }

    public void packet(TagCW packet, boolean client) {
        if (!packet.has("cargo")) {
            return;
        }
        switch (packet.getString("cargo")) {
            case "scroll": {
                this.saveStacks();
                this.scroll += packet.getInteger("by");
                if (this.scroll < 0) {
                    this.scroll = 0;
                }
                if (this.scroll + 9 >= this.size[0]) {
                    this.scroll = this.size[0] - 9;
                }
                this.fillStacks();
            }
        }
    }

    protected void fillStacks() {
        int j;
        if (!this.stack.directTag().has(this.tagname)) {
            return;
        }
        TagCW compound = this.stack.directTag().getCompound(this.tagname);
        for (int i = 0; i < 9 && (j = i + this.scroll) < this.size[0]; ++i) {
            if (!compound.has("Block" + j)) {
                this.inventory.set(i, StackWrapper.EMPTY);
                continue;
            }
            this.inventory.set(i, UniStack.createStack((Object)compound.getCompound("Block" + j)));
        }
    }

    protected void saveStacks() {
        try {
            TagCW com = this.stack.directTag().has(this.tagname) ? this.stack.directTag().getCompound(this.tagname).copy() : TagCW.create();
            com.set("Size", this.size[0]);
            int is = this.size[0] > 9 ? 9 : this.size[0];
            for (int i = 0; i < is; ++i) {
                int j = i + this.scroll;
                if (this.inventory.empty(i)) {
                    com.rem("Block" + j);
                    continue;
                }
                StackWrapper stack = this.inventory.get(i);
                TagCW tag2 = TagCW.create();
                stack.save(tag2);
                com.set("Block" + j, tag2);
            }
            this.stack.updateTag(tag -> tag.set(this.tagname, com));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onClosed() {
        super.onClosed();
        this.saveStacks();
    }
}

