/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.mc.registry.ItemBlock16;
import net.fexcraft.lib.mc.render.FCLItemModel;
import net.fexcraft.lib.mc.render.FCLItemModelLoader;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.block.Asphalt;
import net.fexcraft.mod.fvtm.block.ConstructorBlock;
import net.fexcraft.mod.fvtm.block.ConstructorEntity;
import net.fexcraft.mod.fvtm.block.ContainerBlock;
import net.fexcraft.mod.fvtm.block.ContainerEntity;
import net.fexcraft.mod.fvtm.block.FuelFillerBlock;
import net.fexcraft.mod.fvtm.block.FuelFillerEntity;
import net.fexcraft.mod.fvtm.block.VehicleLiftBlock;
import net.fexcraft.mod.fvtm.block.VehicleLiftEntity;
import net.fexcraft.mod.fvtm.data.Cloth;
import net.fexcraft.mod.fvtm.data.Consumable;
import net.fexcraft.mod.fvtm.data.Decoration;
import net.fexcraft.mod.fvtm.data.Material;
import net.fexcraft.mod.fvtm.data.RailGauge;
import net.fexcraft.mod.fvtm.data.Sign;
import net.fexcraft.mod.fvtm.data.WireType;
import net.fexcraft.mod.fvtm.data.addon.Addon;
import net.fexcraft.mod.fvtm.data.addon.AddonClass;
import net.fexcraft.mod.fvtm.data.addon.AddonLocation;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.data.block.BlockUtil;
import net.fexcraft.mod.fvtm.data.block.MultiBlock;
import net.fexcraft.mod.fvtm.data.container.Container;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.entity.RailMarker;
import net.fexcraft.mod.fvtm.entity.RoadMarker;
import net.fexcraft.mod.fvtm.item.BlockItem;
import net.fexcraft.mod.fvtm.item.ClothItem;
import net.fexcraft.mod.fvtm.item.ConsumableItem;
import net.fexcraft.mod.fvtm.item.ContainerItem;
import net.fexcraft.mod.fvtm.item.DecorationItem;
import net.fexcraft.mod.fvtm.item.MaterialItem;
import net.fexcraft.mod.fvtm.item.MultiBlockItem;
import net.fexcraft.mod.fvtm.item.PartItem;
import net.fexcraft.mod.fvtm.item.RailGaugeItem;
import net.fexcraft.mod.fvtm.item.RailPresetItem;
import net.fexcraft.mod.fvtm.item.SignItem;
import net.fexcraft.mod.fvtm.item.VehicleItem;
import net.fexcraft.mod.fvtm.item.WireItem;
import net.fexcraft.mod.fvtm.model.ModelData;
import net.fexcraft.mod.fvtm.model.Transforms;
import net.fexcraft.mod.fvtm.model.content.BlockModel;
import net.fexcraft.mod.fvtm.model.program.ConditionalPrograms;
import net.fexcraft.mod.fvtm.model.program.DefaultPrograms12;
import net.fexcraft.mod.fvtm.model.program.WirePrograms;
import net.fexcraft.mod.fvtm.render.CatalogRenderer;
import net.fexcraft.mod.fvtm.render.ContainerBlockRenderer;
import net.fexcraft.mod.fvtm.render.FuelFillerRenderer;
import net.fexcraft.mod.fvtm.render.VehicleLiftRenderer;
import net.fexcraft.mod.fvtm.render.block.BlkItemModel12;
import net.fexcraft.mod.fvtm.render.block.FvtmBlockModelLoader;
import net.fexcraft.mod.fvtm.util.ExternalTextureLoader;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.fvtm.util.TexUtil;
import net.fexcraft.mod.fvtm.util.TransformMap;
import net.fexcraft.mod.fvtm.util.ZipUtils;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.FclRecipe;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;
import net.fexcraft.mod.uni.impl.IWI;
import net.fexcraft.mod.uni.impl.SWI;
import net.fexcraft.mod.uni.inv.ItemWrapper;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.world.WorldW;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.AbstractResourcePack;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class ResourcesImpl
extends FvtmResources {
    private static TreeMap<String, Boolean> LOADED_MODS = new TreeMap();
    private final ASMDataTable asmdata;
    private Field respackfile = null;

    public ResourcesImpl(ASMDataTable asmdata) {
        this.asmdata = asmdata;
    }

    @Override
    public void searchASMPacks() {
        this.asmdata.getAll(AddonClass.class.getCanonicalName()).forEach(entry -> {
            try {
                Class<?> clazz = Class.forName(entry.getClassName());
                AddonClass adn = clazz.getAnnotation(AddonClass.class);
                String regname = adn.registryname();
                if (regname.contains(":")) {
                    regname = regname.split(":")[1];
                }
                String res = clazz.getClassLoader().getResource("assets/" + regname + "/addonpack.fvtm").toString();
                res = res.substring(res.indexOf("file:/") + 6, res.indexOf("!"));
                JsonMap map = JsonHandler.parse((InputStream)clazz.getClassLoader().getResourceAsStream("assets/" + regname + "/addonpack.fvtm"));
                FvtmRegistry.ADDONS.add(new Addon(new File(res), regname.equals("fvtm") ? AddonLocation.INTERNAL : AddonLocation.MODJAR).parse(map));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public boolean searchPacksInResourcePacks() {
        boolean failed = false;
        if (EnvInfo.CLIENT) {
            try {
                this.respackfile = ReflectionHelper.findField(AbstractResourcePack.class, (String)"resourcePackFile", (String)"field_110597_b");
            }
            catch (Exception e) {
                failed = true;
                FvtmLogger.LOGGER.info("Failed to get field. [RESPACKLOADER:ERR:00]");
                FvtmLogger.LOGGER.info("Addon loading from ResourcePacks will be limited.");
            }
            catch (Error e) {
                failed = true;
                FvtmLogger.LOGGER.info("Failed to get field. [RESPACKLOADER:ERR:01]");
                FvtmLogger.LOGGER.info("Addon loading from ResourcePacks will be limited.");
            }
            if (this.respackfile != null) {
                for (ResourcePackRepository.Entry entry : Minecraft.func_71410_x().func_110438_M().func_110609_b()) {
                    try {
                        this.checkResPackEntry(entry.func_110514_c());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return failed;
    }

    @SideOnly(value=Side.CLIENT)
    private void checkResPackEntry(IResourcePack pack) {
        for (String str : pack.func_110587_b()) {
            ResourceLocation resloc = new ResourceLocation(str + ":addonpack.fvtm");
            if (!pack.func_110589_b(resloc)) continue;
            try {
                Addon addon = new Addon((File)this.respackfile.get(pack), AddonLocation.RESOURCEPACK);
                if (addon.getFile().isDirectory()) {
                    addon.parse(JsonHandler.parse((File)new File(addon.getFile(), "assets/" + str + "/addonpack.fvtm")));
                } else {
                    JsonArray array = ZipUtils.getValuesAt(addon.getFile(), "assets", "addonpack.fvtm");
                    for (JsonValue value : (List)array.value) {
                        JsonMap map;
                        if (!value.isMap() || ResourcesImpl.isDuplicateOrInvalidPack(map = value.asMap())) continue;
                        addon.parse(map);
                        break;
                    }
                }
                FvtmRegistry.ADDONS.register(addon);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void loadPackTextures() {
        ArrayList<Addon> lites = new ArrayList<Addon>();
        for (Addon addon : FvtmRegistry.ADDONS) {
            if (addon.getLocation() != AddonLocation.CONFIGPACK) continue;
            lites.add(addon);
        }
        if (lites.size() == 0) {
            return;
        }
        for (Addon addon : lites) {
            if (addon.getFile().isDirectory()) {
                TexUtil.searchIn(addon, new File(addon.getFile(), "assets/" + addon.getID().id() + "/textures/"), null);
                continue;
            }
            TexUtil.searchInZip(addon);
        }
    }

    @Override
    public void createContentBlocks() {
        FvtmRegistry.BLOCKS.forEach(block -> {
            net.minecraft.block.Block blk = (net.minecraft.block.Block)block.getBlock();
            blk.setRegistryName(block.getIDS());
            blk.func_149663_c(block.getIDS());
            FvtmRegistry.CONTENT_BLOCKS.put(block.getID(), blk);
        });
    }

    @Override
    public void createContentItems() {
        FvtmRegistry.MATERIALS.forEach(mat -> mat.setItemWrapper(this.wrapwrapper(mat.getID(), new MaterialItem((Material)mat))));
        FvtmRegistry.CONSUMABLES.forEach(con -> con.setItemWrapper(this.wrapwrapper(con.getID(), (Item)new ConsumableItem((Consumable)con))));
        FvtmRegistry.PARTS.forEach(part -> part.setItemWrapper(this.wrapwrapper(part.getID(), new PartItem((Part)part))));
        FvtmRegistry.VEHICLES.forEach(veh -> veh.setItemWrapper(this.wrapwrapper(veh.getID(), new VehicleItem((Vehicle)veh))));
        FvtmRegistry.BLOCKS.forEach(blk -> blk.setItemWrapper(this.wrapwrapper(blk.getID(), (Item)new BlockItem((Block)blk))));
        FvtmRegistry.MULTIBLOCKS.forEach(mb -> mb.setItemWrapper(this.wrapwrapper(mb.getID(), new MultiBlockItem((MultiBlock)mb))));
        FvtmRegistry.CLOTHES.forEach(cth -> cth.setItemWrapper(this.wrapwrapper(cth.getID(), (Item)new ClothItem((Cloth)cth))));
        FvtmRegistry.WIRES.forEach(wire -> wire.setItemWrapper(this.wrapwrapper(wire.getID(), new WireItem((WireType)wire))));
        FvtmRegistry.CONTAINERS.forEach(con -> con.setItemWrapper(this.wrapwrapper(con.getID(), new ContainerItem((Container)con))));
        FvtmRegistry.RAILGAUGES.forEach(rail -> {
            rail.setItemWrapper(this.wrapwrapper(rail.getID(), new RailGaugeItem((RailGauge)rail)));
            if (rail.getPresets() == null) {
                return;
            }
            for (RailGauge.Preset preset : rail.getPresets()) {
                this.wrapwrapper(IDLManager.getIDLCached((String)(rail.getIDS() + "." + preset.name.toLowerCase())), new RailPresetItem((RailGauge)rail, preset));
            }
        });
        FvtmRegistry.DECORATIONS.forEach(deco -> deco.setItemWrapper(this.wrapwrapper(deco.getID(), new DecorationItem((Decoration)deco))));
        FvtmRegistry.SIGNS.forEach(sign -> sign.setItemWrapper(this.wrapwrapper(sign.getID(), new SignItem((Sign)sign))));
    }

    @Override
    public void registerFvtmRecipes() {
        String blockcat = "recipe.fvtm.blocks";
        FclRecipe.newBuilder((String)blockcat).output((Object)new ItemStack((net.minecraft.block.Block)ConstructorBlock.INSTANCE)).add((Object)new ItemStack(Blocks.field_150339_S)).add((Object)new ItemStack(Items.field_151132_bS, 4)).add((Object)new ItemStack(Items.field_151107_aW, 8)).add((Object)new ItemStack(Items.field_151137_ax, 16)).add((Object)new ItemStack(Items.field_151122_aG, 2)).add((Object)new ItemStack(Blocks.field_150442_at, 8)).register();
        FclRecipe.newBuilder((String)blockcat).output((Object)new ItemStack((net.minecraft.block.Block)VehicleLiftBlock.INSTANCE)).add((Object)new ItemStack(Blocks.field_150339_S, 2)).add((Object)new ItemStack(Items.field_151042_j, 8)).add((Object)new ItemStack(Items.field_151132_bS, 2)).add((Object)new ItemStack(Items.field_151107_aW, 4)).add((Object)new ItemStack(Items.field_151137_ax, 4)).add((Object)new ItemStack(Items.field_151122_aG, 1)).add((Object)new ItemStack(Blocks.field_150442_at, 2)).add((Object)new ItemStack((net.minecraft.block.Block)Blocks.field_150331_J, 2)).register();
        FclRecipe.newBuilder((String)blockcat).output((Object)new ItemStack((net.minecraft.block.Block)FuelFillerBlock.INSTANCE)).add((Object)new ItemStack(Blocks.field_150339_S)).add((Object)new ItemStack((net.minecraft.block.Block)Blocks.field_150438_bZ, 2)).add((Object)new ItemStack(Blocks.field_150430_aB, 4)).register();
    }

    private ItemWrapper wrapwrapper(IDL id, Item item) {
        IWI wrapper = new IWI(item);
        FvtmRegistry.CONTENT_ITEMS.put(id, (ItemWrapper)wrapper);
        FvtmRegistry.ITEMS.put(id.colon(), (ItemWrapper)wrapper);
        return wrapper;
    }

    @Override
    public ItemWrapper getItemWrapper(String id) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(id));
        return item == null ? null : new IWI(item);
    }

    @Override
    public StackWrapper newStack0(ItemWrapper item) {
        return new SWI(item);
    }

    @Override
    public void initModelPrograms() {
        Transforms.GET_TRANSFORM = args -> {
            switch (args[0]) {
                case "translation": 
                case "translate": 
                case "trans": 
                case "tra": 
                case "tr": {
                    return new Transforms.TF_Translate(Float.parseFloat(args[1]), Float.parseFloat(args[2]), Float.parseFloat(args[3]));
                }
                case "rotation": 
                case "rotate": 
                case "rot": {
                    return new Transforms.TF_Rotate(Float.parseFloat(args[1]), Float.parseFloat(args[2]), Float.parseFloat(args[3]), Float.parseFloat(args[4]));
                }
                case "scale": {
                    if (((String[])args).length < 3) {
                        float scale = Float.parseFloat(args[1]);
                        return new Transforms.TF_Scale(scale, scale, scale);
                    }
                    return new Transforms.TF_Scale(Float.parseFloat(args[1]), Float.parseFloat(args[2]), Float.parseFloat(args[3]));
                }
                case "gl_rescale_normal": 
                case "rescale_normal": {
                    return Transforms.TF_RESCALE_NORMAL;
                }
            }
            return null;
        };
        DefaultPrograms12.init();
        ConditionalPrograms.init();
        WirePrograms.init();
    }

    @Override
    public void initModels() {
        ArrayList<String> tt = new ArrayList<String>();
        for (ItemCameraTransforms.TransformType value : ItemCameraTransforms.TransformType.values()) {
            tt.add(value.name());
        }
        TransformMap.TYPES = tt.toArray(new String[0]);
        super.initModels();
        ResourcesImpl.getModel("baked|fvtm:models/block/vpinfo.fmf", new ModelData(), BlockModel.class);
    }

    @Override
    public InputStream getAssetInputStream(IDL loc, boolean log) {
        try {
            InputStream stream = Minecraft.func_71410_x().func_110442_L().func_110536_a((ResourceLocation)loc).func_110527_b();
            if (stream != null) {
                int read;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((read = stream.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
                stream = new ByteArrayInputStream(out.toByteArray());
            }
            return stream;
        }
        catch (Throwable e) {
            if (log) {
                e.printStackTrace();
            }
            return null;
        }
    }

    @Override
    public boolean isModPresent(String id) {
        if (LOADED_MODS.containsKey(id)) {
            return LOADED_MODS.get(id);
        }
        boolean bool = Loader.isModLoaded((String)id);
        LOADED_MODS.put(id, bool);
        return bool;
    }

    @Override
    public IDL getExternalTexture(String custom) {
        return ExternalTextureLoader.get(custom);
    }

    @Override
    public void registerFvtmBlocks() {
        ConstructorBlock.INSTANCE = new ConstructorBlock();
        ConstructorBlock.ITEM = new ItemBlock16((net.minecraft.block.Block)ConstructorBlock.INSTANCE);
        ConstructorBlock.ITEM.setRegistryName(ConstructorBlock.INSTANCE.getRegistryName());
        ConstructorBlock.ITEM.func_77655_b(ConstructorBlock.INSTANCE.func_149739_a());
        GameRegistry.registerTileEntity(ConstructorEntity.class, (ResourceLocation)new ResourceLocation("fvtm:constructor"));
        FuelFillerBlock.INSTANCE = new FuelFillerBlock();
        FuelFillerBlock.ITEM = new ItemBlock16((net.minecraft.block.Block)FuelFillerBlock.INSTANCE);
        FuelFillerBlock.ITEM.setRegistryName(FuelFillerBlock.INSTANCE.getRegistryName());
        FuelFillerBlock.ITEM.func_77655_b(FuelFillerBlock.INSTANCE.func_149739_a());
        GameRegistry.registerTileEntity(FuelFillerEntity.class, (ResourceLocation)new ResourceLocation("fvtm:fuel_filler"));
        VehicleLiftBlock.INSTANCE = new VehicleLiftBlock();
        VehicleLiftBlock.ITEM = new ItemBlock16((net.minecraft.block.Block)VehicleLiftBlock.INSTANCE);
        VehicleLiftBlock.ITEM.setRegistryName(VehicleLiftBlock.INSTANCE.getRegistryName());
        VehicleLiftBlock.ITEM.func_77655_b(VehicleLiftBlock.INSTANCE.func_149739_a());
        GameRegistry.registerTileEntity(VehicleLiftEntity.class, (ResourceLocation)VehicleLiftBlock.INSTANCE.getRegistryName());
        Asphalt.INSTANCE = new Asphalt();
        Asphalt.ITEM = new Asphalt.AsphaltItem(Asphalt.INSTANCE);
        ContainerBlock.INSTANCE = new ContainerBlock();
        GameRegistry.registerTileEntity(ContainerEntity.class, (ResourceLocation)new ResourceLocation("fvtm:container"));
        if (EnvInfo.CLIENT) {
            this.registerTESR();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void registerTESR() {
        ClientRegistry.bindTileEntitySpecialRenderer(VehicleLiftEntity.class, (TileEntitySpecialRenderer)new VehicleLiftRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(ContainerEntity.class, (TileEntitySpecialRenderer)new ContainerBlockRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(ConstructorEntity.class, (TileEntitySpecialRenderer)new CatalogRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(FuelFillerEntity.class, (TileEntitySpecialRenderer)new FuelFillerRenderer());
    }

    @Override
    public void registerFvtmItems() {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public double getMouseSensitivity() {
        return Minecraft.func_71410_x().field_71474_y.field_74341_c;
    }

    @Override
    public Object getBlockMaterial(String key, boolean allownull) {
        return BlockUtil.getMaterial(key, allownull);
    }

    @Override
    public void spawnRoadMarker(WorldW world, QV3D vector, UUID nid) {
        RoadMarker marker = new RoadMarker((World)world.local(), nid);
        marker.position = vector;
        marker.func_70107_b(vector.vec.x, vector.vec.y + 1.0, vector.vec.z);
        ((World)world.direct()).func_72838_d((Entity)marker);
    }

    @Override
    public void spawnRailMarker(WorldW world, QV3D vector, UUID nid) {
        RailMarker marker = new RailMarker((World)world.local(), nid);
        marker.position = vector;
        marker.func_70107_b(vector.vec.x, vector.vec.y, vector.vec.z);
        ((World)world.direct()).func_72838_d((Entity)marker);
    }

    @Override
    public void linkItemContainer(ItemWrapper wrap) {
        Item item = (Item)wrap.local();
        if (item instanceof MaterialItem) {
            Material mat = ((MaterialItem)item).getContent();
            if (mat.getItemContainer() != null) {
                item.func_77642_a(Item.func_111206_d((String)mat.getItemContainer()));
            }
            if (mat.getOreDictId() != null) {
                OreDictionary.registerOre((String)mat.getOreDictId(), (Item)((Item)mat.getItemWrapper().direct()));
            }
        }
        if (item instanceof ConsumableItem) {
            Consumable con = ((ConsumableItem)item).getContent();
            if (con.getItemContainer() != null) {
                item.func_77642_a(Item.func_111206_d((String)con.getItemContainer()));
            }
            if (con.getOreDictId() != null) {
                OreDictionary.registerOre((String)con.getOreDictId(), (Item)((Item)con.getItemWrapper().direct()));
            }
        }
        if (item instanceof BlockItem) {
            Block blk = ((BlockItem)item).getContent();
            if (blk.getItemContainer() != null) {
                item.func_77642_a(Item.func_111206_d((String)blk.getItemContainer()));
            }
            if (blk.getOreDictId() != null) {
                OreDictionary.registerOre((String)blk.getOreDictId(), (Item)((Item)blk.getItemWrapper().direct()));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static InputStream getModelInputStream(ResourceLocation resloc, boolean log) {
        try {
            return Minecraft.func_71410_x().func_110442_L().func_110536_a(resloc).func_110527_b();
        }
        catch (IOException e) {
            if (log) {
                e.printStackTrace();
            }
            return null;
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<net.minecraft.block.Block> event) {
        IForgeRegistry reg = event.getRegistry();
        for (Object block : FvtmRegistry.CONTENT_BLOCKS.values()) {
            reg.register((IForgeRegistryEntry)((net.minecraft.block.Block)block));
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry reg = event.getRegistry();
        for (ItemWrapper item : FvtmRegistry.CONTENT_ITEMS.values()) {
            reg.register((IForgeRegistryEntry)item.local());
        }
        if (EnvInfo.CLIENT) {
            for (ItemWrapper item : FvtmRegistry.CONTENT_ITEMS.values()) {
                this.regItemModelLoc((Item)item.local());
            }
        }
    }

    private void regItemModelLoc(Item item) {
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).getContent();
            if (!block.hasPlainModel() && !block.noCustomItemModel()) {
                FCLItemModelLoader.addItemModel((ResourceLocation)((ResourceLocation)block.getID().local()), (FCLItemModel)BlkItemModel12.INSTANCE);
            }
            if (block.getModelData().getBoolean("Baked", false)) {
                FvtmBlockModelLoader.BLOCKS.put(block.getID().space() + ":models/block/" + block.getID().id(), block);
            }
            int var = block.getBlockType().getMetaVariants();
            for (int v = 0; v < var; ++v) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)v, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(item.getRegistryName() + "_" + v), "inventory"));
            }
            if (var == 0) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
            }
            return;
        }
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }
}

