/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util.ess;

import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.vehicle.EntitySystem;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleType;
import net.fexcraft.mod.fvtm.function.part.EngineFunction;
import net.fexcraft.mod.fvtm.handler.WheelInstallationHandler;
import net.fexcraft.mod.fvtm.sys.pro.ULandVehicle;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.MessageSender;
import net.fexcraft.mod.uni.world.WorldW;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class BasicSpawnSystem
extends EntitySystem {
    public static final String[] WHEELINDEX = new String[]{"left_back_wheel", "right_back_wheel", "right_front_wheel", "left_front_wheel"};
    public static final String[] TRAILERWHEELINDEX = new String[]{WHEELINDEX[0], WHEELINDEX[1]};

    @Override
    public String getId() {
        return "uni12";
    }

    @Override
    public String getName() {
        return "Advanced / U12 Prototype";
    }

    @Override
    public boolean validFor(VehicleType type) {
        return type == VehicleType.LAND;
    }

    @Override
    public void spawn(MessageSender placer, WorldW world, V3D pos, VehicleData data, StackWrapper stack) {
        EntityW ent = (EntityW)placer;
        EntityPlayer player = (EntityPlayer)ent.local();
        ((World)world.local()).func_72838_d((Entity)new ULandVehicle((World)world.local(), data, new V3D(pos.x, pos.y + 2.0, pos.z), player, -1));
        if (!player.field_71075_bZ.field_75098_d) {
            stack.count(stack.count() - 1);
        }
    }

    @Override
    public boolean canSpawn(MessageSender placer, WorldW world, V3D pos, VehicleData data, StackWrapper stack) {
        switch (((Vehicle)data.getType()).getVehicleType()) {
            case LAND: {
                return BasicSpawnSystem.validToSpawn(placer, stack, data);
            }
        }
        return false;
    }

    public static boolean validToSpawn(MessageSender placer, StackWrapper stack, VehicleData data) {
        String[] index = ((Vehicle)data.getType()).isTrailer() ? TRAILERWHEELINDEX : WHEELINDEX;
        boolean failed = false;
        boolean tireinfo = false;
        for (String str : index) {
            PartData part;
            String trailer;
            String string = trailer = ((Vehicle)data.getType()).isTrailer() ? "&9Trailer" : "&9Vehicle";
            if (!data.getWheelPositions().containsKey(str)) {
                placer.send(trailer + " is missing a wheel! &7&o" + str);
                failed = true;
            }
            if (!((WheelInstallationHandler.WheelData)((Part)(part = data.getPart(str)).getType()).getInstallHandlerData()).hasTire()) {
                part = data.getPart(str + ":tire");
            }
            if (part.hasFunction("fvtm:tire")) continue;
            placer.send(trailer + " is missing a &avalid &9tire! &7&o" + str);
            failed = true;
            tireinfo = true;
        }
        if (tireinfo) {
            placer.send("&bU12/Basic vehicles need tire/wheel parts with a TireFunction attached!");
        }
        if (!((Vehicle)data.getType()).isTrailer()) {
            if (!data.hasPart("engine")) {
                placer.send("&9Vehicle does not have an Engine installed!");
            } else {
                EngineFunction func = (EngineFunction)data.getFunctionInPart("engine", "fvtm:engine");
                if (func == null) {
                    placer.send("&cInstalled engine has no function!");
                } else if (func.getTorqueChart() == null) {
                    placer.send("&cInstalled engine is not valid for the Basic System.");
                    placer.send("&7&oInstall another engine or try the Legacy Entities!");
                    failed = true;
                }
            }
            if (!data.hasPart("transmission")) {
                placer.send("&9Vehicle does not have a Transmission installed!");
            } else if (data.getFunctionInPart("transmission", "fvtm:transmission") == null) {
                placer.send("&cInstalled transmission has no function!");
                failed = true;
            }
        }
        if (!((Vehicle)data.getType()).isTrailer() && !data.hasPart("engine")) {
            placer.send("&9Vehicle does not have an Engine installed!");
        }
        if (!((Vehicle)data.getType()).isTrailer() && data.getSeats().size() < 1) {
            placer.send("&9Vehicle does not have any Seats!");
            failed = true;
        }
        return !failed;
    }
}

