/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util.script;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.lib.script.ScrAction;
import net.fexcraft.lib.script.ScrElm;
import net.fexcraft.lib.script.Script;
import net.fexcraft.lib.script.elm.BoolElm;
import net.fexcraft.lib.script.elm.IntElm;
import net.fexcraft.mod.fvtm.block.generated.MultiblockTickableTE;
import net.fexcraft.mod.fvtm.block.generated.MultiblockTileEntity;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.data.block.BlockData;
import net.fexcraft.mod.fvtm.data.block.CraftBlockScript;
import net.fexcraft.mod.fvtm.data.block.MultiBlockData;
import net.fexcraft.mod.fvtm.data.inv.InvHandler;
import net.fexcraft.mod.fvtm.gui.block.GBCElm;
import net.fexcraft.mod.fvtm.util.script.BlockScriptContext;
import net.fexcraft.mod.fvtm.util.script.DefaultCraftBlockScript;
import net.fexcraft.mod.fvtm.util.script.FSBlockScript;
import net.fexcraft.mod.uni.tag.TagCW;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class DefaultCraftBlockFS
extends CraftBlockScript {
    protected FSBlockScript scriptwrapper;
    protected BlockScriptContext context;
    protected Script script;
    protected boolean hasPrepare;
    protected boolean hasRunning;
    protected boolean hasConsume;
    protected boolean hasReady;
    protected ScrAction prepare;
    protected ScrAction running;
    protected ScrAction consume;
    protected ScrAction ready;
    private boolean auto_recipe_chooser;
    private boolean instant;
    private ScrElm process_speed;
    private ScrElm cooldown_speed;
    private ScrElm process_time;
    private List<Object[]> uielms = new ArrayList<Object[]>();
    protected ScrElm add_def_ui;
    protected ScrElm add_def_itemview;
    protected ScrElm add_def_choose;

    public DefaultCraftBlockFS(JsonObject obj) {
        this.scriptwrapper = new FSBlockScript(obj);
    }

    @Override
    public void read(MultiBlockData data, TagCW tag) {
        if (this.script == null) {
            this.scriptwrapper.init(data);
            this.script = this.scriptwrapper.script();
            this.context = this.scriptwrapper.context();
            this.prepare = (ScrAction)this.script.blocks.get("prepare");
            this.hasPrepare = this.prepare != null;
            this.running = (ScrAction)this.script.blocks.get("running");
            this.hasRunning = this.running != null;
            this.consume = (ScrAction)this.script.blocks.get("consume");
            this.hasConsume = this.consume != null;
            this.ready = (ScrAction)this.script.blocks.get("ready");
            this.hasReady = this.ready != null;
            this.auto_recipe_chooser = this.script.getLocalScriptElm("auto_recipe_chooser", () -> new BoolElm(true)).scr_bln();
            this.instant = this.script.getLocalScriptElm("instant", () -> new BoolElm(true)).scr_bln();
            this.process_speed = this.script.getLocalScriptElm("process_speed", () -> new IntElm(1));
            this.cooldown_speed = this.script.getLocalScriptElm("cooldown_speed", () -> new IntElm(100));
            this.process_time = this.script.getLocalScriptElm("process_time", () -> new IntElm(100));
            this.context.exes.put("addUIElement", (block, args) -> {
                GBCElm elm = GBCElm.by(((ScrElm)args.get(0)).scr_str());
                if (elm != null) {
                    Object[] objs = new Object[args.size()];
                    objs[0] = elm;
                    for (int i = 1; i < args.size(); ++i) {
                        objs[i] = ((ScrElm)args.get(i)).scr_str();
                    }
                    this.uielms.add(objs);
                }
                return ScrElm.TRUE;
            });
            this.context.exes.put("addChooseElements", (block, args) -> {
                DefaultCraftBlockScript.addChooseElements(this.uielms);
                return ScrElm.TRUE;
            });
            this.context.exes.put("sync", (block, args) -> {
                if (this.context.entity() == null || this.context.entity().func_145831_w().field_72995_K) {
                    return ScrElm.FALSE;
                }
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74778_a("elm_sync", ((ScrElm)args.get(0)).scr_str());
                compound.func_74768_a("elm_val", data.getInventory(((ScrElm)args.get(0)).scr_str()).getVarValue());
                super.sendPacket(this.context.entity(), compound);
                return ScrElm.TRUE;
            });
            this.context.exes.put("varValue", (block, args) -> {
                InvHandler handler = data.getInventory(((ScrElm)args.get(0)).scr_str());
                if (args.size() > 1) {
                    if (handler != null) {
                        handler.setVarValue(block.getElm(((ScrElm)args.get(1)).scr_str(), null).scr_int());
                        return ScrElm.TRUE;
                    }
                    return ScrElm.FALSE;
                }
                return handler == null ? ScrElm.NULL : ScrElm.wrap((Object)handler.getVarValue());
            });
            this.context.exes.put("varCapacity", (block, args) -> {
                InvHandler handler = data.getInventory(((ScrElm)args.get(0)).scr_str());
                return handler == null ? ScrElm.NULL : ScrElm.wrap((Object)handler.capacity());
            });
            this.context.exes.put("resetRecipe", (block, args) -> {
                this.resetRecipe();
                return ScrElm.TRUE;
            });
            if (this.script.blocks.containsKey("init")) {
                ((ScrAction)this.script.blocks.get("init")).process(new ScrElm[]{this.context});
            }
            Print.debug((Object)this.script);
            this.add_def_ui = this.script.getLocalScriptElm("def_ui_elements", () -> new BoolElm(true));
            this.add_def_itemview = this.script.getLocalScriptElm("def_ui_itemview", () -> new BoolElm(true));
            this.add_def_choose = this.script.getLocalScriptElm("def_ui_choose", () -> new BoolElm(true));
        }
        super.read(data, tag);
        if (this.scriptwrapper.hasLoad) {
            this.scriptwrapper.load.process();
        }
    }

    @Override
    public TagCW write(MultiBlockData data, TagCW compound) {
        super.write(data, compound);
        if (this.scriptwrapper.hasSave) {
            this.scriptwrapper.save.process();
        }
        return compound;
    }

    @Override
    public boolean autoRecipeChooser() {
        return this.auto_recipe_chooser;
    }

    @Override
    public int cooldown() {
        return this.cooldown;
    }

    @Override
    public boolean instant() {
        return this.instant;
    }

    @Override
    public boolean ready(MultiblockTickableTE tile) {
        if (this.hasReady) {
            return this.ready.process(new ScrElm[]{this.context.update(tile)}).scr_bln();
        }
        return true;
    }

    @Override
    public int process_speed() {
        return this.process_speed.scr_int();
    }

    @Override
    public int cooldown_speed() {
        return this.cooldown_speed.scr_int();
    }

    @Override
    public boolean update_client() {
        return false;
    }

    @Override
    public void prepare(MultiblockTickableTE tile) {
        if (this.hasPrepare) {
            this.prepare.process(new ScrElm[]{this.scriptwrapper.context().update(tile)});
        }
    }

    @Override
    public void running(MultiblockTickableTE tile) {
        if (this.hasRunning) {
            this.running.process(new ScrElm[]{this.scriptwrapper.context().update(tile)});
        }
    }

    @Override
    public boolean consume(MultiBlockData data, String id, int amount, boolean simulate) {
        InvHandler handler = data.getInventory(id);
        if (handler == null) {
            return false;
        }
        if (this.hasConsume) {
            return this.consume.process(new ScrElm[]{this.scriptwrapper.context(), ScrElm.wrap((Object)handler.getVarValue()), ScrElm.wrap((Object)amount), ScrElm.wrap((Object)simulate)}).scr_bln();
        }
        if (simulate) {
            return handler.getVarValue() >= amount;
        }
        handler.setVarValue(handler.getVarValue() - amount);
        return true;
    }

    @Override
    public int process_time() {
        return this.process_time.scr_int();
    }

    @Override
    public List<Object[]> getUIElements(BlockData bdata, MultiBlockData mdata) {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        if (this.add_def_ui.scr_bln()) {
            if (((Block)bdata.getType()).isTickable()) {
                list.add(new Object[]{GBCElm.ELM_LEFT_TEXT, "#status#"});
                list.add(new Object[]{GBCElm.ELM_RIGHT_PROGRESS, "#progress#"});
            }
            list.add(new Object[]{GBCElm.ELM_LEFT_TEXT, "gui.fvtm.block_craft.recipe"});
            list.add(new Object[]{GBCElm.ELM_RIGHT_TEXT, "#recipe#"});
            if (this.add_def_itemview.scr_bln()) {
                list.add(new Object[]{GBCElm.ITEMVIEW});
            }
            if (this.add_def_choose.scr_bln()) {
                DefaultCraftBlockScript.addChooseElements(list);
            }
        }
        list.addAll(this.uielms);
        return list;
    }

    @Override
    public void onUpdatePacket(TileEntity tile, NBTTagCompound compound) {
        if (tile.func_145831_w().field_72995_K) {
            if (!compound.func_74764_b("elm_sync")) {
                return;
            }
            InvHandler handler = ((MultiblockTileEntity)tile).getMultiBlockData().getInventory(compound.func_74779_i("elm_sync"));
            if (handler == null) {
                return;
            }
            handler.setVarValue(compound.func_74762_e("elm_val"));
        }
    }
}

