/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util.script;

import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.mc.utils.Print;
import net.fexcraft.lib.script.ScrAction;
import net.fexcraft.lib.script.ScrElm;
import net.fexcraft.lib.script.Script;
import net.fexcraft.mod.fvtm.block.generated.MultiblockTickableTE;
import net.fexcraft.mod.fvtm.data.block.BlockScript;
import net.fexcraft.mod.fvtm.data.block.MB_Interact;
import net.fexcraft.mod.fvtm.data.block.MultiBlockData;
import net.fexcraft.mod.fvtm.event.EventHandler;
import net.fexcraft.mod.fvtm.util.script.BlockScriptContext;
import net.fexcraft.mod.uni.tag.TagCW;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class FSBlockScript
implements BlockScript {
    private Script script;
    private String id;
    private ResourceLocation resloc;
    protected ScrAction update;
    protected ScrAction save;
    protected ScrAction load;
    protected ScrAction interact;
    protected ScrAction onpacket;
    protected boolean hasUpdate;
    protected boolean hasSave;
    protected boolean hasLoad;
    protected boolean hasInteract;
    protected boolean hasPacket;
    protected BlockScriptContext context;

    public FSBlockScript() {
    }

    public FSBlockScript(JsonObject obj) {
        this.resloc = new ResourceLocation(obj.get("script_location").getAsString());
        this.id = this.resloc.func_110624_b() + (this.resloc.func_110623_a().contains("/") ? this.resloc.func_110623_a().substring(this.resloc.func_110623_a().lastIndexOf("/")) : this.resloc.func_110623_a());
        if (this.id.endsWith(".script")) {
            this.id = this.id.substring(0, this.id.length() - 7);
        }
    }

    public BlockScript init(MultiBlockData data) {
        Object[] obj = EventHandler.getInputStream(this.resloc);
        this.script = new Script((InputStream)obj[0], this.id);
        if (obj.length > 1) {
            for (Closeable cl : (Closeable[])obj[1]) {
                try {
                    cl.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.hasUpdate = (this.update = (ScrAction)this.script.blocks.get("update")) != null;
        this.save = (ScrAction)this.script.blocks.get("save");
        this.hasSave = this.save != null;
        this.load = (ScrAction)this.script.blocks.get("load");
        this.hasLoad = this.load != null;
        this.interact = (ScrAction)this.script.blocks.get("interact");
        this.hasInteract = this.interact != null;
        this.onpacket = (ScrAction)this.script.blocks.get("data_packet");
        this.hasPacket = this.onpacket != null;
        this.context = new BlockScriptContext(data, this);
        Print.debug((Object)this.script);
        return this;
    }

    @Override
    public void read(MultiBlockData data, TagCW tag) {
    }

    @Override
    public TagCW write(MultiBlockData data, TagCW compound) {
        return compound;
    }

    @Override
    public void onUpdate(MultiblockTickableTE tile) {
        if (!this.hasUpdate) {
            return;
        }
        this.update.process(new ScrElm[]{this.context.update(tile)});
    }

    @Override
    public boolean onTrigger(MultiBlockData data, MB_Interact trigger, EntityPlayer player, EnumHand hand, BlockPos core, BlockPos pos, EnumFacing side, V3D hit) {
        return this.hasInteract;
    }

    @Override
    public void onUpdatePacket(TileEntity tile, NBTTagCompound compound) {
    }

    public Script script() {
        return this.script;
    }

    public BlockScriptContext context() {
        return this.context;
    }
}

