/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util.script;

import java.util.ArrayList;
import net.fexcraft.lib.script.ScrBlock;
import net.fexcraft.lib.script.ScrElm;
import net.fexcraft.lib.script.elm.ListElm;
import net.fexcraft.lib.script.elm.NullElm;
import net.fexcraft.lib.script.elm.RefElm;
import net.fexcraft.mod.fvtm.data.Seat;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.sys.uni.RootVehicle;
import net.fexcraft.mod.fvtm.util.script.FSVehicleScript;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;

public class VehicleScriptContext
implements ScrElm {
    private FSVehicleScript wrapper;
    private RootVehicle entity;
    private EntityPlayer player;
    protected VehicleData data;
    private Seat seat;
    private Attribute toggl;
    private Object oldattrval;
    private NBTTagCompound packet;
    private Side side;
    private AttrList attrslist = new AttrList(this);

    public VehicleScriptContext(VehicleData data, FSVehicleScript fscript) {
        this.data = data;
        this.wrapper = fscript;
    }

    public VehicleScriptContext update(Entity entity) {
        this.entity = (RootVehicle)entity;
        this.seat = null;
        this.player = null;
        this.toggl = null;
        this.oldattrval = null;
        this.packet = null;
        return this;
    }

    public VehicleScriptContext update(Seat seat, EntityPlayer player) {
        this.seat = seat;
        this.player = player;
        this.toggl = null;
        this.oldattrval = null;
        this.packet = null;
        return this;
    }

    public VehicleScriptContext update(Entity entity, Attribute<?> attr, Object oldvalue, EntityPlayer player) {
        this.entity = (RootVehicle)entity;
        this.player = player;
        this.toggl = attr;
        this.oldattrval = oldvalue;
        this.seat = null;
        this.packet = null;
        return this;
    }

    public VehicleScriptContext update(NBTTagCompound compound, Side side) {
        this.packet = compound;
        this.side = side;
        return this;
    }

    public String scr_str() {
        return "{vehicle-context}";
    }

    public ScrElm scr_get(ScrBlock block, String target) {
        if (target.equals("attributes")) {
            return this.attrslist;
        }
        if (target.equals("client")) {
            return this.entity.field_70170_p.field_72995_K ? TRUE : FALSE;
        }
        return NULL;
    }

    public ScrElm scr_exec(ScrBlock block, String act, ArrayList<ScrElm> args) {
        NullElm val = NULL;
        switch (act) {
            case "sync": {
                for (ScrElm elm : args) {
                    if (!(elm instanceof RefElm)) continue;
                    this.sendScriptValueUpdatePacket(block, elm);
                }
                return TRUE;
            }
        }
        return val;
    }

    private void sendScriptValueUpdatePacket(ScrBlock block, ScrElm elm) {
        if (elm == null) {
            return;
        }
        RefElm ref = (RefElm)elm;
        if ((elm = ref.getElm((ScrBlock)block.getScript())) == NULL) {
            return;
        }
        if (elm instanceof Attribute) {
            return;
        }
        NBTTagCompound packet = new NBTTagCompound();
        packet.func_74778_a("ScriptElm", ref.scr_str());
        if (elm.scr_type().bool()) {
            packet.func_74757_a("value", elm.scr_bln());
        } else if (elm.scr_type().decimal()) {
            packet.func_74776_a("value", elm.scr_flt());
        } else if (elm.scr_type().integer()) {
            packet.func_74768_a("value", elm.scr_int());
        } else if (elm.scr_type().string()) {
            packet.func_74778_a("value", elm.scr_str());
        } else {
            packet.func_74778_a("value", elm.scr_str());
        }
        this.wrapper.sendPacket(this.entity, packet, Side.CLIENT);
    }

    public void onElmUpdate(NBTTagCompound compound) {
        ScrElm elm = this.wrapper.script().getElm(compound.func_74779_i("ScriptElm"), null);
        if (elm == null || elm == NULL) {
            return;
        }
        if (elm.scr_type().bool()) {
            elm.scr_set(compound.func_74767_n("value"));
        } else if (elm.scr_type().decimal()) {
            elm.scr_set(compound.func_74760_g("value"));
        } else if (elm.scr_type().integer()) {
            elm.scr_set(compound.func_74762_e("value"));
        } else if (elm.scr_type().string()) {
            elm.scr_set(compound.func_74779_i("value"));
        }
    }

    public boolean overrides() {
        return true;
    }

    public RootVehicle vehicle() {
        return this.entity;
    }

    public static class AttrList
    extends ListElm {
        private VehicleScriptContext context;

        public AttrList(VehicleScriptContext context) {
            this.context = context;
        }

        public ScrElm exec(ScrBlock block, String act, ArrayList<ScrElm> args) {
            NullElm val = NULL;
            switch (act) {
                case "sync": {
                    for (ScrElm elm : this.value()) {
                        if (elm instanceof Attribute) continue;
                    }
                    return TRUE;
                }
            }
            return val;
        }
    }
}

