/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data;

import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.Fuel;
import net.fexcraft.mod.fvtm.data.Material;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniFluidTank;
import net.fexcraft.mod.uni.inv.UniInventory;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import org.apache.commons.lang3.tuple.Pair;

public class FuelFiller {
    public static int tanksize = 16000;
    public static int fullenough = 15000;
    public UniInventory items;
    public UniFluidTank tank;
    public float converted;
    public Fuel selected = (Fuel)FvtmRegistry.FUELS.get(0);
    private int ticks;

    public FuelFiller() {
        this.items = UniInventory.create((int)2);
        this.items.addValidator(1, (idx, stack) -> {
            Material mat = (Material)stack.getContent(ContentType.MATERIAL.item_type);
            return mat != null && mat.isFuelContainer();
        });
        this.tank = UniFluidTank.create((int)tanksize);
    }

    public TagCW save() {
        TagCW com = TagCW.create();
        com.set("fuel", this.selected.getIDS());
        com.set("converted", this.converted);
        com.set("tank", this.tank.save());
        for (int i = 0; i < 2; ++i) {
            if (this.items.get(i).empty()) continue;
            TagCW tag = TagCW.create();
            this.items.get(i).save(tag);
            com.set("item" + i, tag);
        }
        return com;
    }

    public void load(TagCW com) {
        this.selected = FvtmRegistry.getFuel(com.getString("fuel"));
        if (this.selected == null) {
            this.selected = (Fuel)FvtmRegistry.FUELS.get(0);
        }
        this.converted = com.getFloat("converted");
        this.tank.load(com.getCompound("tank"));
        this.tank.addValidator(stack -> this.selected.isSourceFluid(this.tank.getFluidFromStack(stack)));
        for (int i = 0; i < 2; ++i) {
            if (!com.has("item" + i)) continue;
            this.items.set(i, UniStack.createStack((Object)com.getCompound("item" + i)));
        }
    }

    public void update() {
        if (this.ticks > 0) {
            --this.ticks;
            return;
        }
        this.extractFromItem();
        this.convert();
        this.insertToItem();
        this.ticks = 20;
    }

    private void extractFromItem() {
        if (this.tank.amount() > fullenough) {
            return;
        }
        StackWrapper stack = this.items.get(0);
        if (this.tank.isValid(stack)) {
            Pair res = this.tank.drainFrom(stack, 1000);
            if (((Boolean)res.getRight()).booleanValue()) {
                this.items.set(0, (StackWrapper)res.getLeft());
            }
        } else if (this.selected.isSourceFluid(stack.getID())) {
            if (this.converted == (float)tanksize) {
                return;
            }
            stack.count(stack.count() - 1);
            this.items.set(0, stack);
            this.converted += 1000.0f * this.selected.getConversionRate(stack.getID());
            if (this.converted > (float)tanksize) {
                this.converted = tanksize;
            }
        }
    }

    private void convert() {
        if (this.tank.amount() <= 0) {
            return;
        }
        float am = this.tank.amount() < 200 ? (float)this.tank.amount() : 200.0f;
        this.tank.drain((int)am, true);
        this.converted += am * this.selected.getConversionRate(this.tank.getFluid());
        if (this.converted > (float)tanksize) {
            this.converted = tanksize;
        }
    }

    private void insertToItem() {
        if (this.converted <= 0.0f) {
            return;
        }
        StackWrapper stack = this.items.get(1);
        Material mat = (Material)stack.getContent(ContentType.MATERIAL.item_type);
        if (mat == null || !mat.isFuelContainer()) {
            return;
        }
        Fuel fuel = Fuel.getStoredType(stack);
        if (fuel == null) {
            Fuel.setStoredType(stack, this.selected);
        } else if (!fuel.getIDS().equals(this.selected.getIDS())) {
            return;
        }
        int stored = Fuel.getStoredAmount(stack);
        if (stored >= mat.fuel_capacity) {
            return;
        }
        int cangiv = this.converted < 1000.0f ? (int)this.converted : 1000;
        int canfit = Math.min(mat.fuel_capacity - stored, cangiv);
        Fuel.insert(stack, canfit);
        this.converted -= (float)canfit;
    }

    public static interface FuelFillerContainer {
        public FuelFiller getFuelFiller();
    }
}

