/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.Content;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.SignData;
import net.fexcraft.mod.fvtm.data.root.Colorable;
import net.fexcraft.mod.fvtm.data.root.Textureable;
import net.fexcraft.mod.fvtm.data.root.WithItem;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.Model;
import net.fexcraft.mod.fvtm.model.ModelData;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.inv.ItemWrapper;

public class Sign
extends Content<Sign>
implements WithItem,
Textureable.TextureHolder,
Colorable.ColorHolder {
    protected ItemWrapper item;
    protected String ctab;
    protected String modelid;
    protected Model model;
    protected ModelData modeldata = new ModelData();
    protected List<IDL> textures;
    protected Map<String, RGB> channels = new LinkedHashMap<String, RGB>();
    protected String text;
    protected boolean base;

    @Override
    public Sign parse(JsonMap map) {
        JsonValue val;
        this.pack = ContentConfigUtil.getAddon(map);
        if (this.pack == null) {
            return null;
        }
        this.id = ContentConfigUtil.getID(this.pack, map);
        if (this.id == null) {
            return null;
        }
        this.name = map.getString("Name", "Unnamed Sign");
        this.description = ContentConfigUtil.getStringList(map, "Description");
        this.textures = ContentConfigUtil.getTextures(map);
        if (map.has("ColorChannels")) {
            for (Map.Entry entry : map.get("ColorChannels").asMap().entries()) {
                this.channels.put((String)entry.getKey(), new RGB(((JsonValue)entry.getValue()).string_value()));
            }
        }
        if ((val = map.get("Text")) != null) {
            this.text = val.isBoolean() && val.bool() ? "" : val.string_value();
        }
        if (this.isText() && !this.channels.containsKey("text")) {
            this.channels.put("text", RGB.WHITE.copy());
        }
        this.base = map.getBoolean("Base", false);
        this.ctab = map.getString("CreativeTab", "default");
        if (EnvInfo.CLIENT || EnvInfo.is121()) {
            this.modelid = map.getString("Model", null);
            this.modeldata = new ModelData(map);
        }
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.SIGN;
    }

    @Override
    public Class<?> getDataClass() {
        return SignData.class;
    }

    @Override
    public String getItemContainer() {
        return null;
    }

    @Override
    public String getCreativeTab() {
        return this.ctab;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public void loadModel() {
        this.model = FvtmResources.getModel(this.modelid, this.modeldata, DefaultModel.class);
    }

    @Override
    public RGB getDefaultColorChannel(String channel) {
        return this.channels.get(channel);
    }

    @Override
    public Map<String, RGB> getDefaultColorChannels() {
        return this.channels;
    }

    @Override
    public List<IDL> getDefaultTextures() {
        return this.textures;
    }

    public boolean isText() {
        return this.text != null;
    }

    public boolean isBase() {
        return this.base;
    }
}

