/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.attribute;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.data.attribute.AttrValueType;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.uni.tag.TagCW;

public class AttrInteger
extends Attribute<Integer> {
    public AttrInteger(String id, JsonMap map) {
        this(id, map.getInteger("value", 0));
    }

    public AttrInteger(String aid, Integer val) {
        super(aid, AttrValueType.INTEGER, val);
    }

    @Override
    public Integer validate(Object val) {
        if (val == null) {
            return 0;
        }
        int va = 0;
        va = val instanceof Number ? ((Number)val).intValue() : this.parse(val.toString()).intValue();
        return (int)((float)va > this.max ? this.max : ((float)va < this.min ? this.min : (float)va));
    }

    @Override
    public Integer parse(String val) {
        try {
            return this.validate(Integer.parseInt(val, val.startsWith("#") || val.startsWith("0x") ? 16 : 10));
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public void increase(float by) {
        this.value = (Integer)this.value + (int)by;
    }

    @Override
    public void decrease(float by) {
        this.value = (Integer)this.value - (int)by;
    }

    @Override
    public String type() {
        return "integer";
    }

    @Override
    public void saveValue(TagCW com) {
        com.set(this.id, ((Integer)this.value).intValue());
    }

    @Override
    public void loadValue(TagCW com) {
        this.value = com.getInteger(this.id);
    }

    @Override
    public Attribute<Integer> newInstance() {
        return new AttrInteger(this.id, (Integer)this.initial);
    }

    @Override
    public int asInteger() {
        return (Integer)this.value;
    }

    @Override
    public long asLong() {
        return ((Integer)this.value).intValue();
    }

    @Override
    public float asFloat() {
        return ((Integer)this.value).intValue();
    }

    @Override
    public String asString() {
        return String.valueOf(this.value);
    }

    @Override
    public boolean asBoolean() {
        return (Integer)this.value > 0;
    }
}

