/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.block;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.Content;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.block.AABB;
import net.fexcraft.mod.fvtm.data.block.AABBs;
import net.fexcraft.mod.fvtm.data.block.BlockData;
import net.fexcraft.mod.fvtm.data.block.BlockFunction;
import net.fexcraft.mod.fvtm.data.block.BlockType;
import net.fexcraft.mod.fvtm.data.block.RelayData;
import net.fexcraft.mod.fvtm.data.root.Colorable;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.fvtm.data.root.Sound;
import net.fexcraft.mod.fvtm.data.root.Soundable;
import net.fexcraft.mod.fvtm.data.root.Textureable;
import net.fexcraft.mod.fvtm.data.root.WithItem;
import net.fexcraft.mod.fvtm.model.Model;
import net.fexcraft.mod.fvtm.model.ModelData;
import net.fexcraft.mod.fvtm.model.content.BlockModel;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;

public class Block
extends Content<Block>
implements Textureable.TextureHolder,
Colorable.ColorHolder,
Soundable.SoundHolder,
WithItem,
ItemTextureable {
    public static Block BLK_GETTER_CACHE;
    public static BiFunction<Block, Object, Object> BLK_GETTER;
    protected List<IDL> textures;
    protected ArrayList<BlockFunction> functions = new ArrayList();
    protected ArrayList<String> connectsto;
    protected Map<String, RGB> channels = new LinkedHashMap<String, RGB>();
    protected Map<String, Sound> sounds = new LinkedHashMap<String, Sound>();
    protected Map<String, AABBs> aabbs = new LinkedHashMap<String, AABBs>();
    protected Map<String, JsonValue> cstates;
    protected ModelData modeldata;
    protected BlockType blocktype;
    protected RelayData relaydata;
    protected Model model;
    protected Boolean passable;
    protected boolean plain_model;
    protected boolean no3ditem;
    protected boolean weblike;
    protected boolean fullblock;
    protected boolean fullcube;
    protected boolean opaque;
    protected boolean cutout;
    protected boolean translucent;
    protected boolean invisible;
    protected boolean hideitem;
    protected boolean randomrot;
    protected boolean ladder;
    protected boolean tickable;
    protected boolean hastile;
    protected boolean plantableon;
    protected String modelid;
    protected String ctab;
    protected String oredict;
    protected String material;
    protected String mapcolor;
    protected String harverest_class;
    protected String soundtype;
    protected String conngroup;
    protected float hardness;
    protected float lightlevel;
    protected float resistance;
    protected float damage;
    protected int lightopacity;
    protected int harverest_level;
    protected int maxstacksize;
    protected int burntime;
    protected IDL itemtexloc;
    protected Object block;
    private static AABBs RAABB;

    @Override
    public Block parse(JsonMap map) {
        this.pack = ContentConfigUtil.getAddon(map);
        if (this.pack == null) {
            return null;
        }
        this.id = ContentConfigUtil.getID(this.pack, map);
        if (this.id == null) {
            return null;
        }
        this.name = map.getString("Name", "Unnamed Block");
        this.description = ContentConfigUtil.getStringList(map, "Description");
        this.textures = ContentConfigUtil.getTextures(map);
        if (map.has("ColorChannels")) {
            for (Map.Entry entry2 : map.get("ColorChannels").asMap().entries()) {
                this.channels.put((String)entry2.getKey(), new RGB(((JsonValue)entry2.getValue()).string_value()));
            }
        }
        if (this.channels.isEmpty()) {
            this.channels.put("primary", RGB.WHITE.copy());
            this.channels.put("secondary", RGB.WHITE.copy());
        }
        this.maxstacksize = map.getInteger("MaxItemStackSize", 64);
        if (this.maxstacksize < 1) {
            this.maxstacksize = 1;
        }
        if (this.maxstacksize > 64) {
            this.maxstacksize = 64;
        }
        this.burntime = map.getInteger("ItemBurnTime", 0);
        this.oredict = map.getString("OreDictionary", null);
        this.modelid = map.getString("Model", null);
        if (this.modelid == null || this.modelid.equals("null") || this.modelid.startsWith("baked|")) {
            this.plain_model = true;
        }
        if (EnvInfo.CLIENT || EnvInfo.is121()) {
            this.modeldata = new ModelData(map);
            if (this.modeldata.getBoolean("Baked", false)) {
                this.plain_model = true;
            }
        }
        if (map.has("AABBs")) {
            map.getMap("AABBs").entries().forEach(entry -> {
                JsonArray value = ((JsonValue)entry.getValue()).asArray();
                if (value.get(0).isArray()) {
                    ArrayList<AABB> list = new ArrayList<AABB>();
                    for (JsonValue elm : (List)value.value) {
                        JsonArray arr = elm.asArray();
                        list.add(AABB.create(arr.get(0).float_value(), arr.get(1).float_value(), arr.get(2).float_value(), arr.get(3).float_value(), arr.get(4).float_value(), arr.get(5).float_value()));
                    }
                    this.aabbs.put((String)entry.getKey(), new AABBs(list));
                } else {
                    JsonArray array = ((JsonValue)entry.getValue()).asArray();
                    if (((String)entry.getKey()).startsWith("collision") && array.get(0).string_value().equals("null")) {
                        this.aabbs.put((String)entry.getKey(), AABBs.EMPTY);
                    } else {
                        this.aabbs.put((String)entry.getKey(), new AABBs(array.get(0).float_value(), array.get(1).float_value(), array.get(2).float_value(), array.get(3).float_value(), array.get(4).float_value(), array.get(5).float_value()));
                    }
                }
            });
        }
        if (map.has("Sounds")) {
            for (Map.Entry entry2 : map.getMap("Sounds").entries()) {
                if (((JsonValue)entry2.getValue()).isMap()) {
                    JsonMap val = ((JsonValue)entry2.getValue()).asMap();
                    this.sounds.put((String)entry2.getKey(), new Sound(IDLManager.getIDLCached((String)val.getString("sound", "minecraft:block.lever.click")), val.getFloat("volume", 1.0f), val.getFloat("pitch", 1.0f)));
                    continue;
                }
                this.sounds.put((String)entry2.getKey(), new Sound(IDLManager.getIDLCached((String)((JsonValue)entry2.getValue()).string_value()), 1.0f, 1.0f));
            }
        }
        this.blocktype = BlockType.valueOf(map.getString("BlockType", "GENERIC_SIMPLE"));
        this.material = map.getString("Material", "ROCK");
        this.mapcolor = map.getString("MapColor", "STONE");
        this.hardness = map.getFloat("Hardness", 1.0f);
        this.lightlevel = map.getFloat("LightLevel", 0.0f);
        this.resistance = map.getFloat("Resistance", 0.0f);
        this.lightopacity = map.getInteger("LightOpacity", 0);
        if (map.has("HarverestTool")) {
            JsonArray array = map.getArray("HarverestTool");
            this.harverest_class = array.get(0).string_value();
            this.harverest_level = array.get(1).integer_value();
        }
        this.damage = map.getFloat("CollisionDamage", 0.0f);
        this.weblike = map.getBoolean("WebLike", false);
        this.fullblock = map.getBoolean("FullBlock", true);
        this.fullcube = map.getBoolean("FullCube", true);
        this.opaque = map.getBoolean("Opaque", false);
        this.cutout = map.getBoolean("RenderCutout", false);
        this.translucent = map.getBoolean("RenderTranslucent", false);
        this.invisible = map.getBoolean("Invisible", false);
        this.hideitem = map.getBoolean("HideItem", false);
        this.randomrot = map.getBoolean("RandomRotation", false);
        this.ladder = map.getBoolean("Ladder", false);
        this.passable = map.has("Passable") ? Boolean.valueOf(map.getBoolean("Passable", false)) : null;
        this.plantableon = map.getBoolean("PlantableOn", false);
        this.tickable = map.getBoolean("Tickable", false);
        this.hastile = map.getBoolean("MultiSubBlock", false);
        this.hastile = map.getBoolean("HasBlockEntity", this.hastile);
        if (map.has("Functions") && map.get("Functions").isMap()) {
            map.getMap("Functions").entries().forEach(entry -> this.parseFunction((String)entry.getKey(), (JsonValue)entry.getValue()));
        }
        if (map.has("WireRelay")) {
            this.relaydata = new RelayData(map.getMap("WireRelay"));
        }
        this.soundtype = map.getString("SoundType", "stone");
        ArrayList arrayList = this.connectsto = map.has("ConnectsTo") ? map.getArray("ConnectsTo").toStringList() : new ArrayList();
        if (map.has("CustomStates")) {
            this.cstates = new LinkedHashMap<String, JsonValue>();
            for (Map.Entry entry2 : map.getMap("CustomStates").entries()) {
                this.cstates.put((String)entry2.getKey(), (JsonValue)entry2.getValue());
            }
        }
        switch (this.blocktype) {
            case GENERIC_8LAYER: 
            case GENERIC_2x8LAYER: {
                this.fullblock = false;
                this.fullcube = false;
                for (int i = 0; i < 8; ++i) {
                    if (this.aabbs.containsKey("layer=" + i)) continue;
                    this.aabbs.put("layer=" + i, new AABBs(AABBs.LAYERS8[i]));
                }
                break;
            }
        }
        this.ctab = map.getString("CreativeTab", "default");
        this.itemtexloc = ContentConfigUtil.getItemTexture(this.id, this.getContentType(), map);
        this.no3ditem = map.getBoolean("Disable3DItemModel", false);
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.BLOCK;
    }

    @Override
    public Class<?> getDataClass() {
        return BlockData.class;
    }

    @Override
    public List<IDL> getDefaultTextures() {
        return this.textures;
    }

    @Override
    public Map<String, Sound> getSounds() {
        return this.sounds;
    }

    @Override
    public String getItemContainer() {
        return null;
    }

    @Override
    public String getCreativeTab() {
        return this.ctab;
    }

    @Override
    public IDL getItemTexture() {
        return this.itemtexloc;
    }

    @Override
    public boolean noCustomItemModel() {
        return this.no3ditem;
    }

    @Override
    public RGB getDefaultColorChannel(String channel) {
        return this.channels.get(channel);
    }

    @Override
    public Map<String, RGB> getDefaultColorChannels() {
        return this.channels;
    }

    private void parseFunction(String key, JsonValue elm) {
        try {
            BlockFunction func = FvtmRegistry.BLOCK_FUNCTIONS.get(key).getConstructor(new Class[0]).newInstance(new Object[0]);
            this.functions.add(func.parse(elm));
        }
        catch (Exception e) {
            FvtmLogger.log((Object)("Failed to load BlockFunction for '" + this.id.colon() + "' with JSON: " + String.valueOf(elm)));
            e.printStackTrace();
        }
    }

    @Override
    public void loadModel() {
        this.model = FvtmResources.getModel(this.modelid, this.modeldata, BlockModel.class);
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    public AABBs getAABB(String type, String ... states) {
        if (type.equals("selection")) {
            for (String state : states) {
                if (!this.aabbs.containsKey("selection#" + state)) continue;
                return this.aabbs.get("selection#" + state);
            }
            if (this.aabbs.containsKey("selection#normal")) {
                return this.aabbs.get("selection#normal");
            }
        } else if (type.equals("collision")) {
            for (String state : states) {
                if (!this.aabbs.containsKey("collision#" + state)) continue;
                return this.aabbs.get("collision#" + state);
            }
            if (this.aabbs.containsKey("collision#normal")) {
                return this.aabbs.get("collision#normal");
            }
        }
        for (String state : states) {
            if (!this.aabbs.containsKey(state)) continue;
            return this.aabbs.get(state);
        }
        return this.aabbs.containsKey("normal") ? this.aabbs.get("normal") : AABBs.FULL;
    }

    public AABBs getAABB(String type, String state) {
        if (type.equals("selection")) {
            if (this.aabbs.containsKey("selection#" + state)) {
                return this.aabbs.get("selection#" + state);
            }
            if (this.aabbs.containsKey("selection#normal")) {
                return this.aabbs.get("selection#normal");
            }
        } else if (type.equals("collision")) {
            if (this.aabbs.containsKey("collision#" + state)) {
                return this.aabbs.get("collision#" + state);
            }
            if (this.aabbs.containsKey("collision#normal")) {
                return this.aabbs.get("collision#normal");
            }
        } else if (type.equals("render")) {
            return this.aabbs.containsKey("render") ? this.aabbs.get("render") : RAABB;
        }
        return this.aabbs.containsKey(state) ? this.aabbs.get(state) : (this.aabbs.containsKey("normal") ? this.aabbs.get("normal") : AABBs.FULL);
    }

    public Map<String, AABBs> getAABBs() {
        return this.aabbs;
    }

    public BlockType getBlockType() {
        return this.blocktype;
    }

    public RelayData getRelayData() {
        return this.relaydata;
    }

    public ArrayList<BlockFunction> getFunctions() {
        return this.functions;
    }

    public boolean hasRelay() {
        return this.relaydata != null;
    }

    public String getMaterial() {
        return this.material;
    }

    public String getMapColor() {
        return this.mapcolor;
    }

    public float getHardness() {
        return this.hardness;
    }

    public float getLightLevel() {
        return this.lightlevel;
    }

    public float getResistance() {
        return this.resistance;
    }

    public int getLightOpacity() {
        return this.lightopacity;
    }

    public String getHarverestToolClass() {
        return this.harverest_class;
    }

    public int getHarverestToolLevel() {
        return this.harverest_level;
    }

    public boolean isFullBlock() {
        return this.fullblock;
    }

    public boolean isFullCube() {
        return this.fullcube;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public float getCollisionDamage() {
        return this.damage;
    }

    public boolean isWebLike() {
        return this.weblike;
    }

    public boolean isCutout() {
        return this.cutout;
    }

    public boolean isTranslucent() {
        return this.translucent;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public boolean isLadder() {
        return this.ladder;
    }

    public boolean hasPlainModel() {
        return this.plain_model;
    }

    public boolean isTickable() {
        return this.tickable;
    }

    public int getMaxStackSize() {
        return this.maxstacksize;
    }

    public boolean shouldHideItem() {
        return this.hideitem;
    }

    public int getItemBurnTime() {
        return this.burntime;
    }

    public boolean hasFunction(String key) {
        for (BlockFunction func : this.functions) {
            if (!func.id().equals(key)) continue;
            return true;
        }
        return false;
    }

    public String getOreDictId() {
        return this.oredict;
    }

    public <BLK> BLK getBlock() {
        return (BLK)this.block;
    }

    public <BLK> BLK genBlock(Object prop) {
        this.block = BLK_GETTER.apply(this, prop);
        return (BLK)this.block;
    }

    public boolean hasEntity() {
        return this.hastile;
    }

    public boolean isRandomRot() {
        return this.randomrot;
    }

    public ModelData getModelData() {
        return this.modeldata;
    }

    public Boolean getPassable() {
        return this.passable;
    }

    public boolean isPlantableOn() {
        return this.plantableon;
    }

    public String getSoundTypeId() {
        return this.soundtype;
    }

    public ArrayList<String> getConnectsTo() {
        return this.connectsto;
    }

    public Map<String, JsonValue> getCustomStates() {
        return this.cstates;
    }

    static {
        BLK_GETTER = (blk, obj) -> {
            try {
                BLK_GETTER_CACHE = blk;
                return BlockType.BLOCK_IMPL.get(blk.getBlockType(), blk.hasEntity() || blk.hasRelay(), blk.hasPlainModel()).getConstructor(Block.class).newInstance(blk);
            }
            catch (Throwable e) {
                FvtmLogger.log(e, "block class creation / " + String.valueOf(blk.id));
                return null;
            }
        };
        RAABB = new AABBs(AABB.create(-3.0f, -3.0f, -3.0f, 3.0f, 3.0f, 3.0f));
    }
}

