/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.block;

public enum BlockType {
    GENERIC_4ROT(4),
    GENERIC_4X4ROT(44),
    GENERIC_8ROT(8),
    GENERIC_16ROT(16),
    GENERIC_SIMPLE(0),
    GENERIC_2VAR(0),
    GENERIC_3VAR(0),
    GENERIC_4VAR(0),
    GENERIC_5VAR(0),
    GENERIC_6VAR(0),
    GENERIC_7VAR(0),
    GENERIC_8VAR(0),
    GENERIC_9VAR(0),
    GENERIC_10VAR(0),
    GENERIC_11VAR(0),
    GENERIC_12VAR(0),
    GENERIC_13VAR(0),
    GENERIC_14VAR(0),
    GENERIC_15VAR(0),
    GENERIC_16VAR(0),
    GENERIC_8LAYER(0),
    GENERIC_2x8LAYER(0),
    GENERIC_ROAD(0),
    GENERIC_ROAD_MARKER(0),
    GENERIC_ROAD_MARKER_4ROT(4),
    GENERIC_ROAD_PATTERN(4),
    GENERIC_ROAD_LINES(0),
    MULTIBLOCK_4ROT(4),
    SIGNAL_4ROT(4),
    SIGNAL_16ROT(16),
    FORK2_SWITCH_4ROT(4),
    FORK3_SWITCH_4ROT(4),
    DOUBLE_SWITCH_4ROT(4),
    GENERIC_POST_LIKE(4),
    JACK_STAND(4);

    public static GetBlockTypeImpl BLOCK_IMPL;
    public int rotations;

    private BlockType(int rots) {
        this.rotations = rots;
    }

    public double getRotationFor(int state) {
        if (this.rotations == 4) {
            switch (state) {
                case 2: {
                    return 90.0;
                }
                case 3: {
                    return -90.0;
                }
                case 4: {
                    return 180.0;
                }
                case 5: {
                    return 0.0;
                }
            }
        } else {
            if (this.rotations == 8) {
                return state * -45 + 90;
            }
            if (this.rotations == 16) {
                return (double)state * -22.5 + 90.0;
            }
            if (this.rotations == 44) {
                switch (state %= 4) {
                    case 0: {
                        return 90.0;
                    }
                    case 1: {
                        return -90.0;
                    }
                    case 2: {
                        return 180.0;
                    }
                    case 3: {
                        return 0.0;
                    }
                }
            }
        }
        return 0.0;
    }

    public double getRelayRotFor(int state) {
        if (this.rotations == 4) {
            switch (state) {
                case 2: {
                    return 90.0;
                }
                case 3: {
                    return -90.0;
                }
                case 4: {
                    return 0.0;
                }
                case 5: {
                    return 180.0;
                }
            }
        } else {
            if (this.rotations == 8) {
                return state * 45 + 90;
            }
            if (this.rotations == 16) {
                return (double)state * 22.5 + 90.0;
            }
            if (this.rotations == 44) {
                switch (state %= 4) {
                    case 0: {
                        return 90.0;
                    }
                    case 1: {
                        return -90.0;
                    }
                    case 2: {
                        return 0.0;
                    }
                    case 3: {
                        return 180.0;
                    }
                }
            }
        }
        return 0.0;
    }

    public boolean isGenericRoad() {
        return this == GENERIC_ROAD;
    }

    public boolean isRoadLayer() {
        return this.ordinal() >= GENERIC_ROAD_MARKER.ordinal() && this.ordinal() <= GENERIC_ROAD_LINES.ordinal();
    }

    public boolean isMultiBlock() {
        return this == MULTIBLOCK_4ROT;
    }

    public boolean isRailBlock() {
        return this == SIGNAL_16ROT || this == SIGNAL_4ROT || this == FORK2_SWITCH_4ROT || this == FORK3_SWITCH_4ROT || this == DOUBLE_SWITCH_4ROT;
    }

    public boolean is4Rot() {
        return this.rotations == 4;
    }

    public boolean is8Rot() {
        return this.rotations == 8;
    }

    public boolean is16Rot() {
        return this.rotations == 16;
    }

    public int getMetaVariants() {
        switch (this.ordinal()) {
            case 5: {
                return 2;
            }
            case 6: {
                return 3;
            }
            case 7: {
                return 4;
            }
            case 8: {
                return 5;
            }
            case 9: {
                return 6;
            }
            case 10: {
                return 7;
            }
            case 11: {
                return 8;
            }
            case 12: {
                return 9;
            }
            case 13: {
                return 10;
            }
            case 14: {
                return 11;
            }
            case 15: {
                return 12;
            }
            case 16: {
                return 13;
            }
            case 17: {
                return 14;
            }
            case 18: {
                return 15;
            }
            case 19: {
                return 16;
            }
            case 1: {
                return 4;
            }
            case 20: {
                return 8;
            }
            case 21: {
                return 16;
            }
            case 22: {
                return 16;
            }
        }
        return 0;
    }

    public boolean isVariant() {
        return this == GENERIC_4X4ROT || this.ordinal() >= GENERIC_2VAR.ordinal() && this.ordinal() <= GENERIC_ROAD.ordinal();
    }

    public boolean isJackStand() {
        return this == JACK_STAND;
    }

    static {
        BLOCK_IMPL = null;
    }

    @FunctionalInterface
    public static interface GetBlockTypeImpl {
        public Class get(BlockType var1, boolean var2, boolean var3);
    }
}

