/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.entity;

import java.util.ArrayList;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fcl.util.EntityWI;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.data.InteractZone;
import net.fexcraft.mod.fvtm.data.block.AABB;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.entity.WheelEntity;
import net.fexcraft.mod.fvtm.function.part.EngineFunction;
import net.fexcraft.mod.fvtm.item.MaterialItem;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.sys.uni.SeatInstance;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.fvtm.util.ClientAddEntity;
import net.fexcraft.mod.fvtm.util.CollisionUtil;
import net.fexcraft.mod.fvtm.util.OBB;
import net.fexcraft.mod.fvtm.util.SpawnPacketEntity;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2604;
import net.minecraft.class_2945;
import net.minecraft.class_3218;

public class RootVehicle
extends class_1297
implements SpawnPacketEntity,
VehicleInstance.Holder {
    public VehicleInstance vehicle = new VehicleInstance((EntityW)new EntityWI((class_1297)this), null);
    public float rotZ = 0.0f;
    public float protZ = 0.0f;
    public boolean should_sit = true;

    public RootVehicle(class_1299<?> type, class_1937 level) {
        super(type, level);
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        this.readSpawnData(((ClientAddEntity)packet).getFvtmData());
    }

    protected void method_5693(class_2945.class_9222 builder) {
    }

    public void initVD(VehicleData data) {
        this.vehicle.init(data, null);
        this.init(null);
    }

    protected void init(TagCW com) {
    }

    protected void method_5749(class_11368 in) {
        this.method_36457(in.method_71423("RotationPitch", 0.0f));
        this.method_36456(in.method_71423("RotationYaw", 0.0f));
        this.protZ = this.rotZ = in.method_71423("RotationRoll", 0.0f);
        this.method_22862();
        TagCW com = TagCW.wrap((Object)in);
        this.vehicle.init(null, com);
        this.init(com);
    }

    protected void method_5652(class_11372 out) {
        if (this.vehicle.data == null) {
            FvtmLogger.log((Object)("Entity with ID '" + this.method_5628() + "' has no vehicle data, not saving."));
            this.method_5650(class_1297.class_5529.field_26999);
            return;
        }
        this.vehicle.save(TagCW.wrap((Object)out));
    }

    @Override
    public void writeSpawnData(TagCW com) {
        if (this.vehicle.data == null) {
            FvtmLogger.log((Object)("Entity with ID '" + this.method_5628() + "' has no vehicle data, removing."));
            this.method_5650(class_1297.class_5529.field_26999);
            return;
        }
        this.vehicle.save(com);
        if (this.vehicle.front != null) {
            com.set("TruckId", this.vehicle.front.entity.getId());
        }
    }

    @Override
    public void readSpawnData(TagCW com) {
        try {
            this.vehicle.init(null, com);
            this.init(com);
            this.method_36456(this.vehicle.point.getPivot().deg_yaw());
            this.method_36457(this.vehicle.point.getPivot().deg_pitch());
            this.protZ = this.rotZ = this.vehicle.point.getPivot().deg_roll();
            this.method_22862();
        }
        catch (Exception e) {
            e.printStackTrace();
            FvtmLogger.log((Object)("Failed to read additional spawn data for vehicle entity with ID " + this.method_5628() + "!"));
        }
        FvtmLogger.debug((Object)("Received sync for " + this.method_5628()));
    }

    public void method_5768(class_3218 level) {
        if (this.vehicle != null && this.vehicle.data != null) {
            this.vehicle.onRemove();
        }
        super.method_5768(level);
    }

    public boolean method_5863() {
        return true;
    }

    public boolean method_30948(class_1297 entity) {
        return true;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (this.method_31481() || hand == class_1268.field_5810) {
            return class_1269.field_5811;
        }
        int res = this.vehicle.onInteract(UniEntity.getEntity((Object)player), UniStack.getStack((Object)player.method_5998(hand)));
        return res == 1 ? class_1269.field_5812 : (res == 0 ? class_1269.field_5811 : class_1269.field_5814);
    }

    private boolean isFuelContainer(class_1792 item) {
        if (!(item instanceof MaterialItem)) {
            return false;
        }
        return ((MaterialItem)item).getContent().isFuelContainer();
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_31481()) {
            return;
        }
        if (this.vehicle.data == null) {
            if (!this.method_37908().field_9236) {
                FvtmLogger.log((Object)("Vehicle '" + this.method_5628() + "' has no data, removing!"));
                this.method_5768((class_3218)this.method_37908());
            }
            return;
        }
        if (this.field_6012 >= Integer.MAX_VALUE) {
            this.field_6012 = 0;
        }
        this.field_5982 = this.vehicle.point.getPivot().deg_yaw();
        this.field_6004 = this.vehicle.point.getPivot().deg_pitch();
        this.protZ = this.vehicle.point.getPivot().deg_roll();
        this.vehicle.onUpdate();
        this.checkCollision();
        if (!this.method_37908().field_9236 && this.field_6012 % Config.VEHICLE_SYNC_RATE == 0) {
            this.vehicle.sendUpdatePacket();
        }
    }

    private void checkCollision() {
        if (Config.DISABLE_OBB || this.vehicle.obb.isEmpty()) {
            return;
        }
        ArrayList checked = new ArrayList();
        for (InteractZone zone : this.vehicle.data.getInteractZones().values()) {
            this.method_37908().method_8333((class_1297)this, class_238.method_30048((class_243)this.method_19538().method_1031(zone.pos.x, zone.pos.y, zone.pos.z), (double)zone.range, (double)zone.range, (double)zone.range), ent -> ent instanceof class_1309 && !(ent instanceof WheelEntity)).forEach(entity -> {
                if (entity.method_5854() != null || checked.contains(entity)) {
                    return;
                }
                OBB bb = new OBB().set(AABB.wrap(entity.method_5829()));
                for (OBB obb : this.vehicle.obb.values()) {
                    V3D res = CollisionUtil.check(bb, obb);
                    if (res == null) continue;
                    class_243 vec = new class_243(-res.x, res.y, -res.z);
                    entity.method_18799(entity.method_18798().method_1021(0.9).method_1019(vec));
                    checked.add(entity);
                }
            });
        }
    }

    public class_1657 getDriver() {
        for (SeatInstance seat : this.vehicle.seats) {
            if (!seat.seat.driver || !seat.passengerIsPlayer()) continue;
            return (class_1657)seat.passenger().local();
        }
        return null;
    }

    public class_1309 method_5642() {
        return null;
    }

    public void method_5865(class_1297 pass, class_1297.class_4738 movefunc) {
        SeatInstance seat = this.vehicle.getSeatOf(pass);
        if (seat != null) {
            this.updatePassenger(pass, seat);
        } else {
            if (this.method_37908().field_9236) {
                ((Passenger)UniEntity.getApp((Object)pass, Passenger.class)).reqPassUpdate();
            }
            pass.method_33574(this.method_19538());
        }
    }

    public void updatePassenger(class_1297 pass, SeatInstance seat) {
        if (seat.passenger_direct() != pass) {
            seat.passenger(UniEntity.getEntity((Object)pass));
        }
        V3D pos = seat.getCurrentGlobalPosition();
        pass.method_5814(pos.x, pos.y - (pass instanceof class_1657 ? 0.7 : 0.0), pos.z);
    }

    public void method_5627(class_1297 pass) {
        super.method_5627(pass);
        SeatInstance seat = this.vehicle.getSeatOf(pass);
        if (seat != null) {
            seat.passenger(UniEntity.getEntity((Object)pass));
        }
    }

    public void method_5793(class_1297 pass) {
        for (SeatInstance seat : this.vehicle.seats) {
            if (!pass.equals(seat.passenger_direct())) continue;
            seat.passenger(null);
        }
        if (!this.method_37908().field_9236) {
            ((Passenger)UniEntity.getApp((Object)pass, Passenger.class)).set(-1, -1);
        }
        super.method_5793(pass);
    }

    public void method_5772() {
        super.method_5772();
    }

    protected boolean method_5818(class_1297 passenger) {
        return true;
    }

    public boolean method_64397(class_3218 level, class_1282 source, float f) {
        if (source.method_5526() instanceof class_1657 && this.getDriver() == null) {
            EngineFunction engine;
            EntityW pass = UniEntity.getEntity((Object)source.method_5526());
            class_1657 player = (class_1657)source.method_5526();
            if (this.vehicle.data.getLock().isLocked()) {
                pass.send("interact.fvtm.vehicle.remove_locked");
                return false;
            }
            EngineFunction engineFunction = engine = this.vehicle.data.hasPart("engine") ? (EngineFunction)this.vehicle.data.getFunctionInPart("engine", "fvtm:engine") : null;
            if (engine != null) {
                engine.setState(false);
            }
            if (this.vehicle.type.isRailVehicle()) {
                this.vehicle.railent.remove();
            } else {
                VehicleInstance trailer = this.vehicle;
                while ((trailer = trailer.rear) != null) {
                    class_1297 rear = (class_1297)trailer.entity.local();
                    rear.method_5699(level, (class_1799)trailer.data.newItemStack().local(), 0.5f);
                    rear.method_5768(level);
                }
            }
            this.method_5699(level, (class_1799)this.vehicle.data.newItemStack().local(), 0.5f);
            this.method_5768(level);
            return true;
        }
        return true;
    }

    public class_1799 method_31480() {
        return (class_1799)this.vehicle.data.newItemStack().local();
    }

    public void method_5750(double x, double y, double z) {
    }

    public void method_5683(float y, int x) {
    }

    public void method_52532(int sm, double x, double y, double z, double yr, double xr) {
    }

    public void method_66246(class_243 vec3, float f, float g) {
    }

    @Override
    public VehicleInstance getVehicleInstance() {
        return this.vehicle;
    }

    @Override
    public void onPacket(EntityW player, TagCW packet) {
    }
}

