/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.handler;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.Material;
import net.fexcraft.mod.fvtm.data.ToolboxType;
import net.fexcraft.mod.fvtm.data.WireDeco;
import net.fexcraft.mod.fvtm.data.attribute.AttrBox;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.fvtm.data.block.AABB;
import net.fexcraft.mod.fvtm.data.inv.FvtmInv;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.part.PartSlot;
import net.fexcraft.mod.fvtm.data.part.PartSlots;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPoint;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.data.vehicle.WheelSlot;
import net.fexcraft.mod.fvtm.function.part.InventoryFunction;
import net.fexcraft.mod.fvtm.handler.BogieInstallationHandler;
import net.fexcraft.mod.fvtm.handler.DefaultPartInstallHandler;
import net.fexcraft.mod.fvtm.handler.TireInstallationHandler;
import net.fexcraft.mod.fvtm.handler.WheelInstallationHandler;
import net.fexcraft.mod.fvtm.item.ToolboxItem;
import net.fexcraft.mod.fvtm.packet.Packet_TagListener;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.fvtm.sys.sign.SignInstance;
import net.fexcraft.mod.fvtm.sys.sign.SignSystem;
import net.fexcraft.mod.fvtm.sys.uni.FvtmWorld;
import net.fexcraft.mod.fvtm.sys.uni.KeyPress;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.sys.uni.SeatInstance;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.fvtm.sys.wire.RelayHolder;
import net.fexcraft.mod.fvtm.sys.wire.Wire;
import net.fexcraft.mod.fvtm.sys.wire.WireRelay;
import net.fexcraft.mod.fvtm.sys.wire.WireSystem;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.WorldW;
import net.fexcraft.mod.uni.world.WrapperHolder;

public class InteractionHandler {
    private static FvtmWorld world;
    private static String last;
    private static long cooldown;
    private static float seatbbs;
    private static float seatbbsh;
    private static float th32;
    private static AABB aabb;
    private static boolean is_toolbox;
    private static String[] NON_EMPTY_VALID;

    public static boolean handle(KeyPress key, VehicleData vehdata, InteractRef ref, SeatInstance seat, EntityW pass, StackWrapper stack) {
        FvtmInv inv;
        int i;
        if (key.mouse_right() && ref.isVehicle() && InteractionHandler.mountSeat(ref.vehicle(), seat, pass, stack)) {
            return true;
        }
        if (Time.getDate() < cooldown) {
            return false;
        }
        if (!stack.empty()) {
            Material mat;
            if (stack.isItemOf(ContentType.VEHICLE.item_type)) {
                VehicleData data = (VehicleData)stack.getContent(ContentType.VEHICLE.item_type);
                if (seat != null) {
                    return false;
                }
                if (pass.isShiftDown() || !((Vehicle)data.getType()).isTrailer()) {
                    return false;
                }
                if (((Vehicle)data.getType()).getVehicleType().isRailVehicle()) {
                    return true;
                }
                return InteractionHandler.tryAttachingATrailer(vehdata, ref, data, pass);
            }
            if (stack.isItemOf(ContentType.PART.item_type)) {
                PartData data = (PartData)stack.getContent(ContentType.PART.item_type);
                if (((Part)data.getType()).getInstallHandlerData() instanceof DefaultPartInstallHandler.DPIHData && InteractionHandler.tryInstall(vehdata, ref, data, seat, pass)) {
                    return true;
                }
                if (((Part)data.getType()).getInstallHandlerData() instanceof TireInstallationHandler.TireData && InteractionHandler.tryWTInstall(vehdata, ref, data, seat, pass)) {
                    return true;
                }
                if (((Part)data.getType()).getInstallHandlerData() instanceof WheelInstallationHandler.WheelData && InteractionHandler.tryWTInstall(vehdata, ref, data, seat, pass)) {
                    return true;
                }
                return ((Part)data.getType()).getInstallHandlerData() instanceof BogieInstallationHandler.BogieData && InteractionHandler.tryWTInstall(vehdata, ref, data, seat, pass);
            }
            if (stack.isItemOf(ContentType.MATERIAL.item_type) && (mat = (Material)stack.getContent(ContentType.MATERIAL.item_type)).getImpactLevel() > -1 && InteractionHandler.tryWheelRemoval(vehdata, ref, stack, mat, pass)) {
                return true;
            }
            if (stack.isItemOf(ContentType.TOOLBOX.item_type)) {
                boolean tex;
                boolean prt = ToolboxItem.getToolboxType(stack) == 0;
                boolean bl = tex = ToolboxItem.getToolboxType(stack) == 1;
                if (prt && InteractionHandler.tryRemTex(vehdata, ref, seat, pass, false)) {
                    return true;
                }
                if (tex && InteractionHandler.tryRemTex(vehdata, ref, seat, pass, true)) {
                    return true;
                }
            }
            return false;
        }
        List<Attribute> attributes = vehdata.getAttributes().values().stream().filter(attr -> attr.hasBoxes() && (attr.valuetype.isTristate() || attr.valuetype.isNumber()) && (seat == null ? attr.external : seat.seat.driver || attr.access.contains(seat.seat.name))).collect(Collectors.toList());
        if (attributes.size() > 0) {
            ArrayList list = new ArrayList();
            attributes.forEach(attr -> list.add(new AttrInteractive((Attribute)attr)));
            AttrInteractive inter = (AttrInteractive)InteractionHandler.getInteracted(seat == null, vehdata, ref, pass, list);
            if (inter != null) {
                Attribute<?> attr2 = inter.attribute;
                if (attr2.id.equals(last) && Time.getDate() < cooldown) {
                    return true;
                }
                return InteractionHandler.toggle(attr2, vehdata, ref, key, null, pass);
            }
        }
        if (!ref.isVehicle()) {
            return false;
        }
        if (vehdata.getVehInventories().size() == 0 && vehdata.getInventories().size() == 0) {
            return false;
        }
        ArrayList<InvInteractive> invs = new ArrayList<InvInteractive>();
        for (i = 0; i < vehdata.getVehInvKeys().size(); ++i) {
            inv = vehdata.getVehInventories().get(i);
            if (!(!inv.pos.isNull() && seat == null ? inv.external : seat.seat.driver || inv.access.contains(seat.seat.name))) continue;
            invs.add(new InvInteractive(vehdata.getVehInvKeys().get(i), inv, null, i));
        }
        for (i = 0; i < vehdata.getInventories().size(); ++i) {
            InventoryFunction func;
            PartData part = vehdata.getPart(vehdata.getInventories().get(i));
            if (part == null || (func = (InventoryFunction)part.getFunction("fvtm:inventory")) == null) continue;
            inv = func.inventory();
            if (!(seat == null ? inv.external : seat.seat.driver || inv.access.contains(seat.seat.name))) continue;
            invs.add(new InvInteractive(vehdata.getInventories().get(i), inv, part, vehdata.getVehInvKeys().size() + i));
        }
        InvInteractive inter = (InvInteractive)InteractionHandler.getInteracted(seat == null, vehdata, ref, pass, invs);
        if (inter != null) {
            if (inter.key.equals(last) && Time.getDate() < cooldown) {
                return true;
            }
            last = inter.key;
            cooldown = Time.getDate() + 20L;
            TagCW com = TagCW.create();
            com.set("inventory", inter.index);
            com.set("type", ContentType.VEHICLE.name());
            ref.setPacket(com);
            Packets.send(Packet_TagListener.class, "open_inv", com);
            return true;
        }
        return false;
    }

    private static boolean tryInstall(VehicleData vehdata, InteractRef ref, PartData data, SeatInstance seat, EntityW pass) {
        ArrayList<PartSlotInteractive> list = new ArrayList<PartSlotInteractive>();
        SwivelPoint point = null;
        for (Map.Entry<String, PartSlots> entry : vehdata.getPartSlotProviders().entrySet()) {
            point = vehdata.getRotationPointOfPart(entry.getKey());
            for (Map.Entry sentry : entry.getValue().entrySet()) {
                Part part;
                String type = ((PartSlot)sentry.getValue()).type;
                if (vehdata.hasPart(type) && (!((part = (Part)vehdata.getPart(type).getType()).getInstallHandlerData() instanceof DefaultPartInstallHandler.DPIHData) || !((DefaultPartInstallHandler.DPIHData)part.getInstallHandlerData()).swappable)) continue;
                for (String sub : ((Part)data.getType()).getCategories()) {
                    if (!sub.equals(type)) continue;
                    list.add(new PartSlotInteractive(point, entry.getKey(), entry.getValue(), (String)sentry.getKey()));
                }
            }
        }
        PartSlotInteractive res = (PartSlotInteractive)InteractionHandler.getInteracted(seat == null, vehdata, ref, pass, list);
        if (res == null) {
            return false;
        }
        if (res.id().equals(last) && Time.getDate() < cooldown) {
            return true;
        }
        TagCW com = TagCW.create();
        com.set("source", res.source);
        com.set("category", res.category);
        ref.setPacket(com);
        Packets.send(Packet_TagListener.class, "install_part", com);
        last = res.id();
        cooldown = Time.getDate() + 20L;
        return true;
    }

    private static boolean tryWTInstall(VehicleData vehdata, InteractRef ref, PartData data, SeatInstance seat, EntityW pass) {
        WheelInteractive res;
        ArrayList<WheelInteractive> list = new ArrayList<WheelInteractive>();
        boolean tire = ((Part)data.getType()).getInstallHandlerData() instanceof TireInstallationHandler.TireData;
        if (tire) {
            for (Map.Entry<String, WheelSlot> entry : vehdata.getWheelSlots().entrySet()) {
                PartData part;
                WheelInstallationHandler.WheelData wd;
                if (vehdata.hasPart(entry.getKey() + ":tire") || !vehdata.hasPart(entry.getKey()) || (wd = (WheelInstallationHandler.WheelData)((Part)(part = vehdata.getPart(entry.getKey())).getType()).getInstallHandlerData()).hasTire()) continue;
                list.add(new WheelInteractive(entry.getKey(), entry.getValue()));
            }
        } else {
            for (Map.Entry<String, WheelSlot> entry : vehdata.getWheelSlots().entrySet()) {
                if (vehdata.hasPart(entry.getKey())) continue;
                list.add(new WheelInteractive(entry.getKey(), entry.getValue()));
            }
        }
        if ((res = (WheelInteractive)InteractionHandler.getInteracted(seat == null, vehdata, ref, pass, list)) == null) {
            return false;
        }
        if (res.id().equals(last) && Time.getDate() < cooldown) {
            return true;
        }
        TagCW com = TagCW.create();
        com.set("category", res.category);
        ref.setPacket(com);
        Packets.send(Packet_TagListener.class, "install_wheel", com);
        last = res.id();
        cooldown = Time.getDate() + 20L;
        return true;
    }

    private static boolean tryWheelRemoval(VehicleData data, InteractRef ref, StackWrapper stack, Material mat, EntityW pass) {
        if (((Vehicle)data.getType()).getImpactWrenchLevel() > mat.getImpactLevel()) {
            return false;
        }
        ArrayList<WheelInteractive> list = new ArrayList<WheelInteractive>();
        for (Map.Entry<String, WheelSlot> entry : data.getWheelSlots().entrySet()) {
            if (!data.hasPart(entry.getKey())) continue;
            list.add(new WheelInteractive(entry.getKey(), entry.getValue()));
        }
        WheelInteractive res = (WheelInteractive)InteractionHandler.getInteracted(true, data, ref, pass, list);
        if (res == null) {
            return false;
        }
        if (res.id().equals(last) && Time.getDate() < cooldown) {
            return true;
        }
        TagCW com = TagCW.create();
        com.set("category", res.category);
        ref.setPacket(com);
        Packets.send(Packet_TagListener.class, "remove_wheel", com);
        last = res.id();
        cooldown = Time.getDate() + 20L;
        return true;
    }

    private static boolean tryRemTex(VehicleData vehdata, InteractRef ref, SeatInstance seat, EntityW pass, boolean tex) {
        ArrayList<InstPartInteractive> list = new ArrayList<InstPartInteractive>();
        for (Map.Entry<String, PartData> entry : vehdata.getParts().entrySet()) {
            SwivelPoint point = vehdata.getRotationPointOfPart(entry.getKey());
            if (!tex && (!(((Part)entry.getValue().getType()).getInstallHandlerData() instanceof DefaultPartInstallHandler.DPIHData) || !((DefaultPartInstallHandler.DPIHData)((Part)entry.getValue().getType()).getInstallHandlerData()).removable)) continue;
            list.add(new InstPartInteractive(point, entry));
        }
        InstPartInteractive res = (InstPartInteractive)InteractionHandler.getInteracted(seat == null, vehdata, ref, pass, list);
        if (res == null) {
            return false;
        }
        if (res.id().equals(last) && Time.getDate() < cooldown) {
            return true;
        }
        TagCW com = TagCW.create();
        com.set("category", res.category);
        ref.setPacket(com);
        Packets.send(Packet_TagListener.class, tex ? "texture_part" : "remove_part", com);
        last = res.id();
        cooldown = Time.getDate() + 20L;
        return true;
    }

    private static boolean tryAttachingATrailer(VehicleData vehdata, InteractRef ref, VehicleData trailer, EntityW pass) {
        ArrayList<TrailerInteractive> list = new ArrayList<TrailerInteractive>();
        for (String category : ((Vehicle)trailer.getType()).getCategories()) {
            V3D conn = vehdata.getConnectorFor(category);
            if (conn.isNull()) continue;
            list.add(new TrailerInteractive(category, conn));
        }
        TrailerInteractive res = (TrailerInteractive)InteractionHandler.getInteracted(true, vehdata, ref, pass, list);
        if (res == null) {
            return false;
        }
        if (res.id().equals(last) && Time.getDate() < cooldown) {
            return true;
        }
        TagCW com = TagCW.create();
        com.set("category", res.cat);
        ref.setPacket(com);
        Packets.send(Packet_TagListener.class, "attach_trailer", com);
        last = res.id();
        cooldown = Time.getDate() + 20L;
        return true;
    }

    public static boolean toggle(Attribute<?> attr, VehicleData data, InteractRef ref, KeyPress press, Float val, EntityW pass) {
        TagCW packet = TagCW.create();
        packet.set("attr", attr.id);
        ref.setPacket(packet);
        switch (press) {
            case MOUSE_MAIN: {
                if (attr.valuetype.isTristate()) {
                    packet.set("bool", !attr.valuetype.isBoolean() ? false : !attr.asBoolean());
                    pass.bar("interact.fvtm.attribute.toggle_bool", new Object[]{attr.id, packet.getBoolean("bool")});
                    break;
                }
                if (attr.valuetype.isFloat()) {
                    float flaot = attr.asFloat() + (val != null ? val.floatValue() : attr.getBox((String)attr.asString()).increase);
                    packet.set("value", flaot);
                    attr.set(Float.valueOf(flaot));
                    pass.bar("interact.fvtm.attribute.increase_number", new Object[]{attr.id, Float.valueOf(packet.getFloat("value"))});
                    break;
                }
                if (!attr.valuetype.isInteger()) break;
                int ent = attr.asInteger() + (int)(val != null ? val.floatValue() : attr.getBox((String)attr.asString()).increase);
                packet.set("value", ent);
                attr.set(ent);
                pass.bar("interact.fvtm.attribute.increase_number", new Object[]{attr.id, packet.getInteger("value")});
                break;
            }
            case MOUSE_RIGHT: {
                if (attr.valuetype.isTristate()) {
                    packet.set("bool", !attr.valuetype.isBoolean() ? true : !attr.asBoolean());
                    pass.bar("interact.fvtm.attribute.toggle_bool", new Object[]{attr.id, packet.getBoolean("bool")});
                    break;
                }
                if (attr.valuetype.isFloat()) {
                    float flaot = attr.asFloat() - (val != null ? -val.floatValue() : attr.getBox((String)attr.asString()).decrease);
                    packet.set("value", flaot);
                    attr.set(Float.valueOf(flaot));
                    pass.bar("interact.fvtm.attribute.decrease_number", new Object[]{attr.id, Float.valueOf(packet.getFloat("value"))});
                    break;
                }
                if (!attr.valuetype.isInteger()) break;
                int ent = attr.asInteger() - (int)(val != null ? -val.floatValue() : attr.getBox((String)attr.asString()).decrease);
                packet.set("value", ent);
                attr.set(ent);
                pass.bar("interact.fvtm.attribute.decrease_number", new Object[]{attr.id, packet.getInteger("value")});
                break;
            }
            case RESET: {
                if (attr.valuetype.isTristate()) {
                    packet.set("bool", false);
                    packet.set("reset", true);
                    pass.bar("interact.fvtm.attribute.reset_bool", new Object[]{attr.id});
                    break;
                }
                if (attr.valuetype.isFloat()) {
                    float flaot = val != null ? val.floatValue() : attr.getBox((String)attr.asString()).reset;
                    packet.set("value", flaot);
                    attr.set(Float.valueOf(flaot));
                    pass.bar("interact.fvtm.attribute.reset_number", new Object[]{attr.id, Float.valueOf(packet.getFloat("value"))});
                    break;
                }
                if (!attr.valuetype.isInteger()) break;
                int ent = (int)(val != null ? val.floatValue() : attr.getBox((String)attr.asString()).reset);
                packet.set("value", ent);
                attr.set(ent);
                pass.bar("interact.fvtm.attribute.reset_number", new Object[]{attr.id, packet.getInteger("value")});
                break;
            }
            default: {
                return false;
            }
        }
        if (pass.isOnClient()) {
            Packets.send(Packet_TagListener.class, "attr_toggle", packet);
            last = attr.id;
            cooldown = Time.getDate() + 20L;
        } else {
            FvtmLogger.marker((Object)("ERROR:INTERACT-ON-SERVER " + packet.toString()));
        }
        return true;
    }

    public static boolean handle(KeyPress key, StackWrapper stack) {
        if (!stack.empty() && !stack.isItemOfAny(NON_EMPTY_VALID)) {
            return false;
        }
        world = (FvtmWorld)WrapperHolder.getClientWorld();
        Passenger pass = world.getClientPassenger();
        is_toolbox = stack.isItemOf(ContentType.TOOLBOX.item_type);
        if (stack.isItemOfAny(new String[]{ContentType.WIRE.item_type, ContentType.WIREDECO.item_type}) || is_toolbox && ToolboxType.eq(ToolboxItem.getToolboxType(stack), ToolboxType.WIRE_REMOVAL, ToolboxType.WIRE_SLACK)) {
            return InteractionHandler.handleWire(world, pass.entity, key, stack);
        }
        if (stack.isItemOf(ContentType.SIGN.item_type) || is_toolbox && ToolboxType.eq(ToolboxItem.getToolboxType(stack), ToolboxType.SIGN_ADJREM)) {
            return InteractionHandler.handleSign(world, pass.entity, key, stack);
        }
        Map<VehicleData, InteractRef> vehs = world.getVehicleDatas(pass.entity.getPos());
        for (Map.Entry<VehicleData, InteractRef> veh : vehs.entrySet()) {
            if (!InteractionHandler.handle(key, veh.getKey(), veh.getValue(), pass.getSeatOn(), pass.entity, stack)) continue;
            return true;
        }
        return false;
    }

    private static boolean handleSign(FvtmWorld world, EntityW pass, KeyPress key, StackWrapper stack) {
        if (last.equals("sign") && Time.getDate() < cooldown) {
            return false;
        }
        if (key.mouse_main()) {
            return false;
        }
        boolean si = stack.isItemOf(ContentType.SIGN.item_type);
        SignSystem system = (SignSystem)SystemManager.get(SystemManager.Systems.SIGN, (WorldW)world);
        V3D evec = pass.getEyeVec();
        V3D lvec = evec.add(pass.getLookVec().multiply(5.0));
        float size = 0.25f;
        for (SystemRegion reg : system.getRegions().values()) {
            for (SignInstance sign : reg.getObjects().values()) {
                aabb = AABB.create(sign.vec.vec.x - (double)size, sign.vec.vec.y - (double)size, sign.vec.vec.z - (double)size, sign.vec.vec.x + (double)size, sign.vec.vec.y + (double)size, sign.vec.vec.z + (double)size);
                if (!InteractionHandler.contains(evec, lvec, aabb)) continue;
                TagCW com = TagCW.create();
                sign.vec.write(com, "pos");
                if (pass.isShiftDown()) {
                    com.set("remove", true);
                }
                if (si) {
                    com.set("item", true);
                }
                Packets.send(Packet_TagListener.class, "sign_interact", com);
                cooldown = Time.getDate() + 20L;
                last = "sign";
                return true;
            }
        }
        return false;
    }

    private static boolean handleWire(FvtmWorld world, EntityW pass, KeyPress key, StackWrapper stack) {
        WIT type;
        if (last.equals("wire") && Time.getDate() < cooldown) {
            return false;
        }
        if (stack.isItemOf(ContentType.WIRE.item_type)) {
            type = WIT.WIRE;
        } else if (stack.isItemOf(ContentType.WIREDECO.item_type)) {
            WireDeco deco = (WireDeco)stack.getContent(ContentType.WIREDECO.item_type);
            type = deco.isRelayType() ? WIT.DECO_RELAY : WIT.DECO;
        } else {
            WIT wIT = type = ToolboxType.WIRE_SLACK.eq(ToolboxItem.getToolboxType(stack)) ? WIT.SLACK : WIT.REMOVAL;
        }
        if (key.mouse_main() && !type.slack()) {
            return false;
        }
        WireSystem system = (WireSystem)SystemManager.get(SystemManager.Systems.WIRE, (WorldW)world);
        V3D evec = pass.getEyeVec();
        V3D lvec = evec.add(pass.getLookVec().multiply(3.0));
        for (SystemRegion reg : system.getRegions().values()) {
            for (RelayHolder holder : reg.getObjects().values()) {
                for (WireRelay relay : holder.relays.values()) {
                    V3D cen;
                    float size;
                    float f = size = holder.hasRef() ? holder.ref().getSize(relay.getKey()) : 0.0125f;
                    if (type.slack() || type.deco()) {
                        for (Wire wr : relay.wires) {
                            if (wr.copy) continue;
                            cen = wr.getVectorPosition((double)wr.length * 0.5, false);
                            aabb = AABB.create(cen.x - (double)size, cen.y - (double)size, cen.z - (double)size, cen.x + (double)size, cen.y + (double)size, cen.z + (double)size);
                            if (!InteractionHandler.contains(evec, lvec, aabb)) continue;
                            TagCW com = TagCW.create();
                            com.set("holder", holder.pos, false);
                            com.set("relay", relay.getKey());
                            wr.key.save(com);
                            com.set("up", key.mouse_right());
                            Packets.send(Packet_TagListener.class, type.deco() ? "relay_wire_deco" : "relay_wire_slack", com);
                            cooldown = Time.getDate() + 20L;
                            last = "wire";
                            return true;
                        }
                        continue;
                    }
                    if (type.relay()) {
                        for (Wire wr : relay.wires) {
                            if (wr.copy) continue;
                            cen = wr.getVectorPosition(size, false);
                            aabb = AABB.create(cen.x - (double)size, cen.y - (double)size, cen.z - (double)size, cen.x + (double)size, cen.y + (double)size, cen.z + (double)size);
                            if (InteractionHandler.contains(evec, lvec, aabb)) {
                                TagCW com = TagCW.create();
                                com.set("holder", holder.pos, false);
                                com.set("relay", relay.getKey());
                                com.set("as", "relay_start");
                                wr.key.save(com);
                                Packets.send(Packet_TagListener.class, "relay_wire_deco", com);
                                cooldown = Time.getDate() + 20L;
                                last = "wire";
                                return true;
                            }
                            cen = wr.getVectorPosition(wr.length - size, false);
                            aabb = AABB.create(cen.x - (double)size, cen.y - (double)size, cen.z - (double)size, cen.x + (double)size, cen.y + (double)size, cen.z + (double)size);
                            if (!InteractionHandler.contains(evec, lvec, aabb)) continue;
                            TagCW com = TagCW.create();
                            com.set("holder", holder.pos, false);
                            com.set("relay", relay.getKey());
                            com.set("as", "relay_end");
                            wr.key.save(com);
                            Packets.send(Packet_TagListener.class, "relay_wire_deco", com);
                            cooldown = Time.getDate() + 20L;
                            last = "wire";
                            return true;
                        }
                        continue;
                    }
                    aabb = AABB.create(relay.pos.x - (double)size, relay.pos.y - (double)size, relay.pos.z - (double)size, relay.pos.x + (double)size, relay.pos.y + (double)size, relay.pos.z + (double)size);
                    if (!InteractionHandler.contains(evec, lvec, aabb)) continue;
                    TagCW com = TagCW.create();
                    com.set("holder", holder.pos, false);
                    com.set("relay", relay.getKey());
                    Packets.send(Packet_TagListener.class, type.wire() ? "relay_interact" : "relay_remove", com);
                    cooldown = Time.getDate() + 20L;
                    last = "wire";
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean contains(V3D evec, V3D lvec, AABB aabb) {
        for (float f = 0.0f; f < 3.125f; f += th32) {
            V3D vec0 = evec.distance(lvec, (double)f);
            if (!aabb.contains(vec0)) continue;
            return true;
        }
        return false;
    }

    private static boolean mountSeat(VehicleInstance vehicle, SeatInstance seat, EntityW pass, StackWrapper stack) {
        if (vehicle == null) {
            return false;
        }
        if (last.equals("seat") && Time.getDate() < cooldown) {
            return false;
        }
        if (!stack.empty() && stack.isItemOf(ContentType.TOOLBOX.item_type)) {
            return false;
        }
        if (seat == null) {
            seat = vehicle.getSeatOf(pass);
        }
        V3D evec = pass.getEyeVec();
        V3D lvec = evec.add(pass.getLookVec().multiply(3.0));
        for (int i = 0; i < vehicle.data.getSeats().size(); ++i) {
            SeatInstance nseat;
            if (seat != null && seat.index == i || (nseat = vehicle.seats.get(i)).passenger_direct() != null) continue;
            SwivelPoint point = nseat.point;
            V3D vec0 = point.getRelativeVector(nseat.seat.pos).add(vehicle.entity.getPos());
            aabb = AABB.create((double)(-seatbbsh), -0.0125, (double)(-seatbbsh), (double)seatbbsh, (double)seatbbs - 0.0125, (double)seatbbsh).offset(vec0);
            for (float f = 0.0f; f < 3.125f; f += th32) {
                vec0 = evec.distance(lvec, (double)f);
                if (!aabb.contains(vec0)) continue;
                TagCW com = TagCW.create();
                com.set("entity", vehicle.entity.getId());
                com.set("seat", i);
                Packets.send(Packet_TagListener.class, "mount_seat", com);
                cooldown = Time.getDate() + 20L;
                last = "seat";
                return true;
            }
        }
        return false;
    }

    private static <I extends Interactive> I getInteracted(boolean external, VehicleData data, InteractRef ref, EntityW pass, ArrayList<? extends Interactive> list) {
        if (((FvtmWorld)pass.getWorld()).noViewEntity()) {
            return null;
        }
        V3D evec = pass.getEyeVec();
        V3D lvec = evec.add(pass.getLookVec().multiply(external ? 3.0 : 2.0));
        LinkedHashMap<String, AABB> map = new LinkedHashMap<String, AABB>();
        for (Interactive interactive : list) {
            interactive.collect(external, data, ref, pass, map);
        }
        float f = 0.0f;
        while (true) {
            float f2 = external ? 3.125f : 2.125f;
            if (!(f < f2)) break;
            V3D vec0 = evec.distance(lvec, (double)f);
            for (Interactive interactive : list) {
                if (!map.containsKey(interactive.id()) || !map.get(interactive.id()).contains(vec0)) continue;
                return (I)interactive;
            }
            f += th32;
        }
        return null;
    }

    static {
        last = "";
        cooldown = 0L;
        seatbbs = 0.375f;
        seatbbsh = 0.1875f;
        th32 = 0.03125f;
        NON_EMPTY_VALID = new String[]{ContentType.VEHICLE.item_type, ContentType.PART.item_type, ContentType.MATERIAL.item_type, ContentType.TOOLBOX.item_type, StackWrapper.IT_LEAD, ContentType.WIRE.item_type, ContentType.WIREDECO.item_type, ContentType.SIGN.item_type};
    }

    public static class InteractRef {
        protected VehicleInstance inst;
        protected InteractRefHolder holder;
        protected V3I blkpos;
        protected long lpos;
        protected V3D pos;

        public InteractRef(InteractRefHolder irholder) {
            this.holder = irholder;
        }

        public InteractRef(VehicleInstance vehinst) {
            this.inst = vehinst;
            this.update();
        }

        public boolean isVehicle() {
            return this.inst != null;
        }

        public VehicleInstance vehicle() {
            return this.inst;
        }

        public void update() {
            this.pos = this.inst.entity == null ? (this.inst.railent == null ? null : this.inst.railent.pos) : this.inst.entity.getPos();
        }

        public void setPacket(TagCW com) {
            if (this.inst != null) {
                com.set("entity", this.inst.entity.getId());
            } else {
                com.set("lift", this.blkpos.toIntegerArray());
            }
        }

        public InteractRef set(V3I vec, long gpos, V3D vpos) {
            this.blkpos = vec;
            this.lpos = gpos;
            this.pos = vpos;
            return this;
        }

        public long longpos() {
            return this.lpos;
        }

        public InteractRefHolder holder() {
            return this.holder;
        }

        public String toString() {
            return String.valueOf(this.holder) + "-" + String.valueOf(this.pos);
        }
    }

    private static interface Interactive {
        public String id();

        public void collect(boolean var1, VehicleData var2, InteractRef var3, EntityW var4, Map<String, AABB> var5);
    }

    public static class AttrInteractive
    implements Interactive {
        protected Attribute<?> attribute;
        private SwivelPoint point;
        private WheelSlot wheel;
        private PartSlots slots;
        private String source;
        private String category;

        public AttrInteractive(Attribute attr) {
            this.attribute = attr;
        }

        @Override
        public String id() {
            return this.attribute.id;
        }

        @Override
        public void collect(boolean external, VehicleData data, InteractRef ref, EntityW player, Map<String, AABB> aabbs) {
            Object val = this.attribute.asString();
            if (external) {
                val = "external-" + (String)val;
            }
            AttrBox ab = this.attribute.getBox((String)val);
            PartData part = data.getAttributeOrigin(this.attribute);
            if (ab == null) {
                return;
            }
            this.point = data.getRotationPoint(ab.swivel_point);
            V3D pos = this.point.getRelativeVector(ab.pos.add(part == null ? V3D.NULL : part.getInstalledPos())).add(ref.pos);
            double hs = (double)ab.size * 0.5;
            aabbs.put(this.attribute.id, AABB.create(pos.x - hs, pos.y - hs, pos.z - hs, pos.x + hs, pos.y + hs, pos.z + hs));
        }
    }

    public static class InvInteractive
    implements Interactive {
        private String key;
        private FvtmInv inv;
        private PartData part;
        private int index;

        public InvInteractive(String id, FvtmInv finv, PartData data, int idx) {
            this.key = id;
            this.inv = finv;
            this.part = data;
            this.index = idx;
        }

        @Override
        public String id() {
            return (this.part == null ? "part-" : "") + this.key;
        }

        @Override
        public void collect(boolean external, VehicleData data, InteractRef ref, EntityW player, Map<String, AABB> aabbs) {
            V3D pos = this.part != null ? data.getRotationPoint(this.part.getSwivelPointInstalledOn()).getRelativeVector(this.part.getInstalledPos().add(this.inv.pos)).add(ref.pos) : data.getRotationPoint("vehicle").getRelativeVector(this.inv.pos).add(ref.pos);
            double hs = (double)this.inv.scale * 0.5;
            aabbs.put(this.id(), AABB.create(pos.x - hs, pos.y - hs, pos.z - hs, pos.x + hs, pos.y + hs, pos.z + hs));
        }
    }

    public static class PartSlotInteractive
    implements Interactive {
        private SwivelPoint point;
        private PartSlots slots;
        private String source;
        private String category;

        public PartSlotInteractive(SwivelPoint spoint, String src, PartSlots pslots, String cat) {
            this.point = spoint;
            this.source = src;
            this.slots = pslots;
            this.category = cat;
        }

        @Override
        public String id() {
            return this.source + ":" + this.category;
        }

        @Override
        public void collect(boolean external, VehicleData data, InteractRef ref, EntityW player, Map<String, AABB> aabbs) {
            V3D pos = ((PartSlot)this.slots.get((Object)this.category)).pos.copy();
            if (!this.source.equals("vehicle")) {
                pos = pos.add(data.getPart(this.source).getInstalledPos());
            }
            pos = this.point.getRelativeVector(pos).add(ref.pos);
            double hs = (double)((PartSlot)this.slots.get((Object)this.category)).radius * 0.5;
            aabbs.put(this.id(), AABB.create(pos.x - hs, pos.y - hs, pos.z - hs, pos.x + hs, pos.y + hs, pos.z + hs));
        }
    }

    public static class WheelInteractive
    implements Interactive {
        private WheelSlot wheel;
        private String category;

        public WheelInteractive(String key, WheelSlot slot) {
            this.category = key;
            this.wheel = slot;
        }

        @Override
        public String id() {
            return this.category;
        }

        @Override
        public void collect(boolean external, VehicleData data, InteractRef ref, EntityW player, Map<String, AABB> aabbs) {
            V3D pos = data.getRotationPoint("vehicle").getRelativeVector(this.wheel.position).add(ref.pos);
            double hs = (double)this.wheel.max_radius * 0.5;
            aabbs.put(this.id(), AABB.create(pos.x - hs, pos.y - hs, pos.z - hs, pos.x + hs, pos.y + hs, pos.z + hs));
        }
    }

    public static class InstPartInteractive
    implements Interactive {
        private SwivelPoint point;
        private PartData part;
        private String category;

        public InstPartInteractive(SwivelPoint spoint, Map.Entry<String, PartData> entry) {
            this.point = spoint;
            this.part = entry.getValue();
            this.category = entry.getKey();
        }

        @Override
        public String id() {
            return this.category;
        }

        @Override
        public void collect(boolean external, VehicleData data, InteractRef ref, EntityW player, Map<String, AABB> aabbs) {
            V3D pos = this.point.getRelativeVector(this.part.getInstalledPos()).add(ref.pos);
            aabbs.put(this.id(), AABB.create(pos.x - 0.25, pos.y - 0.25, pos.z - 0.25, pos.x + 0.25, pos.y + 0.25, pos.z + 0.25));
        }
    }

    public static class TrailerInteractive
    implements Interactive {
        private String cat;
        private V3D conn;

        public TrailerInteractive(String category, V3D vec) {
            this.conn = vec;
            this.cat = category;
        }

        @Override
        public String id() {
            return this.cat;
        }

        @Override
        public void collect(boolean external, VehicleData data, InteractRef ref, EntityW player, Map<String, AABB> aabbs) {
            V3D pos = data.getRotationPoint("vehicle").getRelativeVector(this.conn).add(ref.pos);
            double hs = 0.5;
            aabbs.put(this.id(), AABB.create(pos.x - hs, pos.y - hs, pos.z - hs, pos.x + hs, pos.y + hs, pos.z + hs));
        }
    }

    private static enum WIT {
        WIRE,
        DECO_RELAY,
        DECO,
        SLACK,
        REMOVAL;


        public boolean slack() {
            return this == SLACK;
        }

        public boolean wire() {
            return this == WIRE;
        }

        public boolean deco() {
            return this == DECO;
        }

        public boolean relay() {
            return this == DECO_RELAY;
        }
    }

    public static interface InteractRefHolder {
        public void markChanged();
    }
}

