/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.function.Consumer;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.JunctionGridItem;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.fvtm.data.root.Textureable;
import net.fexcraft.mod.fvtm.data.vehicle.EntitySystem;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.function.part.EngineFunction;
import net.fexcraft.mod.fvtm.function.part.TransmissionFunction;
import net.fexcraft.mod.fvtm.util.GenericUtils;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.MessageSender;
import net.minecraft.class_10712;
import net.minecraft.class_1074;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_2561;

public class VehicleItem
extends class_1792
implements ContentItem.ContentDataItem<Vehicle, VehicleData>,
ItemTextureable.TextureableItem<Vehicle>,
JunctionGridItem {
    private Vehicle vehicle;

    public VehicleItem(class_1792.class_1793 prop, Vehicle content) {
        super(prop.method_7889(1));
        this.vehicle = content;
    }

    public void method_67187(class_1799 stack, class_1792.class_9635 context, class_10712 disp, Consumer<class_2561> cons, class_1836 flag) {
        cons.accept(GenericUtils.format("&9Name: &7" + this.vehicle.getName()));
        for (String s : this.vehicle.getDescription()) {
            cons.accept(GenericUtils.format(class_1074.method_4662((String)s, (Object[])new Object[0])));
        }
        StackWrapper wrapper = UniStack.getStack((Object)stack);
        if (wrapper == null) {
            return;
        }
        VehicleData data = (VehicleData)wrapper.getContent(ContentType.VEHICLE.item_type);
        if (data == null) {
            return;
        }
        cons.accept(GenericUtils.format("&9Texture: &7" + VehicleItem.getTexTitle(data)));
        if (data.hasPart("engine")) {
            cons.accept(GenericUtils.format("&9Engine: &7" + ((Part)data.getPart("engine").getType()).getName()));
            cons.accept(GenericUtils.format("&9Fuel Group: &7" + data.getPart("engine").getFunction(EngineFunction.class, "fvtm:engine").getFuelGroup()[0]));
            cons.accept(GenericUtils.format("&9Fuel Stored: &7" + data.getAttribute("fuel_stored").asInteger() + "mB"));
        }
        if (data.hasPart("transmission")) {
            TransmissionFunction func = (TransmissionFunction)data.getFunctionInPart("transmission", "fvtm:transmission");
            cons.accept(GenericUtils.format("&9Transmission: &7" + (func == null ? "disfunctional" : (func.isAutomatic() ? "automatic" : "manual"))));
        }
        cons.accept(GenericUtils.format("&9Weight: &7" + data.getAttribute("weight").asFloat() + "kg"));
        cons.accept(GenericUtils.format("&9Seats: &7" + data.getSeats().size()));
        cons.accept(GenericUtils.format("&9LockCode: &7" + data.getLock().getCode()));
        if (this.vehicle.getModel() != null && this.vehicle.getModel().getCreators().size() > 0) {
            cons.accept(GenericUtils.format("&9Model by:"));
            for (String str : this.vehicle.getModel().getCreators()) {
                cons.accept(GenericUtils.format("&7- " + str));
            }
        }
    }

    protected static String getTexTitle(Textureable.TextureUser data) {
        if (data.getSelectedTexture() >= 0) {
            return "[" + data.getSelectedTexture() + "] " + data.getTexHolder().getDefaultTextures().get(data.getSelectedTexture()).name();
        }
        return data.isTextureExternal() ? "external" : "internal";
    }

    @Override
    public VehicleData getData(StackWrapper stack) {
        return this.getData(stack.directTag());
    }

    @Override
    public VehicleData getData(TagCW compound) {
        return new VehicleData(this.vehicle).read(compound);
    }

    public class_1269 method_7884(class_1838 context) {
        if (context.method_8045().field_9236) {
            return class_1269.field_5811;
        }
        StackWrapper stack = UniStack.getStack((Object)context.method_8041());
        VehicleData data = (VehicleData)stack.getContent(ContentType.VEHICLE.item_type);
        if (((Vehicle)data.getType()).isTrailer() && !context.method_8036().method_18276()) {
            return class_1269.field_5811;
        }
        EntityW ent = UniEntity.getEntity((Object)context.method_8036());
        EntitySystem.spawnVehicle((MessageSender)ent, ent.getWorld(), new V3D(context.method_17698().field_1352, context.method_17698().field_1351, context.method_17698().field_1350), data, UniStack.getStack((Object)stack));
        return class_1269.field_5812;
    }

    @Override
    public Vehicle getContent() {
        return this.vehicle;
    }

    @Override
    public ContentType getType() {
        return ContentType.VEHICLE;
    }

    @Override
    public boolean showJunctionGrid() {
        return this.vehicle.getVehicleType().isRailVehicle();
    }
}

