/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.frl.Polyhedron;
import net.fexcraft.lib.frl.Renderer;
import net.fexcraft.mod.fvtm.sys.uni.Path;
import net.fexcraft.mod.fvtm.sys.wire.Wire;

public class PathModelPositioned {
    public Polyhedron[] hedrons;
    protected V3D[] positions;

    public PathModelPositioned(Path path, RGB colour) {
        int i = (int)path.getLength(null);
        if (path.length % 1.0 > 0.0) {
            ++i;
        }
        if (i == 0) {
            i = 1;
        }
        this.hedrons = new Polyhedron[i];
        this.positions = new V3D[i];
        for (int k = 0; k < i; ++k) {
            this.hedrons[k] = new Polyhedron();
            this.positions[k] = path.getVectorPosition(k == 0 ? 0.125 : (k == i - 1 ? path.length - 0.125 : (double)k), false);
        }
    }

    public PathModelPositioned(Wire wire, RGB colour) {
        int i = (int)wire.getLength(null);
        if (wire.length % 1.0f > 0.0f) {
            ++i;
        }
        if (i == 0) {
            i = 1;
        }
        this.hedrons = new Polyhedron[i];
        this.positions = new V3D[i];
        for (int k = 0; k < i; ++k) {
            this.hedrons[k] = new Polyhedron();
            this.positions[k] = wire.getVectorPosition(k == 0 ? 0.125 : (k == i - 1 ? (double)(wire.length - 0.125f) : (double)k), false);
        }
    }

    public void clearGL() {
        for (Polyhedron hedron : this.hedrons) {
            if (hedron == null || hedron.glId == null) continue;
            Renderer.RENDERER.delete(hedron);
        }
    }

    public void render() {
        for (int m = 0; m < this.hedrons.length; ++m) {
            Renderer.RENDERER.light(this.positions[m]);
            Renderer.RENDERER.color(-1);
            this.hedrons[m].render();
        }
    }

    public void renderPlain() {
        for (int m = 0; m < this.hedrons.length; ++m) {
            this.hedrons[m].render();
        }
    }
}

