/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.condition;

import java.util.function.Function;
import net.fexcraft.mod.fvtm.sys.condition.CondKey;
import net.fexcraft.mod.fvtm.sys.condition.CondMode;
import net.fexcraft.mod.fvtm.sys.condition.ConditionRegistry;
import net.fexcraft.mod.fvtm.sys.condition.Conditional;

public class CondBuilderRoot {
    public static Function<CondKey, Conditional> run() {
        return key -> {
            switch (key.type) {
                case ATTRIBUTE: {
                    switch (key.mode) {
                        case BOOL_EQUAL: {
                            return (cond, data) -> data.vehicle.getAttributeBoolean(key.target, false).booleanValue() == cond.value.bool();
                        }
                        case BOOL_NEQUAL: {
                            return (cond, data) -> data.vehicle.getAttributeBoolean(key.target, false).booleanValue() != cond.value.bool();
                        }
                        case NUMB_EQUAL: {
                            return (cond, data) -> data.vehicle.getAttributeFloat(key.target, 0.0f) == cond.value.float_value();
                        }
                        case NUMB_NEQUAL: {
                            return (cond, data) -> data.vehicle.getAttributeFloat(key.target, 0.0f) != cond.value.float_value();
                        }
                        case EQUAL: {
                            return (cond, data) -> data.vehicle.getAttributeString(key.target, "null").equals(cond.value.string_value());
                        }
                        case NEQUAL: {
                            return (cond, data) -> !data.vehicle.getAttributeString(key.target, "null").equals(cond.value.string_value());
                        }
                        case LEQUAL: {
                            return (cond, data) -> data.vehicle.getAttributeFloat(key.target, 0.0f) <= cond.value.float_value();
                        }
                        case GEQUAL: {
                            return (cond, data) -> data.vehicle.getAttributeFloat(key.target, 0.0f) >= cond.value.float_value();
                        }
                        case LESS: {
                            return (cond, data) -> data.vehicle.getAttributeFloat(key.target, 0.0f) < cond.value.float_value();
                        }
                        case GREATER: {
                            return (cond, data) -> data.vehicle.getAttributeFloat(key.target, 0.0f) > cond.value.float_value();
                        }
                    }
                    break;
                }
                case TRACK_FROM: {
                    switch (key.mode) {
                        case NUMB_EQUAL: 
                        case EQUAL: {
                            return (cond, data) -> ((Integer)data.args[1]).intValue() == cond.value.integer_value();
                        }
                        case NUMB_NEQUAL: 
                        case NEQUAL: {
                            return (cond, data) -> ((Integer)data.args[1]).intValue() != cond.value.integer_value();
                        }
                        case LEQUAL: {
                            return (cond, data) -> (Integer)data.args[1] <= cond.value.integer_value();
                        }
                        case GEQUAL: {
                            return (cond, data) -> (Integer)data.args[1] >= cond.value.integer_value();
                        }
                        case LESS: {
                            return (cond, data) -> (Integer)data.args[1] < cond.value.integer_value();
                        }
                        case GREATER: {
                            return (cond, data) -> (Integer)data.args[1] > cond.value.integer_value();
                        }
                    }
                }
                case MULTI: {
                    Conditional[] als = ConditionRegistry.getByTarget(key.target);
                    if (key.mode == CondMode.AND) {
                        return (cond, data) -> als[0].isMet(cond, data) && als[1].isMet(cond, data);
                    }
                    if (key.mode == CondMode.ANN) {
                        return (cond, data) -> als[0].isMet(cond, data) && !als[1].isMet(cond, data);
                    }
                    if (key.mode == CondMode.OR) {
                        return (cond, data) -> als[0].isMet(cond, data) || als[1].isMet(cond, data);
                    }
                    return ConditionRegistry.COND_FALSE;
                }
                case DAYTIME: {
                    switch (key.mode) {
                        case BOOL_EQUAL: 
                        case NUMB_EQUAL: 
                        case EQUAL: {
                            return (cond, data) -> data.entity != null && data.entity.getWorld().getDayTime() == (long)cond.value.integer_value();
                        }
                        case BOOL_NEQUAL: 
                        case NUMB_NEQUAL: 
                        case NEQUAL: {
                            return (cond, data) -> data.entity != null && data.entity.getWorld().getDayTime() != (long)cond.value.integer_value();
                        }
                        case LEQUAL: {
                            return (cond, data) -> data.entity != null && data.entity.getWorld().getDayTime() <= (long)cond.value.integer_value();
                        }
                        case GEQUAL: {
                            return (cond, data) -> data.entity != null && data.entity.getWorld().getDayTime() >= (long)cond.value.integer_value();
                        }
                        case LESS: {
                            return (cond, data) -> data.entity != null && data.entity.getWorld().getDayTime() < (long)cond.value.integer_value();
                        }
                        case GREATER: {
                            return (cond, data) -> data.entity != null && data.entity.getWorld().getDayTime() > (long)cond.value.integer_value();
                        }
                    }
                }
            }
            return null;
        };
    }
}

