/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.rail;

import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.FvtmPlayer;
import net.fexcraft.mod.fvtm.data.RailGauge;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.rail.Track;
import net.fexcraft.mod.fvtm.util.QV3D;

public class LongDisRailUtil {
    public static void add(FvtmPlayer player) {
        V3I pos = player.entity.getV3I();
        player.longdis.add(pos);
        player.entity.send("fvtm.rail.long_distance.added", new Object[]{pos.x, pos.y, pos.z});
    }

    public static void clear(FvtmPlayer player) {
        player.longdis.clear();
        player.entity.send("fvtm.rail.long_distance.cleared");
    }

    public static void seg(FvtmPlayer player, int val) {
        player.segmentation = val;
        if (player.segmentation < 4) {
            player.segmentation = 4;
        }
        if (player.segmentation > 32) {
            player.segmentation = 32;
        }
        player.entity.send("fvtm.rail.long_distance.segments_set", new Object[]{player.segmentation});
    }

    public static void process(FvtmPlayer player) {
        if (player.longdis.size() < 2) {
            return;
        }
        if (!player.entity.getHeldItem(true).isItemOf(ContentType.RAILGAUGE.item_type)) {
            player.entity.send("fvtm.rail.long_distance.no_gauge");
            return;
        }
        RailGauge gauge = (RailGauge)player.entity.getHeldItem(true).getContent(ContentType.RAILGAUGE.item_type);
        player.entity.send("fvtm.rail.long_distance.starting");
        RailSystem sys = player.getRailSystem();
        QV3D[] path = new QV3D[player.longdis.size()];
        for (int idx = 0; idx < player.longdis.size(); ++idx) {
            V3I pos = player.longdis.get(idx);
            Junction jun = sys.getJunction(pos);
            path[idx] = jun != null ? jun.getPos() : new QV3D((double)pos.x + 0.5, pos.y, (double)pos.z + 0.5);
        }
        Track track = new Track(null, path, gauge);
        if (track.length < 16.0) {
            player.entity.send("fvtm.rail.long_distance.too_short");
            return;
        }
        float pass = 0.0f;
        QV3D last = path[0];
        Junction star = sys.getJunction(last.pos);
        if (star == null) {
            sys.addJunction(last);
            star = sys.getJunction(last.pos);
        }
        if (star.full()) {
            player.entity.send("fvtm.rail.long_distance.junction_full", new Object[]{star.posString()});
            return;
        }
        int total = 0;
        double length = 0.0;
        double quarter = (double)player.segmentation * 0.25;
        double triquar = (double)player.segmentation * 0.75;
        while ((double)pass < track.length) {
            QV3D curr = new QV3D(track.getVectorPosition0(pass + (float)player.segmentation, false));
            Junction junc = sys.getJunction(curr.pos, true);
            if (junc == null) {
                sys.addJunction(curr);
                junc = sys.getJunction(curr.pos);
            }
            if (junc.full()) {
                player.entity.send("fvtm.rail.long_distance.junction_full", new Object[]{star.posString()});
                return;
            }
            QV3D[] points = new QV3D[4];
            points[3] = last;
            points[2] = new QV3D(track.getVectorPosition0((double)pass + quarter, false));
            points[1] = new QV3D(track.getVectorPosition0((double)pass + triquar, false));
            points[0] = curr;
            Track ntr = new Track(junc, points, gauge);
            junc.addnew(ntr);
            star.addnew(ntr.createOppositeCopy());
            star = junc;
            last = curr;
            length += track.length;
            ++total;
            pass += (float)player.segmentation;
        }
        player.entity.send("fvtm.rail.long_distance.finished", new Object[]{total, length});
        LongDisRailUtil.clear(player);
    }

    public static void status(FvtmPlayer player) {
        player.entity.send("[FVTM] === === ===");
        player.entity.send("fvtm.rail.long_distance.info");
        player.entity.send("fvtm.rail.long_distance.segments", new Object[]{player.segmentation});
        player.entity.send("fvtm.rail.long_distance.points");
        for (V3I key : player.longdis) {
            player.entity.send("- " + key.x + ", " + key.y + ", " + key.z);
        }
    }
}

