/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.rail;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.fvtm.sys.rail.Compound;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailEntity;
import net.fexcraft.mod.fvtm.sys.rail.RailRegion;
import net.fexcraft.mod.fvtm.sys.rail.Section;
import net.fexcraft.mod.fvtm.sys.rail.Track;
import net.fexcraft.mod.fvtm.sys.rail.TrackUnit;
import net.fexcraft.mod.fvtm.sys.uni.DetachedSystem;
import net.fexcraft.mod.fvtm.sys.uni.PathKey;
import net.fexcraft.mod.fvtm.sys.uni.RegionKey;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;
import net.fexcraft.mod.uni.world.ChunkW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.WorldType;
import net.fexcraft.mod.uni.world.WorldW;
import net.fexcraft.mod.uni.world.WrapperHolder;

public class RailSystem
extends DetachedSystem<RailSystem, Junction> {
    private long gc_entities;
    private long gc_sections;
    private long gc_compounds;
    public final ConcurrentHashMap<Long, TagCW> fillqueue = new ConcurrentHashMap();
    private TrackMap trackunits = new TrackMap(this);
    private SectionMap sections = new SectionMap(this);
    private TreeMap<Long, RegionKey> entities = new TreeMap();

    public RailSystem(WorldW sw, WorldType wtype, File file) {
        super(sw, wtype, file);
        if (wtype.server()) {
            this.load();
        }
    }

    public RailRegion newRegion(RegionKey key) {
        return new RailRegion(this, key);
    }

    @Override
    public SystemManager.Systems getType() {
        return SystemManager.Systems.RAIL;
    }

    public void load() {
        TagCW compound;
        File file = new File(this.getSaveRoot(), "/railsystem.dat");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if ((compound = WrapperHolder.read((File)file)) == null || compound.empty()) {
            return;
        }
        this.gc_entities = compound.getLong("GlobalCounterEntities");
        this.gc_sections = compound.getLong("GlobalCounterSections");
        this.gc_compounds = compound.getLong("GlobalCounterCompounds");
        if (compound.has("Entities")) {
            TagCW enty = compound.getCompound("Entities");
            for (String str : enty.keys()) {
                try {
                    this.entities.put(Long.parseLong(str, 16), new RegionKey(enty.getLong(str)));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void save() {
        File file;
        TagCW compound = TagCW.create();
        compound.set("GlobalCounterEntities", this.gc_entities);
        compound.set("GlobalCounterSections", this.gc_sections);
        compound.set("GlobalCounterCompounds", this.gc_compounds);
        if (!this.entities.isEmpty()) {
            TagCW enty = TagCW.create();
            this.entities.forEach((key, value) -> enty.set(Long.toHexString(key), value.toLong()));
            compound.set("Entities", enty);
        }
        if (!(file = new File(this.getSaveRoot(), "/railsystem.dat")).getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        WrapperHolder.write((TagCW)compound, (File)file);
    }

    @Override
    public Junction create(SystemRegion<RailSystem, Junction> region, V3I pos) {
        return new Junction(region);
    }

    @Override
    public void writeRegion(SystemRegion<RailSystem, Junction> region, TagCW compound, boolean sync) {
        if (!region.getObjects().isEmpty()) {
            TagLW list = TagLW.create();
            for (Junction junc : region.getObjects().values()) {
                try {
                    list.add(junc.write());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            compound.set("Junctions", list);
        }
        if (sync) {
            return;
        }
        RailRegion reg = (RailRegion)region;
        if (!reg.entities.isEmpty()) {
            TagLW list = TagLW.create();
            for (RailEntity entity : reg.entities.values()) {
                if (entity.com.isSingular()) {
                    list.add(entity.write(null));
                    continue;
                }
                if (!entity.com.isMultiple() || !entity.com.isHead(entity)) continue;
                TagCW com = TagCW.create();
                com.set("Compound", entity.com.uid);
                com.set("Forward", entity.com.forward);
                com.set("Singular", false);
                TagLW ents = TagLW.create();
                for (RailEntity ent : entity.com.entities) {
                    try {
                        ents.add(ent.write(null));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                com.set("Entities", ents);
                list.add(com);
            }
            compound.set("Entities", list);
        }
    }

    @Override
    public void readRegion(SystemRegion<RailSystem, Junction> region, TagCW com) {
        RailRegion reg = (RailRegion)region;
        if (com.has("Junctions")) {
            region.getObjects().clear();
            TagLW list = com.getList("Junctions");
            list.forEach(tag -> {
                try {
                    Junction junc = new Junction(region);
                    junc.read((TagCW)tag);
                    region.getObjects().put(junc.getV3I(), junc);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        if (com.has("Entities")) {
            reg.entities.clear();
            com.getList("Entities").forEach(tag -> {
                try {
                    this.fillqueue.put(tag.getLong("Compound"), (TagCW)tag);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public Junction getJunction(V3I vec) {
        RailRegion region = (RailRegion)this.regions.getC(vec, false);
        return region == null ? null : (Junction)region.get(vec);
    }

    public Junction getJunction(V3I vec, boolean load) {
        RailRegion region = (RailRegion)this.regions.getC(vec, load);
        return (Junction)region.get(vec);
    }

    public ArrayList<Junction> getJunctionsInChunk(int cx, int cz) {
        ArrayList<Junction> arr = new ArrayList<Junction>();
        SystemRegion region = this.regions.get(RegionKey.getRegionXZ(cx, cz), false);
        if (region == null) {
            return arr;
        }
        for (Map.Entry entry : region.getObjects().entrySet()) {
            if (entry.getKey().x >> 4 != cx || entry.getKey().z >> 4 != cz) continue;
            arr.add((Junction)entry.getValue());
        }
        return arr;
    }

    public ArrayList<Junction> getJunctionsAt(int x, int y, int z) {
        return this.getJunctionsAt(WrapperHolder.mutPos((int)x, (int)y, (int)z));
    }

    public ArrayList<Junction> getJunctionsAt(V3I pos) {
        ArrayList<Junction> arr = new ArrayList<Junction>();
        SystemRegion region = this.regions.get(RegionKey.getRegionXZ(pos));
        if (region == null) {
            return arr;
        }
        for (Map.Entry entry : region.getObjects().entrySet()) {
            if (!entry.getKey().equals((Object)pos)) continue;
            arr.add((Junction)entry.getValue());
        }
        return arr;
    }

    public boolean delJunction(V3I vector) {
        SystemRegion region = this.regions.get(vector, false);
        if (region == null || region.get(vector) == null) {
            return false;
        }
        Junction junc = (Junction)region.getObjects().remove(vector);
        if (this.wtype.client()) {
            return junc != null;
        }
        if (junc != null) {
            if (!junc.tracks.isEmpty()) {
                return false;
            }
            junc.unlinkLinkedTileEntities();
        }
        region.setAccessed();
        this.updateClient("no_junction", vector);
        return true;
    }

    public void addJunction(QV3D vector) {
        SystemRegion<RailSystem, Junction> region = this.regions.get(vector.pos, true);
        if (region == null) {
            return;
        }
        Junction junction = new Junction(region, vector);
        region.getObjects().put(vector.pos, junction);
        region.setAccessed();
        this.updateClient("junction", vector.pos);
    }

    public void updateJuncton(V3I vector) {
        SystemRegion region = this.regions.get(vector, true);
        if (region == null) {
            return;
        }
        region.setAccessed();
        this.updateClient("junction", vector);
    }

    @Override
    public void onServerTick() {
        if (this.wtype.client()) {
            return;
        }
        if (SystemManager.SINGLEPLAYER && !SystemManager.CLIENTLOADED) {
            boolean bl = SystemManager.CLIENTLOADED = SystemManager.get(SystemManager.Systems.RAIL, this.wtype.rec_key()) != null;
            if (!SystemManager.CLIENTLOADED) {
                return;
            }
        }
        if (!(this.fillqueue.isEmpty() || SystemManager.SINGLEPLAYER && !SystemManager.CLIENTLOADED)) {
            FvtmLogger.debug((Object)("Processing RailEntities in Queue " + this.fillqueue.size()));
            ArrayList<Long> torem = new ArrayList<Long>();
            for (Long uid : this.fillqueue.keySet()) {
                Compound.Multiple multiple;
                SystemRegion region;
                TagCW com = this.fillqueue.get(uid);
                boolean single = com.getBoolean("Singular");
                if (single) {
                    region = (RailRegion)this.getRegions().getC(com.getIntArray("region"), true);
                    if (region == null || !((RailRegion)region).loaded) continue;
                    if (FvtmRegistry.VEHICLES.get(com.getString("Vehicle")) == null) {
                        FvtmLogger.log((Object)("SINGULAR Rail Vehicle Type with id '" + com.getString("Vehicle") + "' not found, removing."));
                        FvtmLogger.log((Object)("NBT:" + String.valueOf(com)));
                        torem.add(uid);
                        continue;
                    }
                    Compound.Singular singular = new Compound.Singular((RailRegion)region, com.getLong("Compound"), com);
                    if (singular.getEntitites().isEmpty()) continue;
                    singular.forward = com.getBoolean("forward");
                    ((RailRegion)region).spawnEntity(singular.getEntitites().get(0).start());
                    torem.add(uid);
                    continue;
                }
                boolean allregionsloaded = true;
                for (TagCW tag : com.getList("Entities")) {
                    if (tag == null || !tag.has("region") || (region = (RailRegion)this.getRegions().getC(tag.getIntArray("region"), true)) != null && ((RailRegion)region).loaded) continue;
                    allregionsloaded = false;
                    break;
                }
                if (!allregionsloaded || (multiple = new Compound.Multiple(this, null, uid, com.getList("Entities"))).getEntitites().size() == 0) continue;
                multiple.forward = com.getBoolean("Forward");
                for (RailEntity ent : multiple.entities) {
                    ent.region.spawnEntity(ent.start());
                }
                torem.add(uid);
            }
            torem.forEach(this.fillqueue::remove);
            torem.clear();
        }
        for (SystemRegion region : this.regions.values()) {
            RailRegion reg = (RailRegion)region;
            if (!reg.entities.isEmpty()) {
                reg.setAccessed();
            }
            for (RailEntity ent : reg.entities.values()) {
                ent.onUpdate();
            }
            if (reg.timer >= 20) {
                reg.timer = 0;
                for (Junction junction : reg.getObjects().values()) {
                    junction.update();
                }
                for (RailEntity ent : reg.entities.values()) {
                    ent.checkIfShouldHaveEntity();
                }
            }
            ++reg.timer;
        }
    }

    @Override
    public void onClientTick() {
        if (!this.wtype.client() || this.fillqueue.isEmpty()) {
            return;
        }
        FvtmLogger.debug((Object)("Processing RailEntities in Queue " + this.fillqueue.size()));
        ArrayList<Long> torem = new ArrayList<Long>();
        for (Long uid : this.fillqueue.keySet()) {
            TagCW compound = this.fillqueue.get(uid);
            FvtmLogger.debug((Object)("Checking " + uid));
            if (!compound.has("region")) {
                FvtmLogger.log((Object)("Invalid spawn data for RailEntity " + uid));
                FvtmLogger.log((Object)compound);
                torem.add(uid);
                continue;
            }
            RailRegion region = (RailRegion)this.getRegions().getC(compound.getIntArray("region"), false);
            if (region == null || !region.loaded) continue;
            FvtmLogger.debug((Object)("Processing " + uid + " - " + region.key.x + "/" + region.key.z));
            region.spawnEntity(new RailEntity(region, compound.getLong("uid")).read(compound));
            torem.add(uid);
        }
        torem.forEach(this.fillqueue::remove);
        torem.clear();
    }

    @Override
    public void unload() {
        if (!this.wtype.client()) {
            this.regions.values().forEach(reg -> reg.save());
            this.save();
        }
        this.regions.clear();
    }

    public void updateClient(String kind, V3I vector) {
        if (this.wtype.client()) {
            return;
        }
        TagCW compound = null;
        String task = null;
        switch (kind) {
            case "junction": {
                Junction junction = this.getJunction(vector);
                if (junction == null) {
                    return;
                }
                task = "rail_upd_junc";
                compound = junction.write();
                compound.set("pos", vector);
                break;
            }
            case "no_junction": {
                compound = TagCW.create();
                task = "rail_rem_junc";
                compound.set("pos", vector);
                break;
            }
            case "junction_state": {
                Junction junction = this.getJunction(vector);
                if (junction == null) {
                    return;
                }
                task = "rail_upd_junc_state";
                compound = TagCW.create();
                compound.set("pos", vector);
                compound.set("switch0", junction.switch0);
                compound.set("switch1", junction.switch1);
                break;
            }
            case "junction_signal": {
                Junction junction = this.getJunction(vector);
                if (junction == null) {
                    return;
                }
                task = "rail_upd_junc_signal";
                compound = TagCW.create();
                compound.set("pos", vector);
                if (!junction.hasSignals()) {
                    compound.set("nosignal", true);
                    break;
                }
                compound.set("sig0", junction.sigtype0.ordinal());
                compound.set("sig1", junction.sigtype1.ordinal());
                break;
            }
            case "junction_signal_state": {
                Junction junction = this.getJunction(vector);
                if (junction == null) {
                    return;
                }
                task = "rail_upd_junc_signal_state";
                compound = TagCW.create();
                compound.set("pos", vector);
                compound.set("signal0", junction.sigstate0);
                compound.set("signal1", junction.sigstate1);
                break;
            }
            case "sections": {
                task = "rail_upd_sections";
                compound = TagCW.create();
                TagLW list = TagLW.create();
                for (TrackUnit unit : this.trackunits.values()) {
                    TagCW com = TagCW.create();
                    com.set("unit", unit.getUID());
                    com.set("section", unit.getSectionId());
                    list.add(com);
                }
                compound.set("units", list);
                break;
            }
        }
        if (compound == null) {
            return;
        }
        compound.set("dim", this.wtype.rec_key());
        Packets.sendToAllTrackingPos(Packets.PKT_TAG, this.getServerWorld(), vector, task, compound);
    }

    public void updateClient(String kind, RailEntity entity) {
        if (this.wtype.client()) {
            return;
        }
        TagCW compound = null;
        String task = null;
        switch (kind) {
            case "removed": {
                task = "rail_rem_ent";
                compound = TagCW.create();
                compound.set("uid", entity.uid);
            }
        }
        if (compound == null) {
            return;
        }
        compound.set("dim", this.wtype.rec_key());
        Packets.sendToAll(Packets.PKT_TAG, task, compound);
    }

    @Override
    public void onChunkLoad(ChunkW chunk) {
        this.regions.get((int[])RegionKey.getRegionXZ((int)chunk.x(), (int)chunk.z()), (boolean)true).chucks.put(new RegionKey(chunk.x(), chunk.z()), chunk);
    }

    @Override
    public void onChunkUnload(ChunkW chunk) {
        this.regions.get((int[])RegionKey.getRegionXZ((int)chunk.x(), (int)chunk.z()), (boolean)true).chucks.values().removeIf(pre -> pre.x() == chunk.x() && pre.z() == chunk.z());
    }

    public void registerEntity(RailEntity entity) {
        this.entities.put(entity.getUID(), entity.getRegion().key);
    }

    public RailEntity getEntity(long uid, boolean load) {
        RailRegion region;
        for (RegionKey key : this.regions.keySet()) {
            RailRegion reg = (RailRegion)this.regions.getC(key, false);
            if (!reg.getEntities().containsKey(uid)) continue;
            return reg.getEntities().get(uid);
        }
        if (load && this.entities.containsKey(uid) && (region = (RailRegion)this.regions.getC(this.entities.get(uid), true)) != null) {
            return region.getEntities().get(uid);
        }
        return null;
    }

    public void updateEntityEntry(long uid, int x, int z) {
        this.entities.put(uid, new RegionKey(x, z));
    }

    public void updateEntityEntry(long uid, RegionKey key) {
        this.entities.put(uid, key);
    }

    public long getNewEntityId() {
        return this.gc_entities++;
    }

    public long getNewSectionId() {
        return this.gc_sections++;
    }

    public long getNewCompoundId() {
        return this.gc_compounds++;
    }

    public void delEntity(RailEntity entity) {
        entity.region.getEntities().remove(entity.getUID());
        this.entities.remove(entity.getUID());
        this.updateClient("removed", entity);
    }

    public Track getTrack(PathKey key) {
        RailRegion region = (RailRegion)this.regions.getC(RegionKey.getRegionXZ(key), true);
        return region == null ? null : region.getTrack(key);
    }

    public TrackMap getTrackUnits() {
        return this.trackunits;
    }

    public SectionMap getSections() {
        return this.sections;
    }

    public Section getSection(Long sid) {
        return this.sections.get(sid, true);
    }

    public void sendReload(String string, EntityW sender) {
        SystemRegion region = this.regions.get(RegionKey.getRegionXZ(sender.getPos()));
        if (region != null) {
            this.updateClient(string, sender.getV3I());
        }
    }

    public TreeMap<Long, RegionKey> getEntityIndex() {
        return this.entities;
    }

    @Override
    public boolean hasTimer() {
        return true;
    }

    @Override
    public long getTimerInterval() {
        return Config.RAIL_SAVE_INTERVAL;
    }

    @Override
    public void addTimerTask(long time) {
        this.timer.schedule((TimerTask)new TimedTask(this), new Date(time), (long)Config.RAIL_SAVE_INTERVAL);
    }

    @Override
    public String getRegFolderName() {
        return "railregions";
    }

    public static class TrackMap
    extends TreeMap<String, TrackUnit> {
        private RailSystem data;

        public TrackMap(RailSystem raildata) {
            this.data = raildata;
        }

        public TrackUnit get(String str, Long knownid, boolean create) {
            if (!create) {
                return (TrackUnit)super.get(str);
            }
            TrackUnit trk = (TrackUnit)super.get(str);
            if (trk == null) {
                trk = new TrackUnit(this.data, str, knownid);
                this.put(str, trk);
            }
            return trk;
        }
    }

    public static class SectionMap
    extends TreeMap<Long, Section> {
        private RailSystem data;

        public SectionMap(RailSystem raildata) {
            this.data = raildata;
        }

        public Section get(Long sid, boolean create) {
            if (create && sid == null) {
                Section sec = new Section(this.data, null);
                this.put(sec.getUID(), sec);
                return sec;
            }
            if (sid == null) {
                return null;
            }
            if (!create) {
                return (Section)super.get(sid);
            }
            Section sec = (Section)super.get(sid);
            if (sec == null) {
                sec = new Section(this.data, sid);
                this.put(sid, sec);
            }
            return sec;
        }
    }

    public static class TimedTask
    extends TimerTask {
        private RailSystem railsys;

        public TimedTask(RailSystem railsys) {
            this.railsys = railsys;
        }

        @Override
        public void run() {
            ArrayList<SystemRegion> regs = new ArrayList<SystemRegion>();
            for (SystemRegion region : this.railsys.regions.values()) {
                region.save();
                if (!region.chucks.isEmpty() || region.lastaccess >= Time.getDate() - 60000L) continue;
                regs.add(region);
            }
            for (SystemRegion region : regs) {
                this.railsys.regions.remove(region.key);
            }
        }
    }
}

