/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.rail;

import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.RailGauge;
import net.fexcraft.mod.fvtm.render.PathModelPositioned;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.TrackUnit;
import net.fexcraft.mod.fvtm.sys.uni.Path;
import net.fexcraft.mod.fvtm.sys.uni.PathType;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.tag.TagCW;

public class Track
extends Path {
    public RailGauge gauge;
    protected TrackUnit unit;
    protected Junction junction;
    public PathModelPositioned railmodel;
    public PathModelPositioned restmodel;
    public String preset;
    public int items;

    public Track(Junction junction, QV3D[] gridvecs, QV3D vector, RailGauge gauge) {
        super(gridvecs, vector);
        this.junction = junction;
        this.gauge = gauge;
        this.setunit();
    }

    public Track(Junction junction, QV3D[] gridvecs, RailGauge gauge) {
        super(gridvecs);
        this.junction = junction;
        this.gauge = gauge;
        this.setunit();
    }

    private void setunit() {
        if (this.junction == null) {
            return;
        }
        Long id = null;
        if (this.junction.size() == 0) {
            this.junction = this.junction.root.getJunction(this.end.pos);
            id = this.junction.size() == 0 ? null : Long.valueOf(this.junction.tracks.get((int)0).unit.getSectionId());
        } else {
            id = this.junction.tracks.get((int)0).unit.getSectionId();
        }
        this.unit = this.getUnit(id);
    }

    public Track(Junction junc) {
        this.junction = junc;
    }

    @Override
    public Track read(TagCW compound) {
        super.read(compound);
        if (this.junction != null) {
            this.unit = this.getUnit(compound.getLong("section"));
        }
        if (compound.has("gauge")) {
            this.gauge = FvtmRegistry.RAILGAUGES.get(compound.getString("gauge"));
        }
        if (this.gauge == null) {
            this.gauge = FvtmRegistry.RAILGAUGES.get(FvtmRegistry.STANDARD_GAUGE);
        }
        if (this.junction == null || this.junction.root.isRemote()) {
            this.railmodel = null;
            this.restmodel = null;
        }
        if (compound.has("preset")) {
            this.preset = compound.getString("preset");
        }
        if (compound.has("items")) {
            this.items = compound.getInteger("items");
        }
        return this;
    }

    public TrackUnit getUnit(Long knownid) {
        TrackUnit unit = this.junction.root.getTrackUnits().get(this.id.toUnitId(this.copy), knownid, true);
        if (this.copy) {
            unit.copy = this;
        } else {
            unit.orig = this;
        }
        return unit;
    }

    @Override
    public TagCW write(TagCW compound) {
        compound = super.write(compound);
        if (this.unit != null) {
            compound.set("section", this.unit.getSectionId());
        }
        compound.set("gauge", (this.gauge == null ? FvtmRegistry.STANDARD_GAUGE : this.gauge.getIDS()).toString());
        if (this.preset != null) {
            compound.set("preset", this.preset);
        }
        if (this.items > 0) {
            compound.set("items", this.items);
        }
        return compound;
    }

    public Track createOppositeCopy() {
        Track track = super.createOppositeCopy(new Track(this.junction));
        track.unit = this.unit;
        track.gauge = this.gauge;
        track.preset = this.preset;
        track.items = this.items;
        return track;
    }

    public boolean isCompatibleGauge(RailGauge gauge) {
        return this.gauge.getWidth() == gauge.getWidth() || this.gauge.getCompatible().contains(gauge.getIDS().toString());
    }

    public RailGauge getGauge() {
        return this.gauge;
    }

    @Override
    public V3D getVectorPosition(double distance, boolean reverse) {
        V3D vec = this.getVectorPosition0(distance, reverse);
        vec.y += (double)this.gauge.getHeight();
        return vec;
    }

    @Override
    public String toString() {
        return String.format("Track[%s-%s, %s, %s, %s, %s]", this.start, this.end, this.vecpath.length, this.unit == null ? "n/u" : this.unit.getSectionId() + "/s", this.copy ? "copy" : "original", this.items);
    }

    public TrackUnit getUnit() {
        return this.unit;
    }

    @Override
    public PathType getType() {
        return PathType.RAIL;
    }

    public Junction getJunction() {
        return this.junction;
    }

    public V3D getVectorOnTrack(V3D ext) {
        V3D at = this.vecpath[0];
        double dis = ext.dis(this.vecpath[0]);
        for (V3D vec : this.vecpath) {
            double d;
            double tes = vec.dis(ext);
            if (!(d < dis)) continue;
            dis = tes;
            at = vec;
        }
        return at;
    }

    public double getPassedOnTrack(V3D ext) {
        double dis;
        V3D at;
        float passed = 0.0f;
        V3D last = at = this.getVectorOnTrack(ext);
        for (int i = 1; i < this.vecpath.length && !((dis = last.dis(this.vecpath[i])) < (double)0.001f); ++i) {
            passed = (float)((double)passed + dis);
        }
        return passed;
    }

    public Track withPreset(String string) {
        this.preset = string;
        return this;
    }
}

