/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.uni;

import java.util.ArrayList;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.sys.uni.PathKey;
import net.fexcraft.mod.fvtm.sys.uni.PathType;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.fvtm.util.Vec3D;
import net.fexcraft.mod.uni.tag.TagCW;

public abstract class Path {
    public QV3D start;
    public QV3D end;
    public QV3D[] rootpath;
    public boolean copy;
    public V3D[] vecpath;
    public PathKey id;
    public PathKey op;
    public double length;

    public Path(QV3D[] gridvecs, QV3D vector) {
        this.start = gridvecs[0];
        this.end = vector;
        this.id = new PathKey(this.start, this.end);
        this.op = new PathKey(this.id, true);
        this.rootpath = new QV3D[gridvecs.length + 1];
        for (int i = 0; i < this.rootpath.length - 1; ++i) {
            this.rootpath[i] = gridvecs[i].copy();
        }
        this.rootpath[this.rootpath.length - 1] = vector.copy();
        this.construct();
    }

    public Path(QV3D ... gridvecs) {
        this.start = gridvecs[0];
        this.end = gridvecs[gridvecs.length - 1];
        this.id = new PathKey(this.start, this.end);
        this.op = new PathKey(this.id, true);
        this.rootpath = new QV3D[gridvecs.length];
        for (int i = 0; i < this.rootpath.length; ++i) {
            this.rootpath[i] = gridvecs[i].copy();
        }
        this.construct();
    }

    public Path() {
    }

    protected void construct() {
        this.vecpath = new V3D[this.rootpath.length];
        if (this.vecpath.length == 2) {
            this.vecpath[0] = this.rootpath[0].vec;
            this.vecpath[1] = this.rootpath[this.rootpath.length - 1].vec;
            this.length = this.vecpath[0].dis(this.vecpath[1]);
        } else {
            for (int i = 0; i < this.rootpath.length; ++i) {
                this.vecpath[i] = this.rootpath[i].vec;
            }
            V3D[] vecs = this.curve(this.vecpath);
            this.vecpath = new V3D[vecs.length + 2];
            this.vecpath[0] = new V3D(this.start.vec);
            for (int i = 0; i < vecs.length; ++i) {
                this.vecpath[i + 1] = vecs[i];
            }
            this.vecpath[this.vecpath.length - 1] = new V3D(this.end.vec);
            this.length = this.calcLength();
        }
    }

    private V3D[] curve(V3D[] vecpoints) {
        ArrayList<V3D> vecs = new ArrayList<V3D>();
        double length = this.getLength(vecpoints);
        double increment = 1.0 / length / (double)Config.RAIL_SEGMENTATOR;
        double d = 0.0;
        while (d < 1.0) {
            V3D[] moved = vecpoints;
            while (moved.length > 2) {
                V3D[] arr = new V3D[moved.length - 1];
                for (int i = 0; i < moved.length - 1; ++i) {
                    arr[i] = Path.move(moved[i], moved[i + 1], moved[i].dis(moved[i + 1]) * d);
                }
                moved = arr;
            }
            vecs.add(Path.move(moved[0], moved[1], moved[0].dis(moved[1]) * (d += increment)));
        }
        return vecs.toArray(new V3D[0]);
    }

    public static V3D move(V3D vec0, V3D vec1, double dis) {
        double[] dest = Vec3D.newVector(vec1);
        double[] beg = Vec3D.newVector(vec0);
        dest = Vec3D.direction(dest[0] - beg[0], dest[1] - beg[1], dest[2] - beg[2]);
        dest = Vec3D.newVector(beg[0] + dest[0] * dis, beg[1] + dest[1] * dis, beg[2] + dest[2] * dis);
        return new V3D(dest[0], dest[1], dest[2]);
    }

    public double getLength(V3D[] vecs) {
        vecs = vecs == null ? this.vecpath : vecs;
        float temp = 0.0f;
        for (int i = 0; i < vecs.length - 1; ++i) {
            temp = (float)((double)temp + vecs[i].dis(vecs[i + 1]));
        }
        return temp;
    }

    protected double calcLength() {
        return this.getLength(null);
    }

    public Path read(TagCW compound) {
        this.id = new PathKey(compound);
        this.op = new PathKey(this.id, true);
        this.copy = compound.getBoolean("copy");
        this.start = new QV3D(compound, "start");
        this.end = new QV3D(compound, "end");
        this.rootpath = new QV3D[compound.getInteger("vectors")];
        for (int i = 0; i < this.rootpath.length; ++i) {
            this.rootpath[i] = new QV3D(compound, "vector-" + i);
        }
        this.construct();
        this.length = compound.has("length") ? compound.getDouble("length") : this.calcLength();
        return this;
    }

    public TagCW write(TagCW compound) {
        if (compound == null) {
            compound = TagCW.create();
        }
        this.id.write(compound);
        compound.set("copy", this.copy);
        this.start.write(compound, "start");
        this.end.write(compound, "end");
        compound.set("vectors", this.rootpath.length);
        for (int i = 0; i < this.rootpath.length; ++i) {
            this.rootpath[i].write(compound, "vector-" + i);
        }
        compound.set("length", this.length);
        return compound;
    }

    public V3D getFirstVector() {
        return this.vecpath.length == 0 ? null : this.vecpath[0];
    }

    public V3D getLastVector() {
        return this.vecpath.length == 0 ? null : this.vecpath[this.vecpath.length - 1];
    }

    public PathKey getId() {
        return this.id;
    }

    public PathKey getId(boolean opp) {
        return opp ? this.getOppositeId() : this.getId();
    }

    public <T extends Path> T createOppositeCopy(T instance) {
        instance.id = new PathKey(this.id, true);
        instance.op = new PathKey(this.id, false);
        instance.start = this.end;
        instance.end = this.start;
        instance.copy = true;
        instance.rootpath = new QV3D[this.rootpath.length];
        int j = this.rootpath.length - 1;
        for (int i = 0; i < instance.rootpath.length; ++i) {
            instance.rootpath[i] = this.rootpath[j--].copy();
        }
        instance.construct();
        instance.length = instance.calcLength();
        return instance;
    }

    public boolean isOppositeCopy() {
        return this.copy;
    }

    public PathKey getOppositeId() {
        return this.op;
    }

    public double[] getPosition(double distance) {
        if (distance >= this.length) {
            if (distance == this.length) {
                this.vecpath[this.vecpath.length - 1].toFloatArray();
            }
            return new double[]{distance - this.length};
        }
        double traveled = 0.0;
        for (int i = 0; i < this.vecpath.length - 1; ++i) {
            double multi = this.vecpath[i].dis(this.vecpath[i + 1]);
            double temp = traveled + multi;
            if (temp >= distance) {
                if (temp == distance) {
                    return this.vecpath[i + 1].toDoubleArray();
                }
                return this.vecpath[i + 1].distance(this.vecpath[i], temp - distance).toDoubleArray();
            }
            traveled += multi;
        }
        return this.vecpath[0].toDoubleArray();
    }

    public V3D getVectorPosition0(double distance, boolean reverse) {
        if (reverse) {
            distance = this.oppositePassed(distance);
        }
        if (distance >= this.length) {
            return new V3D(this.vecpath[this.vecpath.length - 1]);
        }
        double traveled = 0.0;
        for (int i = 0; i < this.vecpath.length - 1; ++i) {
            double multi = this.vecpath[i].dis(this.vecpath[i + 1]);
            double temp = traveled + multi;
            if (temp >= distance) {
                if (temp == distance) {
                    return new V3D(this.vecpath[i + 1]);
                }
                return this.vecpath[i + 1].distance(this.vecpath[i], temp - distance);
            }
            traveled += multi;
        }
        return new V3D(this.vecpath[0]);
    }

    public abstract V3D getVectorPosition(double var1, boolean var3);

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Path) {
            Path path = (Path)obj;
            return path.getId().equals(this.getId()) && path.getType() == this.getType();
        }
        return false;
    }

    public String toString() {
        return String.format("Path[%s-%s, %s, %s]", this.start, this.end, this.vecpath.length, this.copy ? "copy" : "original");
    }

    public double oppositePassed(double sec) {
        return sec >= this.length ? 0.0 : (sec <= 0.0 ? this.length : this.length - sec);
    }

    public abstract PathType getType();
}

