/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.uni;

import java.util.ArrayList;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.sys.uni.Axle;
import net.fexcraft.mod.fvtm.sys.uni.ClassicVehMove;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.fvtm.sys.uni.WheelTireData;

public class PrototypeVehMove
extends ClassicVehMove {
    public ArrayList<Axle> axles = new ArrayList();
    public boolean overloaded;
    public Axle ax_fron;
    public Axle ax_rear;
    public double wheelbase;
    public double cg_height;
    public double appmass = 0.0;
    public double force;
    public double accel = 0.0;
    public double angor = 0.0;
    public double abvel = 0.0;
    public double torq;
    public int rpm;
    public int orpm;

    public PrototypeVehMove(VehicleInstance vi) {
        super(vi);
    }

    @Override
    public void setupAxles() {
        this.axles.clear();
        for (WheelTireData wheel : this.inst.wheeldata.values()) {
            Axle axle = null;
            for (Axle ax : this.axles) {
                if (ax.pos.z != wheel.pos.z || ax.pos.y != wheel.pos.y) continue;
                axle = ax;
                break;
            }
            if (axle == null) {
                axle = new Axle(this.axles.size(), new V3D(0.0, wheel.pos.y, wheel.pos.z));
                this.axles.add(axle);
            }
            axle.wheels.add(wheel);
            wheel.axle = axle;
        }
        this.axles.forEach(Axle::initCenter);
        double amin = 16.0;
        double amax = -16.0;
        for (Axle axle : this.axles) {
            if (axle.pos.z < amin) {
                amin = axle.pos.z;
                this.ax_fron = axle;
            }
            if (!(axle.pos.z > amax)) continue;
            amax = axle.pos.z;
            this.ax_rear = axle;
        }
        this.wheelbase = Math.abs(amin) + Math.abs(amax);
        this.cg_height = 0.0;
        for (Axle axle : this.axles) {
            axle.weight_ratio = Math.abs(axle.pos.z) / this.wheelbase;
            this.cg_height += axle.pos.y;
        }
        this.cg_height /= (double)this.axles.size();
    }

    @Override
    public void updateAttrs() {
        this.inst.data.getAttribute("rpm").set(this.rpm / 100 * 100);
    }

    @Override
    public void move(boolean cons) {
        if (this.inst.front == null) {
            this.remass();
        }
        this.move0(cons);
        if (this.inst.rear != null) {
            this.inst.rear.align();
        }
    }

    private void move0(boolean nocons) {
        double tracf;
        double tr;
        if (((Vehicle)this.inst.data.getType()).isTrailer()) {
            return;
        }
        double mass = this.appmass;
        double rr = this.inst.data.getAttributeFloat("roll_resistance", 8.0f);
        double ar = this.inst.data.getAttributeFloat("air_resistance", 2.5f);
        double axpwdiv = 0.0;
        for (Axle axle : this.axles) {
            axle.calc(mass, this.accel, this.cg_height, this.wheelbase, this.angor);
            axle.powered = axle.wheels.get((int)0).slot.powered(this.inst.data);
            axpwdiv += 1.0;
        }
        if (axpwdiv > 0.0) {
            axpwdiv = 1.0 / axpwdiv;
        }
        this.overloaded = this.appmass - (double)this.inst.data.getAttributeFloat("weight", 1000.0f) > (double)this.inst.data.getAttributeFloat("max_towing", 3500.0f);
        boolean cons = nocons || this.inst.engine != null && this.inst.consumeFuel();
        double brkf = (double)this.inst.data.getAttributeFloat("brake_force", 10000.0f) * this.inst.brake;
        double brake = Math.min(brkf + (double)(this.inst.pbrake ? this.inst.data.getAttributeFloat("parking_brake_force", 5000.0f) : 0.0f), brkf) * 0.25;
        int gear = this.inst.data.getAttributeInteger("gear", 0);
        float diff = this.inst.data.getAttributeFloat("differential_ratio", 3.5f);
        double d = tr = this.inst.transmission == null ? 0.0 : this.inst.transmission.getRatio(gear);
        if (this.inst.engine != null && this.inst.transmission != null) {
            this.orpm = this.rpm;
            this.rpm = (int)(this.inst.speed * this.axles.get((int)0).radius * 72.0 * tr * (double)diff * 60.0 / 6.2831854820251465);
            if (this.rpm < 0) {
                this.rpm = -this.rpm;
            }
            if (this.rpm < this.inst.engine.minRPM()) {
                this.rpm = this.inst.engine.minRPM();
            }
            if (this.rpm > this.inst.engine.maxRPM()) {
                this.rpm = this.inst.engine.maxRPM();
            }
        }
        this.force = 0.0;
        if (!this.overloaded && this.inst.engine != null && this.inst.transmission != null) {
            this.torq = this.inst.engine.getTorque(this.rpm);
            this.force = this.torq * (double)diff * (double)this.inst.transmission.getEfficiency();
            if (this.inst.transmission.isAutomatic() && this.inst.autogear_timer <= 0) {
                int ngear = this.inst.transmission.processAutoShift(gear, this.rpm, this.inst.engine.maxRPM(), this.inst.throttle);
                if (ngear != gear) {
                    this.inst.data.getAttribute("gear").set(ngear);
                    this.inst.updateAttr("gear");
                }
                this.inst.autogear_timer += this.inst.transmission.getShiftSpeed();
            }
            this.force = this.force * this.inst.throttle * axpwdiv;
        }
        double s = -Math.cos(-this.inst.pivot().yaw());
        double c = -Math.sin(-this.inst.pivot().yaw());
        double steer_rad = -Math.toRadians(this.inst.steer_yaw);
        this.inst.entity.setOnGround(true);
        this.accel = 0.0;
        double mov_for = c * this.inst.motion.x + s * this.inst.motion.z;
        double mov_sig = Math.signum(mov_for);
        double mov_sid = c * this.inst.motion.z - s * this.inst.motion.x;
        double steer_sig = mov_sig * steer_rad;
        double slipf = Math.atan2(mov_sid + this.ax_fron.yaw_speed, Math.abs(mov_for)) - (this.ax_fron.steering ? steer_sig : 0.0);
        double slipr = Math.atan2(mov_sid + this.ax_rear.yaw_speed, Math.abs(mov_for)) - (this.ax_rear.steering ? steer_sig : 0.0);
        double gripf = this.ax_fron.getGrip(this.inst);
        double gripr = this.ax_rear.getGrip(this.inst);
        double fricf = this.ax_fron.getFric(slipf, gripf);
        double fricr = this.ax_rear.getFric(slipr, gripr);
        double d2 = cons && this.ax_fron.powered ? this.force / this.ax_fron.radius * (tr == 0.0 ? 0.0 : 1.0 / tr) : (tracf = 0.0);
        double tracr = cons && this.ax_rear.powered ? this.force / this.ax_rear.radius * (tr == 0.0 ? 0.0 : 1.0 / tr) : 0.0;
        double drag_f = -(rr * mov_for + ar * mov_for * Math.abs(mov_for));
        double drag_s = -(rr * mov_sid + ar * mov_sid * Math.abs(mov_sid));
        double res_f = (drag_f + (tracf -= brake * mov_sig) + (tracr -= brake * mov_sig)) / mass;
        double frics = (this.ax_fron.steering ? Math.cos(steer_rad) * fricf : fricf) + (this.ax_rear.steering ? Math.cos(steer_rad) * fricr : fricr);
        double res_s = (drag_s + frics) / mass;
        this.accel += res_f;
        V3D.add((double)((c * res_f - s * res_s) * 0.05), (double)0.0, (double)((s * res_f + c * res_s) * 0.05), (V3D)this.inst.motion);
        this.abvel = this.inst.motion.length();
        double antor = fricf * -this.ax_fron.pos.z - fricr * this.ax_rear.pos.z;
        if (this.abvel < 0.05 && this.inst.throttle < 0.01) {
            this.inst.motion.set(0.0, 0.0, 0.0);
            antor = 0.0;
            this.abvel = 0.0;
        }
        this.angor = -antor / mass * 0.05;
        this.inst.pivot().set_yaw((float)((double)this.inst.pivot().yaw() + this.angor * 0.05), false);
        this.inst.entity.move(this.inst.motion);
        this.inst.pos = this.inst.entity.getPos();
        this.accel /= (double)this.inst.wheels.size();
    }

    private void remass() {
        if (this.inst.rear != null) {
            PrototypeVehMove trailer = (PrototypeVehMove)this.inst.rear.vm();
            while (trailer.inst.rear != null) {
                trailer = (PrototypeVehMove)trailer.inst.rear.vm();
            }
            PrototypeVehMove truck = (PrototypeVehMove)trailer.inst.front.vm();
            trailer.appmass = trailer.inst.data.getAttributeFloat("weight", 1000.0f);
            while (truck != null) {
                truck.appmass = truck.inst.data.getAttributeFloat("weight", 1000.0f);
                truck.appmass += ((PrototypeVehMove)truck.inst.rear.vm()).appmass * (double)truck.inst.rear.data.getAttributeFloat("trailer_weight_ratio", 0.2f);
                truck = (PrototypeVehMove)truck.inst.front.vm();
            }
        } else {
            this.appmass = this.inst.data.getAttributeFloat("weight", 1000.0f);
        }
    }

    @Override
    public double yaw(double dx, double dz) {
        return this.inst.speed > 0.01 ? (double)this.inst.pivot().yaw() : -Math.atan2(dx, dz);
    }
}

