/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.wire;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.WireDeco;
import net.fexcraft.mod.fvtm.data.WireType;
import net.fexcraft.mod.fvtm.model.content.WireMD;
import net.fexcraft.mod.fvtm.sys.uni.Path;
import net.fexcraft.mod.fvtm.sys.uni.PathType;
import net.fexcraft.mod.fvtm.sys.wire.WireKey;
import net.fexcraft.mod.fvtm.sys.wire.WireRelay;
import net.fexcraft.mod.fvtm.sys.wire.WireUnit;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;

public class Wire {
    public WireKey key;
    public WireKey okey;
    public V3D start;
    public V3D end;
    public V3D[] rootpath = new V3D[3];
    public V3D[] vecpath;
    public float length;
    protected WireUnit unit;
    protected WireRelay relay;
    protected WireType type;
    public boolean copy;
    public float slack = 0.0f;
    public LinkedHashMap<String, WireDeco> decos;
    public WireMD model;

    public Wire(WireRelay relay, WireRelay relay0, WireType wiretype, V3D s_v, V3D e_v) {
        this(relay);
        this.key = new WireKey(relay, relay0);
        this.okey = new WireKey(relay0, relay);
        this.type = wiretype;
        this.slack = this.type.getDefaultSlack();
        this.rootpath = new V3D[]{s_v, null, e_v};
        this.start = s_v;
        this.end = e_v;
        this.reslack();
    }

    public void reslack() {
        this.rootpath[0] = this.start;
        this.rootpath[1] = this.start.middle(this.end).add(0.0, (double)(-this.slack), 0.0);
        this.rootpath[2] = this.end;
        this.vecpath = new V3D[this.rootpath.length];
        this.construct();
    }

    public void construct() {
        this.vecpath = new V3D[this.rootpath.length];
        for (int i = 0; i < this.rootpath.length; ++i) {
            this.vecpath[i] = this.rootpath[i];
        }
        V3D[] vecs = this.curve(this.vecpath);
        this.vecpath = new V3D[vecs.length + 2];
        this.vecpath[0] = this.rootpath[0];
        for (int i = 0; i < vecs.length; ++i) {
            this.vecpath[i + 1] = vecs[i];
        }
        this.vecpath[this.vecpath.length - 1] = this.rootpath[2];
        this.length = this.calcLength();
    }

    public float getLength(V3D[] vecs) {
        vecs = vecs == null ? this.vecpath : vecs;
        float temp = 0.0f;
        for (int i = 0; i < vecs.length - 1; ++i) {
            temp = (float)((double)temp + vecs[i].dis(vecs[i + 1]));
        }
        return temp;
    }

    protected float calcLength() {
        return this.getLength(null);
    }

    private V3D[] curve(V3D[] vecpoints) {
        ArrayList<V3D> vecs = new ArrayList<V3D>();
        float length = this.getLength(vecpoints);
        float increment = 1.0f / length / (float)this.type.getSegmentation();
        double d = 0.0;
        while (d < 1.0) {
            V3D[] moved = vecpoints;
            while (moved.length > 2) {
                V3D[] arr = new V3D[moved.length - 1];
                for (int i = 0; i < moved.length - 1; ++i) {
                    arr[i] = Path.move(moved[i], moved[i + 1], moved[i].dis(moved[i + 1]) * d);
                }
                moved = arr;
            }
            vecs.add(Path.move(moved[0], moved[1], moved[0].dis(moved[1]) * (d += (double)increment)));
        }
        return vecs.toArray(new V3D[0]);
    }

    public Wire(WireRelay relay) {
        this.relay = relay;
    }

    public Wire read(TagCW compound) {
        if (compound.has("wiretype")) {
            this.type = FvtmRegistry.WIRES.get(compound.getString("wiretype"));
        }
        this.start = new V3D((double)compound.getFloat("sx"), (double)compound.getFloat("sy"), (double)compound.getFloat("sz"));
        this.end = new V3D((double)compound.getFloat("ex"), (double)compound.getFloat("ey"), (double)compound.getFloat("ez"));
        if (compound.has("slack")) {
            this.slack = compound.getFloat("slack");
        }
        this.reslack();
        this.construct();
        this.key = new WireKey(compound);
        this.okey = this.key.opposite();
        this.copy = compound.has("copy") && compound.getBoolean("copy");
        float f = this.length = compound.has("length") ? compound.getFloat("length") : this.calcLength();
        if (compound.has("decos")) {
            if (this.decos == null) {
                this.decos = new LinkedHashMap();
            }
            TagLW list = compound.getList("decos");
            for (int i = 0; i < list.size(); ++i) {
                String[] split = list.getString(i).split(";");
                WireDeco deco = FvtmRegistry.WIREDECOS.get(split[1]);
                if (deco == null) continue;
                this.decos.put(split[0], deco);
            }
        } else {
            this.decos = null;
        }
        this.model = null;
        return this;
    }

    public TagCW write(TagCW compound) {
        if (compound == null) {
            compound = TagCW.create();
        }
        compound.set("sx", this.start.x);
        compound.set("sy", this.start.y);
        compound.set("sz", this.start.z);
        compound.set("ex", this.end.x);
        compound.set("ey", this.end.y);
        compound.set("ez", this.end.z);
        compound.set("slack", this.slack);
        compound.set("length", this.length);
        this.key.save(compound);
        if (this.copy) {
            compound.set("copy", this.copy);
        }
        if (this.type != null) {
            compound.set("wiretype", this.type.getIDS());
        }
        if (this.decos != null && this.decos.size() > 0) {
            TagLW list = TagLW.create();
            for (Map.Entry<String, WireDeco> entry : this.decos.entrySet()) {
                list.add(entry.getKey() + ";" + entry.getValue().getIDS());
            }
            compound.set("decos", list);
        }
        return compound;
    }

    public Wire copyTo(Wire wire) {
        wire.key = this.okey;
        wire.okey = this.key;
        wire.start = this.end;
        wire.end = this.start;
        wire.copy = true;
        wire.type = this.type;
        wire.rootpath = new V3D[this.rootpath.length];
        wire.rootpath[0] = this.rootpath[2];
        wire.rootpath[1] = this.rootpath[1];
        wire.rootpath[2] = this.rootpath[0];
        wire.construct();
        wire.length = wire.calcLength();
        wire.slack = this.slack;
        return wire;
    }

    public Wire createOppositeCopy() {
        Wire wire = this.copyTo(new Wire(this.relay));
        wire.unit = this.unit;
        return wire;
    }

    public V3D getVectorPosition(double distance, boolean reverse) {
        if (reverse) {
            distance = this.oppositePassed(distance);
        }
        if (distance >= (double)this.length) {
            return new V3D(this.vecpath[this.vecpath.length - 1]);
        }
        double traveled = 0.0;
        for (int i = 0; i < this.vecpath.length - 1; ++i) {
            double multi = this.vecpath[i].dis(this.vecpath[i + 1]);
            double temp = traveled + multi;
            if (temp >= distance) {
                if (temp == distance) {
                    return new V3D(this.vecpath[i + 1]);
                }
                return this.vecpath[i + 1].distance(this.vecpath[i], temp - distance);
            }
            traveled += multi;
        }
        return new V3D(this.vecpath[0]);
    }

    public double oppositePassed(double sec) {
        return sec >= (double)this.length ? 0.0 : (sec <= 0.0 ? (double)this.length : (double)this.length - sec);
    }

    public String toString() {
        return String.format("Wire[%s-%s, %s, %s, %s]", this.start, this.end, this.vecpath.length, this.unit == null ? "n/u" : Long.valueOf(this.unit.getSectionId()), this.copy ? "copy" : "original");
    }

    public WireUnit getUnit() {
        return this.unit;
    }

    public PathType getType() {
        return PathType.WIRE;
    }

    public WireRelay getRelay() {
        return this.relay;
    }

    public WireType getWireType() {
        return this.type;
    }

    public V3D getVectorOnWire(V3D ext) {
        V3D at = this.vecpath[0];
        double dis = ext.dis(this.vecpath[0]);
        for (V3D vec : this.vecpath) {
            double d;
            double tes = vec.dis(ext);
            if (!(d < dis)) continue;
            dis = tes;
            at = vec;
        }
        return at;
    }

    public float getPassedOnWire(V3D ext) {
        double dis;
        V3D at;
        float passed = 0.0f;
        V3D last = at = this.getVectorOnWire(ext);
        for (int i = 1; i < this.vecpath.length && !((dis = last.dis(this.vecpath[i])) < (double)0.001f); ++i) {
            passed = (float)((double)passed + dis);
        }
        return passed;
    }
}

