/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.wire;

import net.fexcraft.mod.fvtm.packet.Packet_TagListener;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.fvtm.sys.wire.Wire;
import net.fexcraft.mod.fvtm.sys.wire.WireSection;
import net.fexcraft.mod.fvtm.sys.wire.WireSystem;
import net.fexcraft.mod.uni.tag.TagCW;

public class WireUnit {
    private WireSystem data;
    protected Wire orig;
    protected Wire copy;
    private WireSection section;
    private String uid;

    public WireUnit(WireSystem data, String str, Long sid) {
        this.uid = str;
        this.data = data;
        this.section = this.data.getSection(sid);
        this.section.insert(this);
    }

    public String getUID() {
        return this.uid;
    }

    public long getSectionId() {
        return this.section.getUID();
    }

    public WireSection section() {
        return this.section;
    }

    public boolean equals(Object o) {
        if (!(o instanceof WireUnit)) {
            return false;
        }
        return ((WireUnit)o).uid.equals(this.uid);
    }

    public WireUnit setSection(WireSection section) {
        this.section = section;
        this.updateClient();
        return this;
    }

    public String toString() {
        return "WireUnit[" + this.uid + "/" + String.valueOf(this.section == null ? "NULL" : Long.valueOf(this.section.getUID())) + "]";
    }

    private void updateClient() {
        if (this.data.isRemote()) {
            return;
        }
        TagCW compound = TagCW.create();
        compound.set("target_listener", "fvtm:wiresys");
        compound.set("task", "update_unit_section");
        compound.set("unit", this.getUID());
        compound.set("section", this.getSectionId());
        compound.set("dim", this.data.getWorldType().rec_key());
        if (this.orig == null && this.copy == null) {
            Packets.sendToAll(Packet_TagListener.class, "wire_udp_unit", compound);
        } else {
            Wire wire = this.orig == null ? this.copy : this.orig;
            Packets.sendToAll(Packet_TagListener.class, ((WireSystem)wire.relay.holder.getRegion().system).getServerWorld(), wire.relay.holder.pos, "wire_udp_unit", compound);
            if (wire.length > 16.0f && this.orig != null) {
                Packets.sendToAll(Packet_TagListener.class, ((WireSystem)wire.relay.holder.getRegion().system).getServerWorld(), this.copy.relay.holder.pos, "wire_udp_unit", compound);
            }
        }
    }
}

