/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.ui.rail;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.sys.rail.Track;
import net.fexcraft.mod.fvtm.ui.rail.RailJunctionContainer;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class RailJunction
extends UserInterface {
    public static final RGB BLU = new RGB(38143);
    public static final RGB RED = new RGB(13376041);
    public static final RGB GRE = new RGB(65313);
    public static final RGB ORA = new RGB(16738816);
    private static BufferedImage conv = new BufferedImage(64, 64, 1);
    private static int[][] grid = new int[64][64];
    private static RGB temp = new RGB();
    public static RGB[] TRACK_RGB = new RGB[]{BLU, RED, GRE, ORA};
    public static Color[] TRACK_COLOR = new Color[]{Color.BLUE, Color.RED, Color.GREEN, Color.ORANGE};
    private RailJunctionContainer menu;

    public RailJunction(JsonMap map, ContainerInterface con) throws Exception {
        super(map, con);
        this.menu = (RailJunctionContainer)con;
    }

    public void init() {
        ((UIText)this.texts.get("title")).value(this.menu.junc.posString());
        this.updateGrid();
    }

    public void predraw(float ticks, int mx, int my) {
        if (this.menu.junc == null) {
            return;
        }
        switch (this.menu.junc.type) {
            case STRAIGHT: {
                ((UIText)this.texts.get("switch0")).value("inactive");
                ((UIText)this.texts.get("switch1")).value("inactive");
                ((UIButton)this.buttons.get((Object)"switch00")).ecolor = BLU;
                ((UIButton)this.buttons.get((Object)"switch01")).ecolor = RED;
                ((UIButton)this.buttons.get((Object)"switch10")).ecolor = RGB.WHITE;
                ((UIButton)this.buttons.get((Object)"switch11")).ecolor = RGB.WHITE;
                break;
            }
            case FORK_2: {
                ((UIText)this.texts.get("switch0")).value("Switch0: " + this.menu.junc.switch0);
                ((UIText)this.texts.get("switch1")).value("inactive");
                ((UIButton)this.buttons.get((Object)"switch00")).ecolor = BLU;
                ((UIButton)this.buttons.get((Object)"switch01")).ecolor = this.menu.junc.switch0 ? RED : GRE;
                ((UIButton)this.buttons.get((Object)"switch10")).ecolor = RGB.WHITE;
                ((UIButton)this.buttons.get((Object)"switch11")).ecolor = RGB.WHITE;
                break;
            }
            case FORK_3: {
                ((UIText)this.texts.get("switch0")).value("Switch0+1: " + this.menu.junc.switch0 + " / " + this.menu.junc.switch1);
                ((UIText)this.texts.get("switch1")).value("inactive");
                ((UIButton)this.buttons.get((Object)"switch00")).ecolor = BLU;
                ((UIButton)this.buttons.get((Object)"switch01")).ecolor = this.menu.junc.switch0 ? RED : (this.menu.junc.switch1 ? ORA : GRE);
                ((UIButton)this.buttons.get((Object)"switch10")).ecolor = RGB.WHITE;
                ((UIButton)this.buttons.get((Object)"switch11")).ecolor = RGB.WHITE;
                break;
            }
            case DOUBLE: {
                ((UIText)this.texts.get("switch0")).value("Switch0: " + this.menu.junc.switch0);
                ((UIText)this.texts.get("switch1")).value("Switch1: " + this.menu.junc.switch1);
                ((UIButton)this.buttons.get((Object)"switch00")).ecolor = this.menu.junc.switch1 ? BLU : ORA;
                ((UIButton)this.buttons.get((Object)"switch01")).ecolor = this.menu.junc.switch0 ? RED : GRE;
                ((UIButton)this.buttons.get((Object)"switch10")).ecolor = this.menu.junc.switch0 ? RED : GRE;
                ((UIButton)this.buttons.get((Object)"switch11")).ecolor = this.menu.junc.switch1 ? BLU : ORA;
                break;
            }
            case CROSSING: {
                ((UIText)this.texts.get("switch0")).value("inactive");
                ((UIText)this.texts.get("switch1")).value("inactive");
                ((UIButton)this.buttons.get((Object)"switch00")).ecolor = BLU;
                ((UIButton)this.buttons.get((Object)"switch01")).ecolor = RED;
                ((UIButton)this.buttons.get((Object)"switch10")).ecolor = GRE;
                ((UIButton)this.buttons.get((Object)"switch11")).ecolor = ORA;
            }
        }
        for (int i = 0; i < 4; ++i) {
            ((UIText)this.texts.get("track" + i)).value(i >= this.menu.junc.size() ? "" : this.menu.junc.tracks.get((int)i).id.toPosString());
        }
    }

    public void drawbackground(float ticks, int mx, int my) {
        if (this.menu.junc == null) {
            return;
        }
        this.drawer.bindTabTex((UserInterface)this, "main");
        this.drawer.draw((float)(this.gLeft + 73 + this.menu.junc.type.ordinal() * 18), (float)(this.gTop + 21), 0, 238, 18, 18);
    }

    public void postdraw(float ticks, int mx, int my) {
        if (this.menu.junc == null) {
            return;
        }
        this.drawer.bind(FvtmRegistry.WHITE_TEXTURE);
        for (int xo = 0; xo < 64; ++xo) {
            for (int yo = 0; yo < 64; ++yo) {
                if (grid[xo][yo] == 0) continue;
                RailJunction.temp.packed = grid[xo][yo];
                this.drawer.apply(temp);
                this.drawer.drawFull((float)(xo + this.gLeft + 7), (float)(yo + this.gTop + 21), 1, 1);
            }
        }
        this.drawer.applyWhite();
    }

    public boolean onAction(UIButton button, String id, int x, int y, int mb) {
        switch (id) {
            case "switch0": 
            case "switch1": 
            case "type_2": 
            case "type_3": 
            case "type_4": 
            case "down0": 
            case "down1": 
            case "down2": 
            case "up1": 
            case "up2": 
            case "up3": 
            case "rem0": 
            case "rem1": 
            case "rem2": 
            case "rem3": 
            case "signal_edit": 
            case "signal_remove": 
            case "events": {
                TagCW com = TagCW.create();
                com.set("task", id);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
            case "copy": {
                this.root.setClipboard(this.menu.junc.posString());
                break;
            }
        }
        return false;
    }

    public void getTooltip(int mx, int my, List<String> list) {
        if (((UIButton)this.buttons.get("section")).hovered()) {
            long last = -1L;
            for (int i = 0; i < this.menu.junc.tracks.size(); ++i) {
                Track track = this.menu.junc.tracks.get(i);
                if (last == track.getUnit().section().getUID()) continue;
                last = track.getUnit().section().getUID();
                list.add((String)RailJunctionContainer.TRANSFORMAT.apply("ui.fvtm.rail_junction.section", new Object[]{i, track.getUnit().section().getUID()}));
            }
        }
        if (((UIButton)this.buttons.get("signal")).hovered()) {
            list.add((String)RailJunctionContainer.TRANSFORMAT.apply("ui.fvtm.rail_junction.signal", new Object[]{this.menu.junc.sigtype0.name() + "/" + this.menu.junc.sigtype1.name()}));
        }
    }

    public void updateGrid() {
        for (int x = 0; x < 64; ++x) {
            for (int y = 0; y < 64; ++y) {
                conv.setRGB(x, y, Color.BLACK.getRGB());
            }
        }
        Graphics2D g = conv.createGraphics();
        ArrayList<Track> tracks = new ArrayList<Track>(this.menu.junc.tracks);
        for (int i = 0; i < tracks.size(); ++i) {
            V3D vec1;
            V3D vec0;
            Track track = tracks.get(i);
            g.setColor(TRACK_COLOR[i]);
            if (track.vecpath.length == 2) {
                vec0 = track.vecpath[0];
                vec1 = vec0.distance(track.vecpath[1], 15.0);
                g.drawLine((int)((vec0.x - (double)this.menu.pos.x + 16.0) * 2.0), (int)((vec0.z - (double)this.menu.pos.z + 16.0) * 2.0), (int)((vec1.x - (double)this.menu.pos.x + 16.0) * 2.0), (int)((vec1.z - (double)this.menu.pos.z + 16.0) * 2.0));
                continue;
            }
            for (int j = 0; j < track.vecpath.length - 1; ++j) {
                vec0 = track.vecpath[j];
                vec1 = track.vecpath[j + 1];
                double x0 = vec0.x - (double)this.menu.pos.x;
                double z0 = vec0.z - (double)this.menu.pos.z;
                if (x0 < -16.0 || z0 < -16.0 || x0 > 16.0 || z0 > 16.0) continue;
                double x1 = vec1.x - (double)this.menu.pos.x;
                double z1 = vec1.z - (double)this.menu.pos.z;
                if (x1 < -16.0 || z1 < -16.0 || x1 > 16.0 || z1 > 16.0) continue;
                g.drawLine((int)((x0 + 16.0) * 2.0), (int)((z0 + 16.0) * 2.0), (int)((x1 + 16.0) * 2.0), (int)((z1 + 16.0) * 2.0));
            }
        }
        g.dispose();
        for (int xo = 0; xo < 64; ++xo) {
            for (int yo = 0; yo < 64; ++yo) {
                int c = conv.getRGB(xo, yo);
                RailJunction.grid[xo][yo] = c == Color.BLACK.getRGB() ? 0 : c;
            }
        }
    }
}

