/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.ui.vehicle;

import java.util.ArrayList;
import java.util.List;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.fvtm.sys.uni.FvtmWorld;
import net.fexcraft.mod.fvtm.sys.uni.SeatInstance;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIField;
import net.fexcraft.mod.uni.ui.UITab;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class VehicleAttributes
extends UserInterface {
    private ArrayList<Attribute<?>> attributes = new ArrayList();
    private static final int ROWS = 4;
    private static final int COLS = 12;
    private VehicleInstance veh;
    private SeatInstance seat;
    private int lastveh;
    private int page;
    private int sel;

    public VehicleAttributes(JsonMap map, ContainerInterface con) throws Exception {
        super(map, con);
        this.veh = ((FvtmWorld)con.player.entity.getWorld()).getVehicle(con.pos.x);
        this.seat = this.veh.getSeatOf(con.player.entity.direct());
        this.veh.data.getAttributes().values().forEach(attr -> {
            if (this.seat == null) {
                if (attr.external) {
                    this.attributes.add((Attribute<?>)attr);
                }
            } else if (this.seat.seat.driver || attr.access.contains(this.seat.seat.name)) {
                this.attributes.add((Attribute<?>)attr);
            }
        });
        if (this.lastveh != con.pos.x) {
            this.page = 0;
        }
        this.lastveh = con.pos.x;
    }

    public void init() {
        ((UIField)this.fields.get("editor")).text(this.attributes.size() > 0 ? this.attributes.get(0).asString() : "");
    }

    public void predraw(float ticks, int mx, int my) {
        int max = this.attributes.size() / 48 + 1;
        ((UIText)this.texts.get("page")).transval("ui.fvtm.vehicle_attributes.page", new Object[]{this.page + 1 + "/" + max, this.sel + 1 + "/" + this.attributes.size()});
        if (this.sel >= this.attributes.size()) {
            for (int i = 0; i < 4; ++i) {
                ((UIText)this.texts.get("info_" + i)).value("");
            }
            return;
        }
        Attribute<?> attr = this.attributes.get(this.sel);
        ((UIText)this.texts.get("info_0")).transval("ui.fvtm.vehicle_attributes.info_id", new Object[]{attr.id});
        ((UIText)this.texts.get("info_1")).transval("ui.fvtm.vehicle_attributes.info_status", new Object[]{attr.editable, attr.external});
        ((UIText)this.texts.get("info_2")).transval("ui.fvtm.vehicle_attributes.info_origin", new Object[]{attr.valuetype.name, attr.origin == null ? "vehicle" : attr.origin});
        ((UIText)this.texts.get("info_3")).transval("ui.fvtm.vehicle_attributes.info_bound", new Object[]{attr.value, attr.initial, attr.min == -2.1474836E9f ? "-" : Float.valueOf(attr.min), attr.max == 2.1474836E9f ? "-" : Float.valueOf(attr.max)});
    }

    public void postdraw(float ticks, int mx, int my) {
        this.drawer.bind(((UITab)this.tabs.get((Object)"main")).texture);
        this.drawer.draw((float)(this.gLeft + 7 + this.sel % 12 * 18), (float)(this.gTop + 7 + this.sel / 12 * 18), 0, 238, 18, 18);
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 12; ++col) {
                int idx = col + row * 12;
                if (idx >= this.attributes.size()) continue;
                this.drawer.bind(this.attributes.get(idx).getCurrentIcon());
                this.drawer.drawFull((float)(this.gLeft + 8 + col * 18), (float)(this.gTop + 8 + row * 18), 16, 16);
            }
        }
    }

    public boolean onAction(UIButton button, String id, int x, int y, int b) {
        switch (id) {
            case "prev": {
                this.updatePage(-1);
                return true;
            }
            case "next": {
                this.updatePage(1);
                return true;
            }
            case "list": {
                this.attributes.clear();
                this.veh.data.getAttributes().values().forEach(attr -> this.attributes.add((Attribute<?>)attr));
                ((UIField)this.fields.get("editor")).text(this.attributes.size() > 0 ? this.attributes.get(0).asString() : "");
                this.sel = 0;
                return true;
            }
            case "seat": {
                this.attributes.clear();
                this.veh.data.getAttributes().values().forEach(attr -> {
                    if (this.seat != null && attr.access.contains(this.seat.seat.name)) {
                        this.attributes.add((Attribute<?>)attr);
                    }
                });
                ((UIField)this.fields.get("editor")).text(this.attributes.size() > 0 ? this.attributes.get(0).asString() : "");
                this.sel = 0;
                return true;
            }
            case "ext": {
                this.attributes.clear();
                this.veh.data.getAttributes().values().forEach(attr -> {
                    if (attr.external) {
                        this.attributes.add((Attribute<?>)attr);
                    }
                });
                ((UIField)this.fields.get("editor")).text(this.attributes.size() > 0 ? this.attributes.get(0).asString() : "");
                this.sel = 0;
                return true;
            }
            case "toggle": {
                Attribute<?> attr2 = this.attributes.get(this.sel);
                if (!attr2.editable && !attr2.hasPerm()) {
                    return true;
                }
                if (!attr2.valuetype.isTristate()) {
                    return true;
                }
                TagCW com = TagCW.create();
                com.set("cargo", "toggle");
                com.set("attr", attr2.id);
                com.set("bool", !attr2.asBoolean());
                ContainerInterface.SEND_TO_SERVER.accept(com);
                return true;
            }
            case "reset": {
                Attribute<?> attr3 = this.attributes.get(this.sel);
                if (!attr3.editable && !attr3.hasPerm()) {
                    return true;
                }
                if (!attr3.valuetype.isTristate()) {
                    return true;
                }
                TagCW com = TagCW.create();
                com.set("cargo", "toggle");
                com.set("attr", attr3.id);
                com.set("reset", true);
                if (attr3.valuetype.isBoolean()) {
                    com.set("bool", ((Boolean)attr3.initial).booleanValue());
                }
                ContainerInterface.SEND_TO_SERVER.accept(com);
                return true;
            }
            case "decr": {
                Attribute<?> attr4 = this.attributes.get(this.sel);
                if (!attr4.editable && !attr4.hasPerm()) {
                    return true;
                }
                if (!attr4.valuetype.isNumber()) {
                    return true;
                }
                TagCW com = TagCW.create();
                com.set("cargo", "toggle");
                com.set("attr", attr4.id);
                if (attr4.valuetype.isFloat()) {
                    com.set("value", attr4.asFloat() - 1.0f);
                } else {
                    com.set("value", attr4.asInteger() - 1);
                }
                ContainerInterface.SEND_TO_SERVER.accept(com);
                return true;
            }
            case "incr": {
                Attribute<?> attr5 = this.attributes.get(this.sel);
                if (!attr5.editable && !attr5.hasPerm()) {
                    return true;
                }
                if (!attr5.valuetype.isNumber()) {
                    return true;
                }
                TagCW com = TagCW.create();
                com.set("cargo", "toggle");
                com.set("attr", attr5.id);
                if (attr5.valuetype.isFloat()) {
                    com.set("value", attr5.asFloat() + 1.0f);
                } else {
                    com.set("value", attr5.asInteger() + 1);
                }
                ContainerInterface.SEND_TO_SERVER.accept(com);
                return true;
            }
            case "apply": {
                Attribute<?> attr6 = this.attributes.get(this.sel);
                if (!attr6.editable && !attr6.hasPerm()) {
                    return true;
                }
                UIField field = (UIField)this.fields.get("editor");
                TagCW com = TagCW.create();
                com.set("cargo", "toggle");
                com.set("attr", attr6.id);
                if (attr6.valuetype.isTristate()) {
                    if (field.text().equals("null")) {
                        com.set("reset", true);
                        com.set("bool", ((Boolean)attr6.initial).booleanValue());
                    } else {
                        com.set("bool", Boolean.parseBoolean(field.text()));
                    }
                } else if (attr6.valuetype.isFloat()) {
                    com.set("value", field._float());
                } else if (attr6.valuetype.isInteger()) {
                    com.set("value", field.integer());
                } else {
                    com.set("value", field.text());
                }
                ContainerInterface.SEND_TO_SERVER.accept(com);
                return true;
            }
            case "attrs": {
                int col = (x - this.gLeft - 7) / 18;
                int row = (y - this.gTop - 7) / 18;
                int idx = col + row * 12;
                if (idx < 0 || idx >= this.attributes.size()) {
                    return true;
                }
                if (b > 0) {
                    int os = this.sel;
                    this.sel = idx;
                    this.onAction((UIButton)this.buttons.get("toggle"), "toggle", x, y, b);
                    this.sel = os;
                } else {
                    this.sel = idx;
                    ((UIField)this.fields.get("editor")).text(this.attributes.get(idx).asString());
                }
                return true;
            }
        }
        return false;
    }

    private void updatePage(int by) {
        if (by != 0) {
            this.page += by;
            if (this.page < 0) {
                this.page = 0;
            }
        }
    }

    public boolean onScroll(UIButton button, String id, int mx, int my, int am) {
        this.updatePage(am);
        return true;
    }

    public void getTooltip(int mx, int my, List<String> list) {
        if (((UIButton)this.buttons.get("decr")).hovered() || ((UIButton)this.buttons.get("incr")).hovered()) {
            list.add((String)ContainerInterface.TRANSLATOR.apply("ui.fvtm.vehicle_attributes.number_info"));
        }
        if (((UIButton)this.buttons.get("toggle")).hovered()) {
            list.add((String)ContainerInterface.TRANSLATOR.apply("ui.fvtm.vehicle_attributes.toggle_info"));
        }
        for (int i = 0; i < 4; ++i) {
            UIText text = (UIText)this.texts.get("info_" + i);
            if (!text.hovered()) continue;
            list.add(text.value());
        }
        int idx = (mx - this.gLeft - 7) / 18 + (my - this.gTop - 7) / 18 * 12;
        if (idx < 0 || idx >= this.attributes.size()) {
            return;
        }
        Attribute<?> attr = this.attributes.get(idx);
        list.add((String)ContainerInterface.TRANSFORMAT.apply("ui.fvtm.vehicle_attributes.info_id", new Object[]{attr.id}));
        list.add((String)ContainerInterface.TRANSFORMAT.apply("ui.fvtm.vehicle_attributes.info_value", new Object[]{attr.asString()}));
        list.add((String)ContainerInterface.TRANSFORMAT.apply("ui.fvtm.vehicle_attributes.info_type", new Object[]{attr.valuetype.name}));
        if (attr.hasPerm()) {
            list.add((String)ContainerInterface.TRANSFORMAT.apply("ui.fvtm.vehicle_attributes.info_perm", new Object[]{attr.perm}));
        }
    }
}

