/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Map;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.lib.frl.GLO;
import net.fexcraft.lib.frl.Renderer;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.FvtmPlayer;
import net.fexcraft.mod.fvtm.data.Material;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.fvtm.data.block.AABB;
import net.fexcraft.mod.fvtm.data.block.BlockType;
import net.fexcraft.mod.fvtm.data.root.Lockable;
import net.fexcraft.mod.fvtm.data.root.LoopedSound;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.entity.RootVehicle;
import net.fexcraft.mod.fvtm.impl.AABBI;
import net.fexcraft.mod.fvtm.item.BlockItem20;
import net.fexcraft.mod.fvtm.item.ConsumableItem;
import net.fexcraft.mod.fvtm.item.MaterialItem;
import net.fexcraft.mod.fvtm.item.PartItem;
import net.fexcraft.mod.fvtm.item.RailGaugeItem;
import net.fexcraft.mod.fvtm.item.SignItem;
import net.fexcraft.mod.fvtm.item.ToolboxItem;
import net.fexcraft.mod.fvtm.item.VehicleItem;
import net.fexcraft.mod.fvtm.item.WireDecoItem;
import net.fexcraft.mod.fvtm.item.WireItem;
import net.fexcraft.mod.fvtm.model.GLObject;
import net.fexcraft.mod.fvtm.model.program.DefaultPrograms;
import net.fexcraft.mod.fvtm.render.Renderer20;
import net.fexcraft.mod.fvtm.sys.rail.LongDisRailUtil;
import net.fexcraft.mod.fvtm.sys.road.RoadPlacingCache;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.ui.RoadSlot;
import net.fexcraft.mod.fvtm.ui.UIKeys;
import net.fexcraft.mod.fvtm.ui.VehicleCatalogImpl;
import net.fexcraft.mod.fvtm.util.BlockTypeImpl;
import net.fexcraft.mod.fvtm.util.DebugUtils;
import net.fexcraft.mod.fvtm.util.LoopSound;
import net.fexcraft.mod.fvtm.util.Resources20;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.ui.UISlot;
import net.fexcraft.mod.uni.world.EntityW;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;

public class FVTM20 {
    public static void init0() {
        StackWrapper.ITEM_TYPES.put(ContentType.ITYPE, item -> item instanceof ContentItem);
        StackWrapper.ITEM_TYPES.put(ContentType.PART.item_type, item -> item instanceof PartItem);
        StackWrapper.ITEM_TYPES.put(ContentType.MATERIAL.item_type, item -> item instanceof MaterialItem);
        StackWrapper.ITEM_TYPES.put(ContentType.VEHICLE.item_type, item -> item instanceof VehicleItem);
        StackWrapper.ITEM_TYPES.put(ContentType.BLOCK.item_type, item -> item instanceof BlockItem20);
        StackWrapper.ITEM_TYPES.put(ContentType.RAILGAUGE.item_type, item -> item instanceof RailGaugeItem);
        StackWrapper.ITEM_TYPES.put(ContentType.TOOLBOX.item_type, item -> item instanceof ToolboxItem);
        StackWrapper.ITEM_TYPES.put(ContentType.WIRE.item_type, item -> item instanceof WireItem);
        StackWrapper.ITEM_TYPES.put(ContentType.WIREDECO.item_type, item -> item instanceof WireDecoItem);
        StackWrapper.ITEM_TYPES.put(ContentType.SIGN.item_type, item -> item instanceof SignItem);
        StackWrapper.CONTENT_TYPES.put(ContentType.PART.item_type, stack -> ((PartItem)stack.getItem().direct()).getData((StackWrapper)stack));
        StackWrapper.CONTENT_TYPES.put(ContentType.VEHICLE.item_type, stack -> ((VehicleItem)stack.getItem().direct()).getData((StackWrapper)stack));
        StackWrapper.CONTENT_TYPES.put(ContentType.MATERIAL.item_type, stack -> stack.getItem().direct() instanceof MaterialItem ? ((MaterialItem)stack.getItem().direct()).getContent() : null);
        StackWrapper.CONTENT_TYPES.put(ContentType.CONSUMABLE.item_type, stack -> ((ConsumableItem)stack.getItem().direct()).getContent());
        StackWrapper.CONTENT_TYPES.put(ContentType.BLOCK.item_type, stack -> ((BlockItem20)stack.getItem().direct()).getData((StackWrapper)stack));
        StackWrapper.CONTENT_TYPES.put(ContentType.RAILGAUGE.item_type, stack -> ((RailGaugeItem)stack.getItem().direct()).getContent());
        StackWrapper.CONTENT_TYPES.put(ContentType.WIRE.item_type, stack -> ((WireItem)stack.getItem().direct()).getContent());
        StackWrapper.CONTENT_TYPES.put(ContentType.WIREDECO.item_type, stack -> ((WireDecoItem)stack.getItem().direct()).getContent());
        StackWrapper.CONTENT_TYPES.put(ContentType.SIGN.item_type, stack -> ((SignItem)stack.getItem().direct()).getContent());
        StackWrapper.CONTENT_TYPES.put(ContentType.TOOLBOX.item_type, stack -> ((ToolboxItem)((Object)((Object)stack.getItem().direct()))).var);
        AABB.SUPPLIER = () -> new AABBI();
        AABB.WRAPPER = obj -> new AABBI((net.minecraft.world.phys.AABB)obj);
        BlockType.BLOCK_IMPL = BlockTypeImpl::get;
        if (EnvInfo.CLIENT) {
            FvtmRegistry.CONFIG.addListener(DefaultPrograms::setupSignalTimer);
            Renderer.RENDERER = new Renderer20();
            GLO.SUPPLIER = () -> new GLObject();
        }
        FvtmResources.INSTANCE = new Resources20();
        LoopedSound.ACTIVATE = sound -> {
            sound.localsound = new LoopSound((LoopedSound)sound);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound.localsound);
        };
        FvtmRegistry.CONFIG.addListener(() -> {});
        UIKeys.VEHICLE_CATALOG_IMPL = VehicleCatalogImpl.class;
        UIKeys.register();
        UISlot.GETTERS.put("fvtm:roadfill", args -> new RoadSlot((Object[])args));
        FvtmResources.INSTANCE.init();
    }

    public static void init1() {
        FvtmResources.INSTANCE.registerFvtmBlocks();
        FvtmResources.INSTANCE.registerFvtmItems();
        FvtmResources.INSTANCE.registerAttributes();
        FvtmResources.INSTANCE.registerFunctions();
        FvtmResources.INSTANCE.registerHandlers();
        FvtmResources.INSTANCE.searchContent();
        FvtmResources.INSTANCE.createContentBlocks();
        FvtmResources.INSTANCE.createContentItems();
        if (EnvInfo.CLIENT) {
            FvtmResources.initModelSystem();
            if (DefaultPrograms.SIGNAL_TIMER[0] == null) {
                DefaultPrograms.setupSignalTimer();
            }
        }
    }

    public static LiteralArgumentBuilder<CommandSourceStack> genCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fvtm").then(Commands.m_82127_((String)"undo").then(Commands.m_82127_((String)"road").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            EntityW pass = UniEntity.getEntity((Object)player);
            JsonMap map = RoadPlacingCache.getLastEntry(player.m_36316_().getId(), pass.getWorld().type().side_key());
            if (map == null || map.empty()) {
                pass.send("No last road data in item.");
                return 0;
            }
            String dim = map.getString("LastRoadDim", "minecraft:overworld-s");
            if (!dim.equals(pass.getWorld().type().side_key())) {
                pass.send("Last road was placed in &6DIM" + map.getString("LastRoadDim", "unknown"));
                pass.send("You are currently in &6DIM" + pass.getWorld().type().side_key());
                return 0;
            }
            map.rem("LastRoadDim");
            pass.send("&oUndo-ing last placed road...");
            for (String str : ((Map)map.value).keySet()) {
                JsonArray array = map.getArray(str);
                V3I vec = V3I.fromString((String)str);
                BlockPos pos = new BlockPos(vec.x, vec.y, vec.z);
                Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(array.get(0).string_value()));
                player.m_9236_().m_7731_(pos, block.m_49966_(), 3);
            }
            RoadPlacingCache.remLastEntry(player.m_36316_().getId(), player.m_9236_().m_46472_().m_135782_().toString());
            pass.send("&7Last road undone.");
            return 0;
        })))).then(Commands.m_82127_((String)"debug").executes(ctx -> {
            DebugUtils.ACTIVE = !DebugUtils.ACTIVE;
            return 0;
        }))).then(Commands.m_82127_((String)"catalog").executes(ctx -> {
            UniEntity.getEntity((Object)((CommandSourceStack)ctx.getSource()).m_230896_()).openUI(UIKeys.VEHICLE_CATALOG, V3I.NULL);
            return 0;
        }))).then(Commands.m_82127_((String)"reload").executes(ctx -> {
            if (EnvInfo.DEV) {
                ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237113_((String)"Reloading Config..."));
                FvtmRegistry.CONFIG.reload();
            } else {
                ((CommandSourceStack)ctx.getSource()).m_243053_((Component)Component.m_237113_((String)"Runtime reloading only available in dev-mode."));
            }
            return 0;
        }))).then(Commands.m_82127_((String)"get-key").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_230896_();
            EntityW pass = UniEntity.getEntity((Object)player);
            if (player.m_20202_() instanceof RootVehicle) {
                RootVehicle ent = (RootVehicle)player.m_20202_();
                VehicleData data = ent.vehicle.data;
                if (data.getLock().isLocked()) {
                    pass.send("cmd.fvtm.get-key.is-locked");
                } else if (!((Passenger)UniEntity.getApp((Object)player, Passenger.class)).getSeatOn().seat.driver) {
                    pass.send("cmd.fvtm.get-key.not-driver");
                } else if (data.getAttributeInteger("generated_keys", 0) >= ((Vehicle)data.getType()).getMaxKeys()) {
                    pass.send("cmd.fvtm.get-key.max-keys");
                } else {
                    Material km = FvtmRegistry.MATERIALS.get(((Vehicle)data.getType()).getKeyType());
                    if (km == null) {
                        km = FvtmRegistry.MATERIALS.get(Lockable.DEFAULT_KEY);
                    }
                    if (km == null) {
                        pass.send("cmd.fvtm.get-key.not-found");
                        pass.send("cmd.fvtm.get-key.check-gep");
                    } else {
                        StackWrapper keystack = km.getNewStack();
                        keystack.updateTag(com -> com.set("LockCode", data.getLock().getCode()));
                        pass.addStack(keystack);
                        pass.send("cmd.fvtm.get-key.success");
                    }
                    Attribute attr = data.getAttributeCasted("generated_keys");
                    attr.set(attr.asInteger() + 1);
                }
            }
            return 0;
        }))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"long-rail").then(Commands.m_82127_((String)"select").executes(ctx -> {
            LongDisRailUtil.add((FvtmPlayer)UniEntity.get((Object)((CommandSourceStack)ctx.getSource()).m_230896_()).getApp(FvtmPlayer.class));
            return 0;
        }))).then(Commands.m_82127_((String)"status").executes(ctx -> {
            LongDisRailUtil.status((FvtmPlayer)UniEntity.get((Object)((CommandSourceStack)ctx.getSource()).m_230896_()).getApp(FvtmPlayer.class));
            return 0;
        }))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"segmentation", (ArgumentType)IntegerArgumentType.integer((int)4, (int)32)).executes(ctx -> {
            LongDisRailUtil.seg((FvtmPlayer)UniEntity.get((Object)((CommandSourceStack)ctx.getSource()).m_230896_()).getApp(FvtmPlayer.class), (Integer)ctx.getArgument("segmentation", Integer.class));
            return 0;
        })))).then(Commands.m_82127_((String)"clear").executes(ctx -> {
            LongDisRailUtil.clear((FvtmPlayer)UniEntity.get((Object)((CommandSourceStack)ctx.getSource()).m_230896_()).getApp(FvtmPlayer.class));
            return 0;
        }))).then(Commands.m_82127_((String)"start").executes(ctx -> {
            LongDisRailUtil.process((FvtmPlayer)UniEntity.get((Object)((CommandSourceStack)ctx.getSource()).m_230896_()).getApp(FvtmPlayer.class));
            return 0;
        })));
    }
}

