/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import net.fexcraft.mod.fvtm.FVTM20;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.block.ConstructorEntity;
import net.fexcraft.mod.fvtm.block.FuelFillerEntity;
import net.fexcraft.mod.fvtm.block.generated.BaseBlockEntity;
import net.fexcraft.mod.fvtm.block.generated.BlockBase;
import net.fexcraft.mod.fvtm.block.generated.JACK;
import net.fexcraft.mod.fvtm.block.generated.JACK_BE;
import net.fexcraft.mod.fvtm.data.addon.Addon;
import net.fexcraft.mod.fvtm.entity.DecorationEntity;
import net.fexcraft.mod.fvtm.entity.RailMarker;
import net.fexcraft.mod.fvtm.entity.RailVehicle;
import net.fexcraft.mod.fvtm.entity.RoadMarker;
import net.fexcraft.mod.fvtm.entity.RootVehicle;
import net.fexcraft.mod.fvtm.entity.WheelEntity;
import net.fexcraft.mod.fvtm.impl.Packets20F;
import net.fexcraft.mod.fvtm.impl.WorldWIE;
import net.fexcraft.mod.fvtm.model.RenderCache;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.util.CTab;
import net.fexcraft.mod.fvtm.util.RenderCacheProvider;
import net.fexcraft.mod.fvtm.util.Resources20;
import net.fexcraft.mod.fvtm.util.TabInitializerF;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.impl.WrapperHolderImpl;
import net.fexcraft.mod.uni.world.WorldW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="fvtm")
public class FVTM4 {
    public static final String MODID = "fvtm";
    private static Logger LOGGER4 = LogUtils.getLogger();
    public static final HashMap<String, DeferredRegister<Item>> ITEM_REGISTRY = new HashMap();
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"fvtm");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registries.f_256939_, (String)"fvtm");
    public static final RegistryObject<EntityType<DecorationEntity>> DECORATION_ENTITY = ENTITIES.register("decoration", () -> EntityType.Builder.m_20704_(DecorationEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).setUpdateInterval(10).setTrackingRange(256).m_20712_("decoration"));
    public static final RegistryObject<EntityType<RoadMarker>> ROAD_MARKER_ENTITY = ENTITIES.register("road_marker", () -> EntityType.Builder.m_20704_(RoadMarker::new, (MobCategory)MobCategory.MISC).m_20699_(0.24f, 0.48f).setUpdateInterval(10).setTrackingRange(256).m_20712_("road_marker"));
    public static final RegistryObject<EntityType<RailMarker>> RAIL_MARKER_ENTITY = ENTITIES.register("rail_marker", () -> EntityType.Builder.m_20704_(RailMarker::new, (MobCategory)MobCategory.MISC).m_20699_(0.24f, 1.0f).setUpdateInterval(10).setTrackingRange(256).m_20712_("rail_marker"));
    public static final RegistryObject<EntityType<WheelEntity>> WHEEL_ENTITY = ENTITIES.register("wheel", () -> EntityType.Builder.m_20704_((type, level) -> new WheelEntity(type, level), (MobCategory)MobCategory.CREATURE).m_20699_(0.25f, 0.25f).setUpdateInterval(1).setTrackingRange(256).setShouldReceiveVelocityUpdates(false).m_20712_("wheel"));
    public static final RegistryObject<EntityType<RootVehicle>> VEHICLE_ENTITY = ENTITIES.register("vehicle", () -> EntityType.Builder.m_20704_(RootVehicle::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).setUpdateInterval(1).setTrackingRange(256).setShouldReceiveVelocityUpdates(false).m_20712_("vehicle"));
    public static final RegistryObject<EntityType<RailVehicle>> RAILVEH_ENTITY = ENTITIES.register("railveh", () -> EntityType.Builder.m_20704_(RailVehicle::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).setUpdateInterval(1).setTrackingRange(256).m_20712_("railveh"));
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("fvtm", "channel")).clientAcceptedVersions(pro -> true).serverAcceptedVersions(pro -> true).networkProtocolVersion(() -> "fvtm4").simpleChannel();
    public static final HashMap<String, DeferredRegister<Block>> BLOCK_REGISTRY = new HashMap();
    public static final HashMap<String, DeferredRegister<SoundEvent>> SOUND_REGISTY = new HashMap();
    public static final DeferredRegister<BlockEntityType<?>> BLOCKENTS = DeferredRegister.create((ResourceKey)Registries.f_256922_, (String)"fvtm");
    public static final RegistryObject<BlockEntityType<ConstructorEntity>> CONST_ENTITY = BLOCKENTS.register("constructor", () -> BlockEntityType.Builder.m_155273_(ConstructorEntity::new, (Block[])new Block[]{Resources20.CONST_BLOCK.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<FuelFillerEntity>> FUELFILLER_ENT = BLOCKENTS.register("fuel_filler", () -> BlockEntityType.Builder.m_155273_(FuelFillerEntity::new, (Block[])new Block[]{Resources20.FUELFILLER_BLOCK.get()}).m_58966_(null));
    public static final RegistryObject<BlockEntityType<BaseBlockEntity>> BLOCK_ENTITY = BLOCKENTS.register("blockbase", () -> BlockEntityType.Builder.m_155273_(BaseBlockEntity::new, (Block[])FVTM4.getBlockArray()).m_58966_(null));
    public static final RegistryObject<BlockEntityType<JACK_BE>> JACK_ENTITY = BLOCKENTS.register("jack_stand", () -> BlockEntityType.Builder.m_155273_(JACK_BE::new, (Block[])FVTM4.getJackArray()).m_58966_(null));

    private static Block[] getBlockArray() {
        ArrayList list = new ArrayList();
        BLOCK_REGISTRY.values().forEach(reg -> reg.getEntries().forEach(obj -> {
            if (obj.get() instanceof BlockBase) {
                list.add((Block)obj.get());
            }
        }));
        return list.toArray(new Block[0]);
    }

    private static Block[] getJackArray() {
        ArrayList list = new ArrayList();
        BLOCK_REGISTRY.values().forEach(reg -> reg.getEntries().forEach(obj -> {
            if (obj.get() instanceof JACK) {
                list.add((Block)obj.get());
            }
        }));
        return list.toArray(new Block[0]);
    }

    public FVTM4() {
        FvtmRegistry.init("1.20", FMLPaths.CONFIGDIR.get().toFile());
        FvtmLogger.LOGGER = new FvtmLogger(){

            @Override
            protected void log0(Object obj) {
                LOGGER4.info((String)(obj == null ? "null " + new Exception().getStackTrace()[2].toString() : obj.toString()));
            }
        };
        EnvInfo.CLIENT = FMLLoader.getDist().isClient();
        if (EnvInfo.CLIENT) {
            CTab.IMPL[0] = TabInitializerF.class;
        }
        FVTM20.init0();
        FvtmRegistry.ADDONS.forEach(addon -> ITEM_REGISTRY.put(addon.getID().id(), (DeferredRegister<Item>)DeferredRegister.create((ResourceKey)Registries.f_256913_, (String)addon.getID().id())));
        FvtmRegistry.ADDONS.forEach(addon -> BLOCK_REGISTRY.put(addon.getID().id(), (DeferredRegister<Block>)DeferredRegister.create((ResourceKey)Registries.f_256747_, (String)addon.getID().id())));
        FVTM20.init1();
        this.regSounds();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::commonSetup);
        bus.register((Object)new PackAdder());
        ITEM_REGISTRY.values().forEach(reg -> reg.register(bus));
        CREATIVE_MODE_TABS.register(bus);
        ENTITIES.register(bus);
        BLOCK_REGISTRY.values().forEach(reg -> reg.register(bus));
        BLOCKENTS.register(bus);
        SOUND_REGISTY.values().forEach(reg -> reg.register(bus));
    }

    private void regSounds() {
        FvtmRegistry.VEHICLES.forEach(vehicle -> vehicle.getSounds().values().forEach(sound -> {
            if (sound.soundid.space().equals("minecraft")) {
                return;
            }
            if (!SOUND_REGISTY.containsKey(sound.soundid.space())) {
                SOUND_REGISTY.put(sound.soundid.space(), (DeferredRegister<SoundEvent>)DeferredRegister.create((ResourceKey)Registries.f_256840_, (String)sound.soundid.space()));
            }
            SOUND_REGISTY.get(sound.soundid.space()).register(sound.soundid.id(), () -> {
                SoundEvent ev = SoundEvent.m_262824_((ResourceLocation)((ResourceLocation)sound.soundid.local()));
                sound.event = ev;
                return ev;
            });
        }));
        FvtmRegistry.PARTS.forEach(part -> part.getSounds().values().forEach(sound -> {
            if (sound.soundid.space().equals("minecraft")) {
                return;
            }
            if (!SOUND_REGISTY.containsKey(sound.soundid.space())) {
                SOUND_REGISTY.put(sound.soundid.space(), (DeferredRegister<SoundEvent>)DeferredRegister.create((ResourceKey)Registries.f_256840_, (String)sound.soundid.space()));
            }
            SOUND_REGISTY.get(sound.soundid.space()).register(sound.soundid.id(), () -> {
                SoundEvent ev = SoundEvent.m_262824_((ResourceLocation)((ResourceLocation)sound.soundid.local()));
                sound.event = ev;
                return ev;
            });
        }));
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        new Packets20F().init();
        WrapperHolderImpl.LEVEL_PROVIDER = lvl -> new WorldWIE((Level)lvl);
        FvtmRegistry.VEHICLES.forEach(vehicle -> vehicle.getSounds().values().forEach(sound -> {
            if (sound.soundid.space().equals("minecraft")) {
                sound.event = BuiltInRegistries.f_256894_.m_7745_((ResourceLocation)sound.soundid.local());
            }
        }));
        FvtmRegistry.PARTS.forEach(part -> part.getSounds().values().forEach(sound -> {
            if (sound.soundid.space().equals("minecraft")) {
                sound.event = BuiltInRegistries.f_256894_.m_7745_((ResourceLocation)sound.soundid.local());
            }
        }));
        FvtmResources.INSTANCE.registerRecipes();
    }

    public static RenderCache getRenderCache(Entity entity) {
        return (RenderCache)entity.getCapability(RenderCacheProvider.CAPABILITY).resolve().get();
    }

    public static class PackAdder {
        @SubscribeEvent
        public void addPacks(AddPackFindersEvent event) {
            for (Addon addon : FvtmRegistry.ADDONS) {
                if (!addon.getLocation().isConfigPack() || addon.getFile() == null) continue;
                Pack pack = Pack.m_245512_((String)("fvtm/" + addon.getID().id()), (Component)Component.m_237113_((String)addon.getName()), (boolean)true, path -> {
                    if (addon.getFile().isDirectory()) {
                        return new PathPackResources(path, addon.getFile().toPath(), true);
                    }
                    return new FilePackResources(addon.getName(), addon.getFile(), true);
                }, (Pack.Info)new Pack.Info((Component)Component.m_237113_((String)"FVTM Auto-loaded Pack"), 15, 15, FeatureFlagSet.m_246902_(), false), (PackType)event.getPackType(), (Pack.Position)Pack.Position.BOTTOM, (boolean)false, (PackSource)PackSource.f_10527_);
                event.addRepositorySource(cons -> {
                    if (pack != null) {
                        cons.accept(pack);
                    }
                });
            }
        }

        @SubscribeEvent
        public void onEntAttrEvent(EntityAttributeCreationEvent event) {
            event.put((EntityType)WHEEL_ENTITY.get(), Mob.m_21183_().m_22268_(Attributes.f_22276_, 2.147483647E9).m_22268_(Attributes.f_22278_, 20.0).m_22265_());
        }
    }

    @Mod.EventBusSubscriber(modid="fvtm", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Events {
        @SubscribeEvent
        public static void onAttachEntityCaps(AttachCapabilitiesEvent<Entity> event) {
            if (!EnvInfo.CLIENT) {
                return;
            }
            if (event.getObject() instanceof DecorationEntity || event.getObject() instanceof RootVehicle) {
                event.addCapability(new ResourceLocation("fvtm:rendercache"), (ICapabilityProvider)new RenderCacheProvider((Entity)event.getObject()));
            }
        }

        @SubscribeEvent
        public static void onAttachWorldCaps(AttachCapabilitiesEvent<Level> event) {
            WorldW lvl = WrapperHolder.getWorld((Object)event.getObject());
            SystemManager.initWorldSystems(lvl, lvl.type());
        }

        @SubscribeEvent
        public static void onCmdReg(RegisterCommandsEvent event) {
            event.getDispatcher().register(FVTM20.genCommand());
        }
    }
}

