/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.attribute;

public class AttrValueType {
    public static final AttrValueType STRING = new Builder("string").setString().build();
    public static final AttrValueType BOOLEAN = new Builder("boolean").setBoolean().build();
    public static final AttrValueType TRISTATE = new Builder("tri-state").setTristate().build();
    public static final AttrValueType INTEGER = new Builder("integer").setInteger().build();
    public static final AttrValueType FLOAT = new Builder("float").setFloat().build();
    public static final AttrValueType LONG = new Builder("long").setLong().build();
    public static final AttrValueType VECTOR = new Builder("vector").setVector().build();
    public static final AttrValueType OBJECT = new Builder("object").setObject().build();
    public static final AttrValueType STRING_ARRAY = new Builder("string_array").setString().setArray().build();
    public static final AttrValueType BOOLEAN_ARRAY = new Builder("boolean_array").setBoolean().setArray().build();
    public static final AttrValueType INTEGER_ARRAY = new Builder("integer_array").setInteger().setArray().build();
    public static final AttrValueType FLOAT_ARRAY = new Builder("float_array").setFloat().setArray().build();
    public static final AttrValueType OBJECT_ARRAY = new Builder("object_array").setObject().setArray().build();
    private boolean string;
    private boolean bool;
    private boolean tristate;
    private boolean integer;
    private boolean float_;
    private boolean long_;
    private boolean vector;
    private boolean array;
    private boolean object;
    public final String name;

    private AttrValueType(String id) {
        this.name = id;
    }

    public boolean isString() {
        return this.string;
    }

    public boolean isBoolean() {
        return this.bool;
    }

    public boolean isTristate() {
        return this.tristate || this.bool;
    }

    public boolean isNumber() {
        return this.integer || this.float_ || this.long_ || this.bool;
    }

    public boolean isInteger() {
        return this.integer;
    }

    public boolean isFloat() {
        return this.float_;
    }

    public boolean isLong() {
        return this.long_;
    }

    public boolean isVector() {
        return this.vector;
    }

    public boolean isArray() {
        return this.array;
    }

    public boolean isObject() {
        return this.object;
    }

    public static class Builder {
        private AttrValueType valtype;

        public Builder(String name) {
            this.valtype = new AttrValueType(name);
        }

        public Builder setString() {
            this.valtype.string = true;
            return this;
        }

        public Builder setBoolean() {
            this.valtype.bool = true;
            return this;
        }

        public Builder setTristate() {
            this.valtype.tristate = true;
            return this;
        }

        public Builder setInteger() {
            this.valtype.integer = true;
            return this;
        }

        public Builder setFloat() {
            this.valtype.float_ = true;
            return this;
        }

        public Builder setLong() {
            this.valtype.long_ = true;
            return this;
        }

        public Builder setVector() {
            this.valtype.vector = true;
            return this;
        }

        public Builder setArray() {
            this.valtype.array = true;
            return this;
        }

        public Builder setObject() {
            this.valtype.object = true;
            return this;
        }

        public AttrValueType build() {
            return this.valtype;
        }
    }
}

