/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.block;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.mod.fvtm.data.ContentData;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.data.block.BlockFunction;
import net.fexcraft.mod.fvtm.data.block.BlockType;
import net.fexcraft.mod.fvtm.data.block.RelayData;
import net.fexcraft.mod.fvtm.data.root.Colorable;
import net.fexcraft.mod.fvtm.data.root.Textureable;
import net.fexcraft.mod.fvtm.function.block.BoolBlockFunction;
import net.fexcraft.mod.uni.tag.TagCW;

public class BlockData
extends ContentData<Block, BlockData>
implements Textureable.TextureUser,
Colorable {
    protected Textureable texture;
    protected Map<String, RGB> channels = new LinkedHashMap<String, RGB>();
    protected ArrayList<BlockFunction> functions = new ArrayList();
    protected BoolBlockFunction boolfunc = null;
    protected Object invfunc;

    public BlockData(Block block) {
        super(block);
        this.texture = new Textureable(block);
        for (Map.Entry<String, RGB> entry : block.getDefaultColorChannels().entrySet()) {
            this.channels.put(entry.getKey(), entry.getValue().copy());
        }
        for (BlockFunction func : ((Block)this.type).getFunctions()) {
            this.functions.add(func.copy((Block)this.type));
        }
        for (BlockFunction func : this.functions) {
            if (func instanceof BoolBlockFunction) {
                this.boolfunc = (BoolBlockFunction)func;
            }
            if (!func.getClass().getName().contains("InventoryBlockFunction")) continue;
            this.invfunc = func;
        }
    }

    @Override
    public TagCW write(TagCW compound) {
        if (compound == null) {
            compound = TagCW.create();
        }
        compound.set("Block", ((Block)this.type).getIDS());
        this.texture.save(compound);
        for (String str : this.channels.keySet()) {
            compound.set("RGB_" + str, this.channels.get((Object)str).packed);
        }
        TagCW com = TagCW.create();
        for (BlockFunction func : this.functions) {
            func.save(com);
        }
        if (!com.empty()) {
            compound.set("BlockFunction", com);
        }
        return compound;
    }

    @Override
    public BlockData read(TagCW compound) {
        if (compound == null) {
            compound = TagCW.create();
        }
        this.texture.load(compound);
        for (String str : this.channels.keySet()) {
            if (!compound.has("RGB_" + str)) continue;
            this.channels.get((Object)str).packed = compound.getInteger("RGB_" + str);
        }
        if (compound.has("BlockFunction")) {
            TagCW com = compound.getCompound("BlockFunction");
            for (BlockFunction func : this.functions) {
                func.load(com);
            }
        }
        return this;
    }

    @Override
    public BlockData parse(JsonMap obj) {
        return null;
    }

    @Override
    public JsonMap toJson() {
        return new JsonMap();
    }

    @Override
    public RGB getColorChannel(String channel) {
        return this.channels.get(channel);
    }

    @Override
    public void setColorChannel(String channel, RGB color) {
        RGB rgb = this.channels.get(channel);
        if (rgb != null) {
            rgb.packed = color.packed;
        }
    }

    @Override
    public Map<String, RGB> getColorChannels() {
        return this.channels;
    }

    @Override
    public Textureable getTexture() {
        return this.texture;
    }

    @Override
    public Textureable.TextureHolder getTexHolder() {
        return (Textureable.TextureHolder)((Object)this.type);
    }

    public boolean getFunctionBool(String key) {
        if (this.boolfunc == null) {
            return false;
        }
        return this.boolfunc.valOf(key);
    }

    public BoolBlockFunction getFunctionBool() {
        return this.boolfunc;
    }

    public Object getFunctionInventory() {
        return this.invfunc;
    }

    public ArrayList<BlockFunction> getFunctions() {
        return this.functions;
    }

    public RelayData getRelayData() {
        return ((Block)this.type).relaydata;
    }

    public BlockType getBlockType() {
        return ((Block)this.type).blocktype;
    }
}

