/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.entity;

import java.util.ArrayList;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fcl.util.EntityWI;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.data.InteractZone;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.entity.WheelEntity;
import net.fexcraft.mod.fvtm.function.part.EngineFunction;
import net.fexcraft.mod.fvtm.item.MaterialItem;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.sys.uni.SeatInstance;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.fvtm.util.CollisionUtil;
import net.fexcraft.mod.fvtm.util.OBB;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class RootVehicle
extends Entity
implements IEntityAdditionalSpawnData,
VehicleInstance.Holder {
    public VehicleInstance vehicle = new VehicleInstance((EntityW)new EntityWI((Entity)this), null);
    public float rotZ = 0.0f;
    public float protZ = 0.0f;
    public boolean should_sit = true;

    public RootVehicle(EntityType<?> type, Level level) {
        super(type, level);
    }

    public void initVD(VehicleData data) {
        this.vehicle.init(data, null);
        this.init(null);
    }

    protected void init(TagCW com) {
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag tag) {
        TagCW com = TagCW.wrap((Object)tag);
        this.m_146926_(com.getFloat("RotationPitch"));
        this.m_146922_(com.getFloat("RotationYaw"));
        this.protZ = this.rotZ = com.getFloat("RotationYaw");
        this.m_146867_();
        this.vehicle.init(null, com);
        this.init(com);
    }

    protected void m_7380_(CompoundTag tag) {
        this.vehicle.save(TagCW.wrap((Object)tag));
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        TagCW com = TagCW.create();
        if (this.vehicle.front != null) {
            com.set("TruckId", this.vehicle.front.entity.getId());
        }
        this.writeSpawnData(com);
        this.vehicle.save(com);
        buffer.m_130079_((CompoundTag)com.local());
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        try {
            TagCW com = TagCW.wrap((Object)buffer.m_130260_());
            this.vehicle.init(null, com);
            this.readSpawnData(com);
            this.init(com);
            if (com.has("TruckId")) {
                this.vehicle.attachTo(com.getInteger("TruckId"));
            }
            this.m_146922_(this.vehicle.point.getPivot().deg_yaw());
            this.m_146926_(this.vehicle.point.getPivot().deg_pitch());
            this.protZ = this.rotZ = this.vehicle.point.getPivot().deg_roll();
            this.m_146867_();
        }
        catch (Exception e) {
            e.printStackTrace();
            FvtmLogger.log((Object)("Failed to read additional spawn data for vehicle entity with ID " + this.m_19879_() + "!"));
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(TagCW com) {
    }

    public void readSpawnData(TagCW com) {
    }

    public void m_6074_() {
        if (this.vehicle != null) {
            this.vehicle.onRemove();
        }
        super.m_6074_();
    }

    public boolean m_6087_() {
        return true;
    }

    public boolean m_5829_() {
        return true;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.m_213877_() || hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        int res = this.vehicle.onInteract(UniEntity.getEntity((Object)player), UniStack.getStack((Object)player.m_21120_(hand)));
        return res == 1 ? InteractionResult.SUCCESS : (res == 0 ? InteractionResult.PASS : InteractionResult.FAIL);
    }

    private boolean isFuelContainer(Item item) {
        if (!(item instanceof MaterialItem)) {
            return false;
        }
        return ((MaterialItem)item).getContent().isFuelContainer();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_213877_()) {
            return;
        }
        if (this.vehicle.data == null) {
            FvtmLogger.log((Object)("Vehicle '" + this.m_19879_() + "' has no data, skipping update."));
            return;
        }
        if (this.f_19797_ >= Integer.MAX_VALUE) {
            this.f_19797_ = 0;
        }
        this.f_19859_ = this.vehicle.point.getPivot().deg_yaw();
        this.f_19860_ = this.vehicle.point.getPivot().deg_pitch();
        this.protZ = this.vehicle.point.getPivot().deg_roll();
        this.vehicle.onUpdate();
        this.checkCollision();
    }

    private void checkCollision() {
        if (Config.DISABLE_OBB || this.vehicle.obb.isEmpty()) {
            return;
        }
        ArrayList checked = new ArrayList();
        for (InteractZone zone : this.vehicle.data.getInteractZones().values()) {
            this.m_9236_().m_6249_((Entity)this, AABB.m_165882_((Vec3)this.m_20182_().m_82520_(zone.pos.x, zone.pos.y, zone.pos.z), (double)zone.range, (double)zone.range, (double)zone.range), ent -> ent instanceof LivingEntity && !(ent instanceof WheelEntity)).forEach(entity -> {
                if (entity.m_20202_() != null || checked.contains(entity)) {
                    return;
                }
                OBB bb = new OBB().set(net.fexcraft.mod.fvtm.data.block.AABB.wrap(entity.m_20191_()));
                for (OBB obb : this.vehicle.obb.values()) {
                    V3D res = CollisionUtil.check(bb, obb);
                    if (res == null) continue;
                    Vec3 vec = new Vec3(-res.x, res.y, -res.z);
                    entity.m_20256_(entity.m_20184_().m_82490_(0.9).m_82549_(vec));
                    checked.add(entity);
                }
            });
        }
    }

    public Player getDriver() {
        for (SeatInstance seat : this.vehicle.seats) {
            if (!seat.seat.driver || !seat.passengerIsPlayer()) continue;
            return (Player)seat.passenger().local();
        }
        return null;
    }

    public LivingEntity m_6688_() {
        return null;
    }

    public void m_19956_(Entity pass, Entity.MoveFunction movefunc) {
        SeatInstance seat = this.vehicle.getSeatOf(pass);
        if (seat != null) {
            this.updatePassenger(pass, seat);
        } else {
            if (this.m_9236_().f_46443_) {
                ((Passenger)UniEntity.getApp((Object)pass, Passenger.class)).reqPassUpdate();
            }
            pass.m_146884_(this.m_20182_());
        }
    }

    public void updatePassenger(Entity pass, SeatInstance seat) {
        if (seat.passenger_direct() != pass) {
            seat.passenger(UniEntity.getEntity((Object)pass));
        }
        V3D pos = seat.getCurrentGlobalPosition();
        pass.m_6034_(pos.x, pos.y - (pass instanceof Player ? 0.7 : 0.0), pos.z);
    }

    public void m_20348_(Entity pass) {
        super.m_20348_(pass);
        SeatInstance seat = this.vehicle.getSeatOf(pass);
        if (seat != null) {
            seat.passenger(UniEntity.getEntity((Object)pass));
        }
    }

    public void m_20351_(Entity pass) {
        for (SeatInstance seat : this.vehicle.seats) {
            if (!pass.equals(seat.passenger_direct())) continue;
            seat.passenger(null);
        }
        if (!this.m_9236_().f_46443_) {
            ((Passenger)UniEntity.getApp((Object)pass, Passenger.class)).set(-1, -1);
        }
        super.m_20351_(pass);
    }

    public void m_20153_() {
        super.m_20153_();
    }

    protected boolean m_7310_(Entity passenger) {
        return true;
    }

    public boolean shouldRiderSit() {
        return this.should_sit;
    }

    public boolean m_6469_(DamageSource source, float am) {
        if (this.m_9236_().f_46443_ || this.m_213877_()) {
            return true;
        }
        if (source.m_7640_() instanceof Player && this.getDriver() == null) {
            EngineFunction engine;
            Player player = (Player)source.m_7640_();
            if (this.vehicle.data.getLock().isLocked()) {
                player.m_213846_((Component)Component.m_237115_((String)"interact.fvtm.vehicle.remove_locked"));
                return false;
            }
            EngineFunction engineFunction = engine = this.vehicle.data.hasPart("engine") ? (EngineFunction)this.vehicle.data.getFunctionInPart("engine", "fvtm:engine") : null;
            if (engine != null) {
                engine.setState(false);
            }
            if (this.vehicle.type.isRailVehicle()) {
                this.vehicle.railent.remove();
            } else {
                VehicleInstance trailer = this.vehicle;
                while ((trailer = trailer.rear) != null) {
                    Entity rear = (Entity)trailer.entity.local();
                    rear.m_5552_((ItemStack)trailer.data.newItemStack().local(), 0.5f);
                    rear.m_6074_();
                }
            }
            this.m_5552_((ItemStack)this.vehicle.data.newItemStack().local(), 0.5f);
            this.m_6074_();
            return true;
        }
        return true;
    }

    public ItemStack getPickedResult(HitResult rtr) {
        return (ItemStack)this.vehicle.data.newItemStack().local();
    }

    public void m_6453_(double x, double y, double z, float yr, float xr, int s, boolean b) {
    }

    @Override
    public VehicleInstance getVehicleInstance() {
        return this.vehicle;
    }

    @Override
    public void onPacket(EntityW player, TagCW packet) {
    }
}

