/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.JunctionGridItem;
import net.fexcraft.mod.fvtm.entity.RootVehicle;
import net.fexcraft.mod.fvtm.render.FvtmRenderTypes;
import net.fexcraft.mod.fvtm.render.Renderer20;
import net.fexcraft.mod.fvtm.sys.rail.RailPlacingUtil;
import net.fexcraft.mod.fvtm.sys.road.RoadPlacingUtil;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.ui.VehicleOverlay;
import net.fexcraft.mod.fvtm.util.DebugUtils;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fvtm", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ForgeClientEvents {
    public static Vec3f BLUE = new Vec3f(0.0f, 0.0f, 1.0f);
    public static Vec3f CYAN = new Vec3f(0.0f, 1.0f, 1.0f);
    public static Vec3f ORG = new Vec3f(1.0f, 0.75f, 0.0f);
    private static RootVehicle vehicle;

    public static void onPlayerRender(RenderPlayerEvent.Pre event) {
        if (!((PlayerModel)event.getRenderer().m_7200_()).f_102810_.m_233562_("fvtm")) {
            ((PlayerModel)event.getRenderer().m_7200_()).f_102810_.f_104213_.put("fvtm", new ModelPart(new ArrayList(), new HashMap()){

                public void m_104301_(PoseStack pose, VertexConsumer cons, int i, int j) {
                    this.m_104306_(pose, cons, i, j, 1.0f, 1.0f, 1.0f, 1.0f);
                }

                public void m_104306_(PoseStack pose, VertexConsumer cons, int i, int j, float k, float l, float m, float n) {
                    Renderer20.set(pose, cons, i, j);
                    FvtmRenderTypes.setLines();
                    DebugUtils.SPHERE.render();
                }
            });
        }
    }

    @SubscribeEvent
    public static void renderRoad(RenderLevelStageEvent event) {
        V3D vec1;
        if (RoadPlacingUtil.CL_CURRENT == null || RoadPlacingUtil.CL_CURRENT.points.size() < 2) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS) {
            return;
        }
        Camera camera = event.getCamera();
        double cx = camera.m_90583_().f_82479_;
        double cy = camera.m_90583_().f_82480_;
        double cz = camera.m_90583_().f_82481_;
        PoseStack pose = event.getPoseStack();
        VertexConsumer cons = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
        Renderer20.set(pose, cons, 0);
        FvtmRenderTypes.setLines();
        pose.m_85836_();
        pose.m_85837_(-cx, -cy, -cz);
        RoadPlacingUtil.NewRoad nroad = RoadPlacingUtil.CL_CURRENT;
        if (nroad.coords == null) {
            nroad.genpreview();
        }
        Renderer20.setColor(BLUE);
        for (int j = 0; j < nroad.road.vecpath.length - 1; ++j) {
            V3D vec0 = nroad.road.vecpath[j];
            vec1 = nroad.road.vecpath[j + 1];
            DebugUtils.LINE_POLY.vertices[0].pos(vec0.x, vec0.y + 1.25, vec0.z);
            DebugUtils.LINE_POLY.vertices[1].pos(vec1.x, vec1.y + 1.25, vec1.z);
            DebugUtils.LINE.render();
        }
        int size = RoadPlacingUtil.CL_CURRENT.points.size();
        Renderer20.setColor(CYAN);
        for (int i = 1; i < size - 1; ++i) {
            double[] arr = nroad.road.getPosition(nroad.road.length / (double)(size - 1) * (double)i);
            vec1 = RoadPlacingUtil.CL_CURRENT.points.get((int)i).vec;
            DebugUtils.LINE_POLY.vertices[0].pos(arr[0], arr[1] + 1.25, arr[2]);
            DebugUtils.LINE_POLY.vertices[1].pos(vec1.x, vec1.y + 1.25, vec1.z);
            DebugUtils.LINE.render();
        }
        for (ArrayList<QV3D> coords : nroad.coords) {
            for (QV3D coord : coords) {
                pose.m_85836_();
                pose.m_252880_((float)(coord.pos.x + 1), (float)(coord.pos.y + 1) + (float)coord.y * 0.0625f, (float)(coord.pos.z + 1));
                DebugUtils.renderPane(0.5f, DebugUtils.COL_CYN);
                pose.m_85849_();
            }
        }
        pose.m_85849_();
    }

    @SubscribeEvent
    public static void renderGrid(RenderHighlightEvent event) {
        if (!(Minecraft.m_91087_().f_91074_.m_21205_().m_41720_() instanceof JunctionGridItem)) {
            return;
        }
        if (!((JunctionGridItem)Minecraft.m_91087_().f_91074_.m_21205_().m_41720_()).showJunctionGrid()) {
            return;
        }
        PoseStack pose = event.getPoseStack();
        Renderer20.set(pose, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), 255);
        FvtmRenderTypes.setLines();
        QV3D vec = new QV3D(event.getTarget().m_82450_().f_82479_, event.getTarget().m_82450_().f_82480_, event.getTarget().m_82450_().f_82481_);
        BlockPos pos = BlockPos.m_274446_((Position)event.getTarget().m_82450_());
        double cx = event.getCamera().m_90583_().f_82479_;
        double cy = event.getCamera().m_90583_().f_82480_;
        double cz = event.getCamera().m_90583_().f_82481_;
        double yy = (float)vec.y * 0.0625f;
        Renderer20.setColor(RGB.WHITE);
        FvtmRenderTypes.setCutout(FvtmRegistry.WHITE_TEXTURE);
        pose.m_85836_();
        pose.m_85837_(-cx, -cy, -cz);
        for (int i = 0; i < 4; ++i) {
            pose.m_85836_();
            pose.m_85837_((double)pos.m_123341_() + ((double)i * 0.25 + 0.125), (double)pos.m_123342_() + yy + 0.01, (double)pos.m_123343_() + 0.5);
            DebugUtils.LLBB2.render();
            pose.m_85849_();
            pose.m_85836_();
            pose.m_85837_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + yy + 0.01, (double)pos.m_123343_() + ((double)i * 0.25 + 0.125));
            DebugUtils.LLBB0.render();
            pose.m_85849_();
        }
        double v = vec.x < 0 ? (double)(-vec.x - 16) * -0.0625 : (double)vec.x * 0.0625;
        Renderer20.setColor(CYAN);
        pose.m_85836_();
        pose.m_85837_((double)pos.m_123341_() + v, (double)pos.m_123342_() + yy + 0.01, (double)pos.m_123343_() + 0.5);
        DebugUtils.LLBB2.render();
        pose.m_85849_();
        v = vec.z < 0 ? (double)(-vec.z - 16) * -0.0625 : (double)vec.z * 0.0625;
        pose.m_85836_();
        pose.m_85837_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + yy + 0.01, (double)pos.m_123343_() + v);
        DebugUtils.LLBB0.render();
        pose.m_85849_();
        Renderer20.setColor(ORG);
        pose.m_85837_(vec.vec.x, vec.vec.y, vec.vec.z);
        pose.m_85841_(0.03125f, 0.03125f, 0.03125f);
        DebugUtils.SPHERE.render();
        pose.m_85849_();
    }

    @SubscribeEvent
    public static void renderRail(RenderLevelStageEvent event) {
        V3D vec1;
        V3D vec0;
        if (RailPlacingUtil.CL_CURRENT == null || RailPlacingUtil.CL_CURRENT.points.size() < 2) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS) {
            return;
        }
        Camera camera = event.getCamera();
        double cx = camera.m_90583_().f_82479_;
        double cy = camera.m_90583_().f_82480_;
        double cz = camera.m_90583_().f_82481_;
        PoseStack pose = event.getPoseStack();
        VertexConsumer cons = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
        Renderer20.set(pose, cons, 0);
        FvtmRenderTypes.setLines();
        pose.m_85836_();
        pose.m_85837_(-cx, -cy, -cz);
        RailPlacingUtil.NewTrack conn = RailPlacingUtil.CL_CURRENT;
        if (conn.preview == null) {
            conn.genpreview();
        }
        Renderer20.setColor(BLUE);
        for (int j = 0; j < conn.track.vecpath.length - 1; ++j) {
            vec0 = conn.track.vecpath[j];
            vec1 = conn.track.vecpath[j + 1];
            DebugUtils.LINE_POLY.vertices[0].pos(vec0.x, vec0.y + (double)0.1f, vec0.z);
            DebugUtils.LINE_POLY.vertices[1].pos(vec1.x, vec1.y + (double)0.1f, vec1.z);
            DebugUtils.LINE.render();
        }
        int size = RailPlacingUtil.CL_CURRENT.points.size();
        Renderer20.setColor(CYAN);
        for (int i = 1; i < size - 1; ++i) {
            double[] arr = conn.track.getPosition(conn.track.length / (double)(size - 1) * (double)i);
            vec1 = RailPlacingUtil.CL_CURRENT.points.get((int)i).vec;
            DebugUtils.LINE_POLY.vertices[0].pos(arr[0], arr[1] - (double)0.05f, arr[2]);
            DebugUtils.LINE_POLY.vertices[1].pos(vec1.x, vec1.y - (double)0.05f, vec1.z);
            DebugUtils.LINE.render();
        }
        Renderer20.setColor(ORG);
        for (ArrayList<V3D> l : conn.preview) {
            for (int j = 0; j < l.size() - 1; ++j) {
                vec0 = l.get(j);
                DebugUtils.LINE_POLY.vertices[0].pos(vec0.x, vec0.y + (double)conn.gauge.getHeight() - 0.01, vec0.z);
                vec1 = l.get(j + 1);
                DebugUtils.LINE_POLY.vertices[1].pos(vec1.x, vec1.y + (double)conn.gauge.getHeight() - 0.01, vec1.z);
                DebugUtils.LINE.render();
            }
        }
        Renderer20.resetColor();
        pose.m_85849_();
    }

    @SubscribeEvent
    public static void onLevelRender(RenderGuiOverlayEvent event) {
        if (Minecraft.m_91087_().f_91074_.m_20202_() instanceof RootVehicle && event.getOverlay().id().m_135815_().equals("hotbar")) {
            VehicleOverlay.RS[] rs;
            vehicle = (RootVehicle)Minecraft.m_91087_().f_91074_.m_20202_();
            for (VehicleOverlay.RS r : rs = VehicleOverlay.update(ForgeClientEvents.vehicle.vehicle)) {
                event.getGuiGraphics().m_280488_(Minecraft.m_91087_().f_91062_, r.str, r.x, r.y, 0xFFFFFF);
            }
        }
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        SystemManager.onClientTick();
    }
}

