/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.function.block;

import java.util.LinkedHashMap;
import java.util.Map;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.data.block.BlockFunction;
import net.fexcraft.mod.fvtm.data.block.FvtmBlockEntity;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.CubeSide;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.StateWrapper;
import net.fexcraft.mod.uni.world.WorldW;

public class BoolBlockFunction
extends BlockFunction {
    private LinkedHashMap<String, Boolean> bools = new LinkedHashMap();
    private String key;

    @Override
    public BlockFunction parse(JsonValue val) {
        if (val == null) {
            return this;
        }
        for (Map.Entry entry : val.asMap().entries()) {
            if (this.key == null) {
                this.key = (String)entry.getKey();
            }
            this.bools.put((String)entry.getKey(), ((JsonValue)entry.getValue()).bool());
        }
        return this;
    }

    @Override
    public BlockFunction load(TagCW com) {
        if (!com.has(this.id())) {
            return this;
        }
        TagCW tag = com.getCompound(this.id());
        for (String key : tag.keys()) {
            this.bools.put(key, tag.getBoolean(key));
        }
        return this;
    }

    @Override
    public TagCW save(TagCW com) {
        TagCW tag = TagCW.create();
        for (Map.Entry<String, Boolean> entry : this.bools.entrySet()) {
            tag.set(entry.getKey(), entry.getValue().booleanValue());
        }
        com.set(this.id(), tag);
        return com;
    }

    @Override
    public String id() {
        return "fvtm:boolean";
    }

    @Override
    public BlockFunction copy(Block block) {
        return new BoolBlockFunction().copy(this.key, this.bools);
    }

    public BlockFunction copy(String k, Map<String, Boolean> v) {
        this.key = k;
        this.bools.putAll(v);
        return this;
    }

    @Override
    public boolean onClick(WorldW world, V3I pos, V3D hit, StateWrapper state, CubeSide side, EntityW player, boolean mainhand) {
        if (!mainhand) {
            return false;
        }
        this.bools.put(this.key, this.bools.get(this.key) == false);
        if (world.isTilePresent(pos)) {
            BoolBlockFunction.sendClientUpdate(world, pos);
        }
        return true;
    }

    public String key() {
        return this.key;
    }

    public boolean valOf(String key) {
        return this.bools.containsValue(key) ? this.bools.get(key) : false;
    }

    public void toggle(FvtmBlockEntity tile, String key, Boolean to) {
        if (key == null) {
            key = this.key;
        }
        this.bools.put(key, to == null ? !this.bools.get(key).booleanValue() : to);
        if (tile == null) {
            return;
        }
        BoolBlockFunction.sendClientUpdate(tile.getBlockData(), tile.getWorldW(), tile.getV3I());
    }
}

