/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.function.part;

import java.util.List;
import net.fexcraft.app.json.FJson;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.part.PartFunction;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.data.vehicle.WheelSlot;
import net.fexcraft.mod.fvtm.function.part.GetWheelPos;
import net.fexcraft.mod.fvtm.handler.WheelInstallationHandler;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.WorldW;

public class WheelFunction
extends PartFunction
implements GetWheelPos {
    private String inst_pos;
    private WheelSlot wheel;

    @Override
    public PartFunction init(Part part, FJson json) {
        return this;
    }

    @Override
    public PartFunction load(TagCW compound) {
        this.inst_pos = compound.has("wheel_pos") ? compound.getString("wheel_pos") : null;
        return this;
    }

    @Override
    public TagCW save(TagCW compound) {
        if (this.inst_pos != null) {
            compound.set("wheel_pos", this.inst_pos);
        }
        return compound;
    }

    @Override
    public WheelSlot getWheelPos(VehicleData vehicle) {
        if (this.wheel != null) {
            return this.wheel;
        }
        if (this.inst_pos != null) {
            this.wheel = vehicle.getWheelSlots().get(this.inst_pos);
            return this.wheel;
        }
        return null;
    }

    @Override
    public String getId() {
        return "fvtm:wheel";
    }

    public void setWheel(String cat, WheelSlot slot) {
        this.inst_pos = cat;
        this.wheel = slot;
    }

    @Override
    public PartFunction copy(Part part) {
        return new WheelFunction().init(part, null);
    }

    @Override
    public void addInformation(StackWrapper stack, WorldW world, PartData data, List<String> tooltip, boolean ext) {
        WheelInstallationHandler.WheelData wdata = (WheelInstallationHandler.WheelData)((Part)data.getType()).getInstallHandlerData();
        tooltip.add(Formatter.format((String)("&9Wheel Radius: &7" + wdata.getRadius())));
        tooltip.add(Formatter.format((String)("&9Wheel Width: &7" + wdata.getWidth())));
    }
}

