/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.model.content;

import java.util.ArrayList;
import java.util.List;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.ModelData;
import net.fexcraft.mod.fvtm.util.TransformMap;

public class VehicleModel
extends DefaultModel {
    public static final VehicleModel EMPTY = new VehicleModel();
    public final TransformMap item_scale = new TransformMap(0);
    public final TransformMap item_translate = new TransformMap(1);
    public final TransformMap item_rotate = new TransformMap(2);

    @Override
    public VehicleModel parse(ModelData data) {
        ArrayList list;
        super.parse(data);
        if (data.has("ItemScale")) {
            JsonValue val = data.get("ItemScale");
            if (val.isArray()) {
                for (JsonValue v : (List)val.asArray().value) {
                    try {
                        this.parseItemTransform(0, v.string_value());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                try {
                    this.item_scale.setAll(val.float_value());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (data.has("ItemTranslate")) {
            list = data.getArray("ItemTranslate").toStringList();
            for (String str : list) {
                try {
                    this.parseItemTransform(1, str);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (data.has("ItemRotate")) {
            list = data.getArray("ItemRotate").toStringList();
            for (String str : list) {
                try {
                    this.parseItemTransform(2, str);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this;
    }

    private void parseItemTransform(int type, String str) throws Exception {
        String[] split = str.split(" ");
        split[1] = split[1].toLowerCase();
        float[] val = new float[3];
        boolean set = split[0].toLowerCase().equals("set");
        if (split.length == 3) {
            val[1] = val[2] = Float.parseFloat(split[2]);
            val[0] = val[2];
        } else {
            val[0] = Float.parseFloat(split[2]);
            val[1] = Float.parseFloat(split[3]);
            val[2] = Float.parseFloat(split[4]);
        }
        if (split[1].equals("all")) {
            switch (type) {
                case 0: {
                    if (set) {
                        this.item_scale.setAll(val[0], val[1], val[2]);
                    } else {
                        this.item_scale.addAll(val[0], val[1], val[2]);
                    }
                    return;
                }
                case 1: {
                    if (set) {
                        this.item_translate.setAll(val[0], val[1], val[2]);
                    } else {
                        this.item_translate.addAll(val[0], val[1], val[2]);
                    }
                    return;
                }
                case 2: {
                    if (set) {
                        this.item_rotate.setAll(val[0], val[1], val[2]);
                    } else {
                        this.item_rotate.addAll(val[0], val[1], val[2]);
                    }
                    return;
                }
            }
        } else {
            String trype = split[1].toUpperCase();
            switch (type) {
                case 0: {
                    if (set) {
                        this.item_scale.set(trype, val[0], val[1], val[2]);
                    } else {
                        this.item_scale.add(trype, val[0], val[1], val[2]);
                    }
                    return;
                }
                case 1: {
                    if (set) {
                        this.item_translate.set(trype, val[0], val[1], val[2]);
                    } else {
                        this.item_translate.add(trype, val[0], val[1], val[2]);
                    }
                    return;
                }
                case 2: {
                    if (set) {
                        this.item_rotate.set(trype, val[0], val[1], val[2]);
                    } else {
                        this.item_rotate.add(trype, val[0], val[1], val[2]);
                    }
                    return;
                }
            }
        }
    }
}

