/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.model.content;

import java.util.ArrayList;
import java.util.Map;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.ModelData;

public class WireModel
extends DefaultModel {
    public static final WireModel EMPTY = new WireModel();
    public ArrayList<V3D[]> wire_model = new ArrayList();
    public ArrayList<float[]> wire_vv = new ArrayList();
    public ArrayList<Float> wire_ang = new ArrayList();
    public ArrayList<Float> wire_u = new ArrayList();

    @Override
    public WireModel parse(ModelData data) {
        ArrayList wires;
        super.parse(data);
        if (data.has("Wire")) {
            wires = data.getArray("Wire").toStringList();
            if (wires.isEmpty()) {
                return this;
            }
            for (String wire : wires) {
                float an;
                String[] args = wire.trim().split(" ");
                boolean rect = args[0].equals("rect") || args[0].equals("flat");
                float scale = Float.parseFloat(args[1]);
                float sx = Float.parseFloat(args[2]);
                float sy = Float.parseFloat(args[3]);
                float w = Float.parseFloat(args[4]);
                float h = Float.parseFloat(args[5]);
                boolean m = Boolean.parseBoolean(args[6]);
                float io = args.length > 7 ? Float.parseFloat(args[7]) / (float)this.tex_height : 0.0f;
                float iw = args.length > 8 ? Float.parseFloat(args[8]) / (float)this.tex_height : 0.125f / (float)this.tex_height;
                float ih = args.length > 9 ? Float.parseFloat(args[9]) / (float)this.tex_height : 0.125f / (float)this.tex_height;
                float f = an = args.length > 10 ? Float.parseFloat(args[10]) : 0.0f;
                if (!rect) continue;
                this.addWireRect(scale, sx, sy, w, h, m, 1.0f, new float[]{io, iw, ih}, an);
            }
        }
        if (data.has("Wires")) {
            wires = data.getMap("Wires");
            JsonMap map = null;
            for (Map.Entry entry : wires.entries()) {
                float[] vv;
                float[] fArray;
                float[] fArray2;
                map = ((JsonValue)entry.getValue()).asMap();
                float scl = map.getFloat("scale", 0.0625f);
                if (map.has("pos")) {
                    fArray2 = map.getArray("pos").toFloatArray();
                } else {
                    float[] fArray3 = new float[2];
                    fArray3[0] = -0.5f;
                    fArray2 = fArray3;
                    fArray3[1] = -0.5f;
                }
                float[] pos = fArray2;
                if (map.has("size")) {
                    fArray = map.getArray("size").toFloatArray();
                } else {
                    float[] fArray4 = new float[2];
                    fArray4[0] = 1.0f;
                    fArray = fArray4;
                    fArray4[1] = 1.0f;
                }
                float[] siz = fArray;
                if (map.has("v")) {
                    vv = map.getArray("v").toFloatArray();
                    int i = 0;
                    while (i < vv.length) {
                        int n = i++;
                        vv[n] = vv[n] / (float)this.tex_height;
                    }
                } else {
                    vv = new float[]{0.0f, 0.125f * (float)this.tex_height, 0.125f * (float)this.tex_height};
                }
                float u = map.getFloat("u", 16.0f) / (float)this.tex_width;
                float ang = map.getFloat("angle", 0.0f);
                boolean mir = map.getBoolean("mirror", false);
                this.addWireRect(scl, pos[0], pos[1], siz[0], siz[1], mir, u, vv, ang);
            }
        }
        return this;
    }

    public void addWireRect(float scale, float start_x, float start_y, float width, float height, boolean mirror, float u, float[] vv, float ang) {
        this.wire_model.add(new V3D[]{new V3D((double)start_x, (double)start_y, 0.0).scale((double)scale), new V3D((double)(start_x + width), (double)start_y, 0.0).scale((double)scale)});
        float buff = 0.0f;
        this.wire_vv.add(new float[]{vv[0], vv[0] + (buff += vv[1])});
        this.wire_ang.add(Float.valueOf(ang));
        this.wire_u.add(Float.valueOf(u));
        if (height > 0.0f) {
            this.wire_model.add(new V3D[]{new V3D((double)start_x, (double)(start_y + height), 0.0).scale((double)scale), new V3D((double)start_x, (double)start_y, 0.0).scale((double)scale)});
            this.wire_vv.add(new float[]{vv[0] + buff, vv[0] + (buff += vv[2])});
            this.wire_model.add(new V3D[]{new V3D((double)(start_x + width), (double)start_y, 0.0).scale((double)scale), new V3D((double)(start_x + width), (double)(start_y + height), 0.0).scale((double)scale)});
            this.wire_vv.add(new float[]{vv[0] + buff, vv[0] + (buff += vv[2])});
            this.wire_model.add(new V3D[]{new V3D((double)(start_x + width), (double)(start_y + height), 0.0).scale((double)scale), new V3D((double)start_x, (double)(start_y + height), 0.0).scale((double)scale)});
            this.wire_vv.add(new float[]{vv[0] + buff, vv[0] + (buff + vv[1])});
            for (int i = 0; i < 3; ++i) {
                this.wire_ang.add(Float.valueOf(ang));
                this.wire_u.add(Float.valueOf(u));
            }
        } else {
            float h = 0.01f / scale;
            this.wire_model.add(new V3D[]{new V3D((double)(start_x + width), (double)(start_y + h), 0.0).scale((double)scale), new V3D((double)start_x, (double)(start_y + h), 0.0).scale((double)scale)});
            this.wire_vv.add(new float[]{vv[0] + buff, vv[0] + (buff + vv[1])});
            this.wire_ang.add(Float.valueOf(ang));
            this.wire_u.add(Float.valueOf(u));
        }
        if (mirror) {
            this.addWireRect(scale, -start_x - width, start_y, width, height, false, u, vv, ang);
        }
    }

    @Override
    public int getDefTexWidth() {
        return 16;
    }

    @Override
    public int getDefTexHeight() {
        return 16;
    }
}

