/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.model.program;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Predicate;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.frl.Renderer;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.fvtm.data.block.JackEntity;
import net.fexcraft.mod.fvtm.model.ModelGroup;
import net.fexcraft.mod.fvtm.model.ModelRenderData;
import net.fexcraft.mod.fvtm.model.Program;
import net.fexcraft.mod.fvtm.model.RenderOrder;
import net.fexcraft.mod.fvtm.model.program.WirePrograms;
import net.fexcraft.mod.fvtm.render.SeparateRenderCache;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;

public class DefaultPrograms {
    public static boolean[] SIGNAL_TOGGLE = new boolean[4];
    public static Timer[] SIGNAL_TIMER = new Timer[4];
    public static Program GLOW;

    public static void init() {
        ModelGroup.PROGRAMS.add(new AlwaysGlow(){

            @Override
            public boolean shouldGlow(ModelGroup list, ModelRenderData data) {
                return true;
            }

            @Override
            public String id() {
                return "fvtm:glow";
            }
        });
        ModelGroup.PROGRAMS.add(new AlwaysGlow(){

            @Override
            public boolean shouldGlow(ModelGroup list, ModelRenderData data) {
                return data.vehicle.getLightsState();
            }

            @Override
            public String id() {
                return "fvtm:lights";
            }
        });
        ModelGroup.PROGRAMS.add(new AlwaysGlow(){

            @Override
            public boolean shouldGlow(ModelGroup list, ModelRenderData data) {
                return data.vehicle.getLightsState();
            }

            @Override
            public String id() {
                return "fvtm:front_lights";
            }
        });
        ModelGroup.PROGRAMS.add(new AlwaysGlow(){

            @Override
            public boolean shouldGlow(ModelGroup list, ModelRenderData data) {
                return data.vehicle.getLightsState() || data.vehent != null && data.vehent.isBraking();
            }

            @Override
            public String id() {
                return "fvtm:back_lights";
            }
        });
        ModelGroup.PROGRAMS.add(new AlwaysGlow(){

            @Override
            public boolean shouldGlow(ModelGroup list, ModelRenderData data) {
                return data.vehicle.getFogLightsState();
            }

            @Override
            public String id() {
                return "fvtm:fog_lights";
            }
        });
        ModelGroup.PROGRAMS.add(new AlwaysGlow(){

            @Override
            public boolean shouldGlow(ModelGroup list, ModelRenderData data) {
                return data.vehicle.getLongLightsState();
            }

            @Override
            public String id() {
                return "fvtm:long_lights";
            }
        });
        ModelGroup.PROGRAMS.add(new AlwaysGlow(){

            @Override
            public boolean shouldGlow(ModelGroup list, ModelRenderData data) {
                return data.entity != null && data.vehent.isBraking();
            }

            @Override
            public String id() {
                return "fvtm:brake_lights";
            }
        });
        ModelGroup.PROGRAMS.add(new AlwaysGlow(){

            @Override
            public boolean shouldGlow(ModelGroup list, ModelRenderData data) {
                return data.vehicle.getThrottle() < -0.01;
            }

            @Override
            public String id() {
                return "fvtm:reverse_lights";
            }
        });
        ModelGroup.PROGRAMS.add(new AlwaysGlow(){

            @Override
            public boolean shouldGlow(ModelGroup list, ModelRenderData data) {
                return SIGNAL_TOGGLE[0] && (data.vehicle.getTurnLightLeft() || data.vehicle.getWarningLights());
            }

            @Override
            public String id() {
                return "fvtm:turn_signal_left";
            }
        });
        ModelGroup.PROGRAMS.add(new AlwaysGlow(){

            @Override
            public boolean shouldGlow(ModelGroup list, ModelRenderData data) {
                return SIGNAL_TOGGLE[0] && (data.vehicle.getTurnLightRight() || data.vehicle.getWarningLights());
            }

            @Override
            public String id() {
                return "fvtm:turn_signal_right";
            }
        });
        ModelGroup.PROGRAMS.add(new AlwaysGlow(){

            @Override
            public boolean shouldGlow(ModelGroup list, ModelRenderData data) {
                return SIGNAL_TOGGLE[0] && data.vehicle.getWarningLights();
            }

            @Override
            public String id() {
                return "fvtm:warning_lights";
            }
        });
        ModelGroup.PROGRAMS.add(new AlwaysGlow(){

            @Override
            public boolean shouldGlow(ModelGroup list, ModelRenderData data) {
                if (data.vehicle.getTurnLightLeft() || data.vehicle.getWarningLights()) {
                    return SIGNAL_TOGGLE[0];
                }
                return data.vehicle.getLightsState() || data.vehicle.getThrottle() < -0.01;
            }

            @Override
            public String id() {
                return "fvtm:back_lights_signal_left";
            }
        });
        ModelGroup.PROGRAMS.add(new AlwaysGlow(){

            @Override
            public boolean shouldGlow(ModelGroup list, ModelRenderData data) {
                if (data.vehicle.getTurnLightRight() || data.vehicle.getWarningLights()) {
                    return SIGNAL_TOGGLE[0];
                }
                return data.vehicle.getLightsState() || data.vehicle.getThrottle() < -0.01;
            }

            @Override
            public String id() {
                return "fvtm:back_lights_signal_right";
            }
        });
        int i = 0;
        while (i < SIGNAL_TOGGLE.length) {
            final int fi = i++;
            ModelGroup.PROGRAMS.add(new AlwaysGlow(){

                @Override
                public boolean shouldGlow(ModelGroup list, ModelRenderData data) {
                    return SIGNAL_TOGGLE[fi];
                }

                @Override
                public String id() {
                    return "fvtm:signal_lights_" + fi;
                }
            });
        }
        ModelGroup.PROGRAMS.add(new AlwaysGlow(){

            @Override
            public boolean shouldGlow(ModelGroup list, ModelRenderData data) {
                return data.vehicle.getLightsState() && data.vehicle.getAttribute("forward").asBoolean();
            }

            @Override
            public String id() {
                return "fvtm:lights_rail_forward";
            }
        });
        ModelGroup.PROGRAMS.add(new AlwaysGlow(){

            @Override
            public boolean shouldGlow(ModelGroup list, ModelRenderData data) {
                return data.vehicle.getLightsState() && !data.vehicle.getAttribute("forward").asBoolean();
            }

            @Override
            public String id() {
                return "fvtm:lights_rail_backward";
            }
        });
        ModelGroup.PROGRAMS.add(new Program(){

            @Override
            public String id() {
                return "fvtm:bogie_auto";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                Renderer.RENDERER.rotate(data.vehicle.getAttribute(data.part_category + "_angle").asFloat(), 0, 1, 0);
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                Renderer.RENDERER.rotate(-data.vehicle.getAttribute(data.part_category + "_angle").asFloat(), 0, 1, 0);
            }
        });
        ModelGroup.PROGRAMS.add(new Program(){

            @Override
            public String id() {
                return "fvtm:bogie_auto_opposite";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                Renderer.RENDERER.rotate(-data.vehicle.getAttribute(data.part_category + "_angle").asFloat(), 0, 1, 0);
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                Renderer.RENDERER.rotate(data.vehicle.getAttribute(data.part_category + "_angle").asFloat(), 0, 1, 0);
            }
        });
        ModelGroup.PROGRAMS.add(new Program(){

            @Override
            public String id() {
                return "fvtm:bogie_front";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                Renderer.RENDERER.rotate(data.vehicle.getAttribute("bogie_front_angle").asFloat(), 0, 1, 0);
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                Renderer.RENDERER.rotate(-data.vehicle.getAttribute("bogie_front_angle").asFloat(), 0, 1, 0);
            }
        });
        ModelGroup.PROGRAMS.add(new Program(){

            @Override
            public String id() {
                return "fvtm:bogie_rear";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                Renderer.RENDERER.rotate(data.vehicle.getAttribute("bogie_rear_angle").asFloat(), 0, 1, 0);
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                Renderer.RENDERER.rotate(-data.vehicle.getAttribute("bogie_rear_angle").asFloat(), 0, 1, 0);
            }
        });
        ModelGroup.PROGRAMS.add(new AttributeLights("", false));
        ModelGroup.PROGRAMS.add(new AttributeSignalLights("", 0, false));
        ModelGroup.PROGRAMS.add(new IDSpecific(""));
        ModelGroup.PROGRAMS.add(new IDSpecificArray(""));
        ModelGroup.PROGRAMS.add(new SignBase());
        ModelGroup.PROGRAMS.add(SignScaled.INST[0]);
        ModelGroup.PROGRAMS.add(new SignScaledOff(false, false, 0.0f, 0.0f));
        ModelGroup.PROGRAMS.add(new SignOffset(0.0f, 0.0f));
        ModelGroup.PROGRAMS.add(SignBorder.INST[0]);
        ModelGroup.PROGRAMS.add(SignCorner.INST[0]);
        ModelGroup.PROGRAMS.add(new LightBeam());
        ModelGroup.PROGRAMS.add((Program)new LightBeam("fvtm:lb_lights").setPredicate(data -> data.vehicle.getLightsState()).register());
        ModelGroup.PROGRAMS.add((Program)new LightBeam("fvtm:lb_front_lights").setPredicate(data -> data.vehicle.getLightsState() && !data.vehicle.getLongLightsState() && !data.vehicle.getFogLightsState()).register());
        ModelGroup.PROGRAMS.add((Program)new LightBeam("fvtm:lb_back_lights").setPredicate(data -> data.vehicle.getLightsState() || data.vehicle.getThrottle() < -0.01).register());
        ModelGroup.PROGRAMS.add((Program)new LightBeam("fvtm:lb_back_lights").setPredicate(data -> data.vehent != null && data.vehent.isBraking()).register());
        ModelGroup.PROGRAMS.add((Program)new LightBeam("fvtm:lb_long_lights").setPredicate(data -> data.vehicle.getLongLightsState() && !data.vehicle.getFogLightsState()).register());
        ModelGroup.PROGRAMS.add((Program)new LightBeam("fvtm:lb_fog_lights").setPredicate(data -> data.vehicle.getFogLightsState()).register());
        ModelGroup.PROGRAMS.add((Program)new LightBeam("fvtm:lb_reverse_lights").setPredicate(data -> data.vehicle.getThrottle() < -0.01).register());
        ModelGroup.PROGRAMS.add((Program)new LightBeam("fvtm:lb_signal_left").setPredicate(data -> SIGNAL_TOGGLE[0] && (data.vehicle.getTurnLightLeft() || data.vehicle.getWarningLights())).register());
        ModelGroup.PROGRAMS.add((Program)new LightBeam("fvtm:lb_signal_right").setPredicate(data -> SIGNAL_TOGGLE[0] && (data.vehicle.getTurnLightRight() || data.vehicle.getWarningLights())).register());
        ModelGroup.PROGRAMS.add((Program)new LightBeam("fvtm:lb_warning_lights").setPredicate(data -> SIGNAL_TOGGLE[0] && data.vehicle.getWarningLights()).register());
        ModelGroup.PROGRAMS.add((Program)new LightBeam("fvtm:lb_back_lights_signal_left").setPredicate(data -> {
            if (data.vehicle.getTurnLightLeft() || data.vehicle.getWarningLights()) {
                return SIGNAL_TOGGLE[0];
            }
            return data.vehicle.getLightsState() || data.vehicle.getThrottle() < -0.01;
        }).register());
        ModelGroup.PROGRAMS.add((Program)new LightBeam("fvtm:lb_back_lights_signal_right").setPredicate(data -> {
            if (data.vehicle.getTurnLightRight() || data.vehicle.getWarningLights()) {
                return SIGNAL_TOGGLE[0];
            }
            return data.vehicle.getLightsState() || data.vehicle.getThrottle() < -0.01;
        }).register());
        WirePrograms.init();
        ModelGroup.PROGRAMS.add(new Program(){

            @Override
            public String id() {
                return "fvtm:vehicle_on_jack";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                if (data.tile == null || ((JackEntity)data.tile).getVehicle() == null) {
                    return;
                }
                SeparateRenderCache.insert((JackEntity)data.tile);
            }

            @Override
            public boolean post() {
                return false;
            }
        });
        ModelGroup.PROGRAMS.add(new Program(){
            private boolean in;

            @Override
            public String id() {
                return "fvtm:jack_stand";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                list.visible = true;
                if (this.in || data.tile == null || ((JackEntity)data.tile).getCoords().size() < 2) {
                    return;
                }
                this.in = true;
                for (V3D coord : ((JackEntity)data.tile).getCoords()) {
                    Renderer.RENDERER.translate(coord);
                    list.render(data);
                    Renderer.RENDERER.translate(-coord.x, -coord.y, -coord.z);
                }
                list.visible = false;
                this.in = false;
            }

            @Override
            public boolean post() {
                return false;
            }
        });
    }

    public static void setupSignalTimer() {
        for (int i = 0; i < SIGNAL_TOGGLE.length; ++i) {
            if (SIGNAL_TIMER[i] == null) continue;
            SIGNAL_TIMER[i].cancel();
        }
        FvtmLogger.debug((Object)"Setting up blinker-toggle timer.");
        LocalDateTime midnight = LocalDateTime.of(LocalDate.now(ZoneOffset.systemDefault()), LocalTime.MIDNIGHT);
        long mid = midnight.toInstant(ZoneOffset.UTC).toEpochMilli();
        long date = Time.getDate();
        while ((mid += (long)Config.SIGNAL_INTERVAL) < date) {
        }
        long quarter = Config.SIGNAL_INTERVAL / 4;
        int i = 0;
        while (i < SIGNAL_TOGGLE.length) {
            final int fi = i++;
            DefaultPrograms.SIGNAL_TIMER[fi] = new Timer();
            SIGNAL_TIMER[fi].schedule(new TimerTask(){

                @Override
                public void run() {
                    DefaultPrograms.SIGNAL_TOGGLE[fi] = !SIGNAL_TOGGLE[fi];
                }
            }, new Date(mid + quarter * (long)fi), (long)Config.SIGNAL_INTERVAL);
        }
    }

    public static class AttributeLights
    extends AttributeBased {
        private boolean equals;
        private boolean did;

        public AttributeLights(String attr, boolean eq) {
            super(attr);
            this.equals = eq;
        }

        @Override
        public String id() {
            return "fvtm:attribute_lights";
        }

        @Override
        public void pre(ModelGroup group, ModelRenderData data) {
            this.attr = data.vehicle.getAttribute(this.attribute);
            this.did = this.did();
            if (this.did) {
                GLOW.pre(group, data);
                this.did = true;
            }
        }

        protected boolean did() {
            return this.attr != null && this.attr.asBoolean() != this.equals;
        }

        @Override
        public void post(ModelGroup group, ModelRenderData data) {
            if (this.did) {
                GLOW.post(group, data);
                this.did = false;
            }
        }

        @Override
        public Program parse(String[] args) {
            return new AttributeLights(args[0], args.length > 1 ? Boolean.parseBoolean(args[1]) : false);
        }
    }

    public static class AttributeSignalLights
    extends AttributeLights {
        private int channel;

        public AttributeSignalLights(String attr, int chan, boolean eq) {
            super(attr, eq);
            this.channel = chan;
        }

        @Override
        public String id() {
            return "fvtm:attribute_signal_lights";
        }

        @Override
        public boolean did() {
            return super.did() && SIGNAL_TOGGLE[this.channel];
        }

        @Override
        public Program parse(String[] args) {
            return new AttributeSignalLights(args[0], args.length > 1 ? Integer.parseInt(args[1]) : 1, args.length > 2 && Boolean.parseBoolean(args[2]));
        }
    }

    public static class IDSpecific
    implements Program {
        private String group;

        public IDSpecific(String id) {
            this.group = id;
        }

        @Override
        public String id() {
            return "fvtm:category_specific";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            if (!data.part_category.equals(this.group)) {
                list.visible = false;
            }
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            list.visible = true;
        }

        @Override
        public Program parse(String[] args) {
            if (args.length > 1) {
                return new IDSpecificArray(args);
            }
            return new IDSpecific(args[0]);
        }
    }

    public static class IDSpecificArray
    implements Program {
        private String[] groups;

        public IDSpecificArray(String ... ids) {
            this.groups = ids;
        }

        @Override
        public String id() {
            return "fvtm:category_specific_array";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            for (String str : this.groups) {
                if (!str.equals(data.part_category)) continue;
                return;
            }
            list.visible = false;
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            list.visible = true;
        }

        @Override
        public Program parse(String[] args) {
            if (args.length == 1) {
                return new IDSpecific(args[0]);
            }
            return new IDSpecificArray(args);
        }
    }

    public static class SignBase
    implements Program {
        @Override
        public String id() {
            return "fvtm:sign_base";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            Renderer.RENDERER.push();
            if (data.sign != null) {
                Renderer.RENDERER.scale(1.0, (double)data.sign.height, (double)data.sign.width);
            }
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            Renderer.RENDERER.pop();
        }

        @Override
        public Program parse(String[] args) {
            return this;
        }
    }

    public static class SignScaled
    implements Program {
        public static SignScaled[] INST = new SignScaled[4];
        protected boolean width;
        protected boolean height;

        public SignScaled(boolean w, boolean h) {
            this.width = w;
            this.height = h;
        }

        @Override
        public String id() {
            return "fvtm:sign_scaled";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            Renderer.RENDERER.push();
            if (data.sign != null && list.visible) {
                Renderer.RENDERER.scale(1.0, this.height ? (double)data.sign.height : 1.0, this.width ? (double)data.sign.width : 1.0);
            }
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            Renderer.RENDERER.pop();
        }

        @Override
        public Program parse(String[] args) {
            boolean w = args.length > 0 && Boolean.parseBoolean(args[0]);
            boolean h = args.length > 1 && Boolean.parseBoolean(args[1]);
            return INST[(w ? 1 : 0) + (h ? 2 : 0)];
        }

        static {
            SignScaled.INST[0] = new SignScaled(false, false);
            SignScaled.INST[1] = new SignScaled(true, false);
            SignScaled.INST[2] = new SignScaled(false, true);
            SignScaled.INST[3] = new SignScaled(true, true);
        }
    }

    public static class SignScaledOff
    extends SignScaled {
        private float ws;
        private float hs;

        public SignScaledOff(boolean w, boolean h, float sx, float sy) {
            super(w, h);
            this.ws = sx;
            this.hs = sy;
        }

        @Override
        public String id() {
            return "fvtm:sign_scaled_offset";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            Renderer.RENDERER.push();
            if (data.sign != null && list.visible) {
                Renderer.RENDERER.translate(0.0, (double)(data.sign.height * this.hs), (double)(data.sign.width * this.ws));
                Renderer.RENDERER.scale(1.0, this.height ? (double)data.sign.height : 1.0, this.width ? (double)data.sign.width : 1.0);
            }
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            Renderer.RENDERER.pop();
        }

        @Override
        public Program parse(String[] args) {
            boolean w = args.length > 0 && Boolean.parseBoolean(args[0]);
            boolean h = args.length > 1 && Boolean.parseBoolean(args[1]);
            float ws = args.length > 2 ? Float.parseFloat(args[2]) : 1.0f;
            float hs = args.length > 3 ? Float.parseFloat(args[3]) : 1.0f;
            return new SignScaledOff(w, h, ws, hs);
        }
    }

    public static class SignOffset
    implements Program {
        private float ws;
        private float hs;

        public SignOffset(float sx, float sy) {
            this.ws = sx;
            this.hs = sy;
        }

        @Override
        public String id() {
            return "fvtm:sign_offset";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            Renderer.RENDERER.push();
            if (data.sign != null && list.visible) {
                Renderer.RENDERER.translate(0.0, (double)(data.sign.height * this.hs), (double)(data.sign.width * this.ws));
            }
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            Renderer.RENDERER.pop();
        }

        @Override
        public Program parse(String[] args) {
            float ws = args.length > 0 ? Float.parseFloat(args[0]) : 1.0f;
            float hs = args.length > 1 ? Float.parseFloat(args[1]) : 1.0f;
            return new SignOffset(ws, hs);
        }
    }

    public static class SignBorder
    implements Program {
        public static SignBorder[] INST = new SignBorder[4];
        private int side;

        private SignBorder(int sid) {
            this.side = sid;
        }

        @Override
        public String id() {
            return "fvtm:sign_border";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            if (data.sign == null) {
                return;
            }
            if (data.sign.sides[this.side]) {
                list.visible = false;
            }
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            list.visible = true;
        }

        @Override
        public Program parse(String[] args) {
            return INST[args.length > 0 ? Integer.parseInt(args[0]) : 0];
        }

        static {
            for (int i = 0; i < INST.length; ++i) {
                SignBorder.INST[i] = new SignBorder(i);
            }
        }
    }

    public static class SignCorner
    implements Program {
        public static SignCorner[] INST = new SignCorner[4];
        private int corner;

        private SignCorner(int cid) {
            this.corner = cid;
        }

        @Override
        public String id() {
            return "fvtm:sign_corner";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            if (data.sign == null) {
                return;
            }
            switch (this.corner) {
                case 0: {
                    list.visible = !data.sign.sides[0] && !data.sign.sides[1];
                    break;
                }
                case 1: {
                    list.visible = !data.sign.sides[0] && !data.sign.sides[2];
                    break;
                }
                case 2: {
                    list.visible = !data.sign.sides[2] && !data.sign.sides[3];
                    break;
                }
                case 3: {
                    list.visible = !data.sign.sides[1] && !data.sign.sides[3];
                }
            }
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            list.visible = true;
        }

        @Override
        public Program parse(String[] args) {
            return INST[args.length > 0 ? Integer.parseInt(args[0]) : 0];
        }

        static {
            for (int i = 0; i < INST.length; ++i) {
                SignCorner.INST[i] = new SignCorner(i);
            }
        }
    }

    public static class LightBeam
    implements Program {
        public static LBRender LBR;
        protected Predicate<ModelRenderData> predicate;
        protected String id = "fvtm:light_beam";
        public String swivel;
        public V3D pos = new V3D();
        public boolean skipped;

        public LightBeam() {
        }

        public LightBeam(String lbid) {
            this.id = lbid;
        }

        public LightBeam init(V3D pos, String point, Predicate<ModelRenderData> predicate) {
            this.pos = pos;
            this.swivel = point;
            this.predicate = predicate;
            return this;
        }

        public LightBeam init(V3D pos, Predicate<ModelRenderData> predicate) {
            this.pos = pos;
            this.predicate = predicate;
            return this;
        }

        public LightBeam setPredicate(Predicate<ModelRenderData> predicate) {
            this.predicate = predicate;
            return this;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            if (!data.separaterender || Config.DISABLE_LIGHT_BEAMS) {
                return;
            }
            boolean bl = this.skipped = this.predicate != null && !this.predicate.test(data);
            if (!this.skipped) {
                LBR.pre(this, list, data);
            }
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            if (!data.separaterender || Config.DISABLE_LIGHT_BEAMS) {
                return;
            }
            if (!this.skipped) {
                LBR.post(this, list, data);
            }
            this.skipped = false;
        }

        @Override
        public RenderOrder order() {
            return RenderOrder.SEPARATE;
        }

        public static abstract class LBRender {
            public abstract void pre(LightBeam var1, ModelGroup var2, ModelRenderData var3);

            public abstract void post(LightBeam var1, ModelGroup var2, ModelRenderData var3);
        }
    }

    public static abstract class TextRendererBase
    implements Program {
        protected static float downscale = 0.00390625f;
        protected static RGB col = new RGB();
        protected int color;
        protected int width;
        protected float scale;
        protected static Attribute<?> attr;
        protected boolean glow;
        protected boolean centered;
        protected String text;
        protected String attrid;
        protected V3D pos;
        protected V3D rot;
        protected String fontkey;

        public TextRendererBase() {
            this.color = RGB.BLACK.packed;
            this.text = "";
            this.pos = new V3D();
            this.rot = new V3D();
        }

        @Override
        public String id() {
            return "fvtm:text";
        }

        @Override
        public boolean pre() {
            return false;
        }

        @Override
        public Program parse(JsonMap map) {
            TextRendererBase ren = this.create();
            ren.pos = map.has("pos") ? ContentConfigUtil.getVector(map.getArray("pos")) : V3D.NULL;
            ren.rot = map.has("rot") ? ContentConfigUtil.getVector(map.getArray("rot")) : V3D.NULL;
            ren.scale = map.getFloat("scale", 4.0f);
            ren.centered = map.getBoolean("centered", true);
            ren.text = map.getString("text", "-");
            ren.color = map.has("color") ? Integer.parseInt(map.get("color").string_value(), 16) : RGB.BLACK.packed;
            ren.glow = map.getBoolean("glow", false);
            ren.attrid = map.getString("attr", null);
            ren.fontkey = map.getString("font", null);
            ren.width = map.getInteger("width", 0);
            return ren;
        }

        public abstract TextRendererBase create();
    }

    public static abstract class AttributeBased
    implements Program {
        protected Attribute<?> attr;
        protected String attribute;

        public AttributeBased(String attr) {
            this.attribute = attr;
        }

        @Override
        public void init(ModelGroup list) {
        }
    }

    public static abstract class AlwaysGlow
    implements Program {
        private boolean didglow;

        public abstract boolean shouldGlow(ModelGroup var1, ModelRenderData var2);

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            this.didglow = this.shouldGlow(list, data);
            if (!this.didglow) {
                return;
            }
            GLOW.pre(list, data);
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            if (!this.didglow) {
                return;
            }
            GLOW.post(list, data);
        }

        @Override
        public String id() {
            return "fvtm:glow";
        }

        @Override
        public RenderOrder order() {
            return RenderOrder.BLENDED;
        }
    }
}

