/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.packet;

import io.netty.buffer.ByteBuf;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.uni.packet.PacketBase;
import net.fexcraft.mod.uni.world.EntityW;

public class Packet_VehMove
implements PacketBase<Packet_VehMove> {
    public int entid;
    public int fuel;
    public double[] pos;
    public double[] rot;
    public double throttle;
    public double steering;
    public double brake;

    public Packet_VehMove fill(Object[] data) {
        EntityW ent = (EntityW)data[0];
        this.entid = ent.getId();
        this.pos = ent.getPos().toDoubleArray();
        VehicleInstance vehicle = (VehicleInstance)data[1];
        this.rot = vehicle.pivot().toArray();
        this.fuel = vehicle.data.getAttribute("fuel_stored").asInteger();
        this.steering = vehicle.steer_yaw;
        this.throttle = vehicle.throttle;
        this.brake = vehicle.brake;
        return this;
    }

    public void encode(ByteBuf buffer) {
        buffer.writeInt(this.entid);
        buffer.writeDouble(this.pos[0]);
        buffer.writeDouble(this.pos[1]);
        buffer.writeDouble(this.pos[2]);
        buffer.writeDouble(this.rot[0]);
        buffer.writeDouble(this.rot[1]);
        buffer.writeDouble(this.rot[2]);
        buffer.writeDouble(this.throttle);
        buffer.writeDouble(this.steering);
        buffer.writeDouble(this.brake);
        buffer.writeInt(this.fuel);
    }

    public void decode(ByteBuf buffer) {
        this.entid = buffer.readInt();
        this.pos = new double[3];
        this.pos[0] = buffer.readDouble();
        this.pos[1] = buffer.readDouble();
        this.pos[2] = buffer.readDouble();
        this.rot = new double[3];
        this.rot[0] = buffer.readDouble();
        this.rot[1] = buffer.readDouble();
        this.rot[2] = buffer.readDouble();
        this.throttle = buffer.readDouble();
        this.steering = buffer.readDouble();
        this.brake = buffer.readDouble();
        this.fuel = buffer.readInt();
    }
}

