/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.rail;

import java.util.ArrayList;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.data.block.AABB;
import net.fexcraft.mod.fvtm.sys.event.EventHolder;
import net.fexcraft.mod.fvtm.sys.event.EventListener;
import net.fexcraft.mod.fvtm.sys.event.EventType;
import net.fexcraft.mod.fvtm.sys.rail.Compound;
import net.fexcraft.mod.fvtm.sys.rail.EntryDirection;
import net.fexcraft.mod.fvtm.sys.rail.JuncType;
import net.fexcraft.mod.fvtm.sys.rail.RailEntity;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.rail.Section;
import net.fexcraft.mod.fvtm.sys.rail.SignalType;
import net.fexcraft.mod.fvtm.sys.rail.Track;
import net.fexcraft.mod.fvtm.sys.uni.PathKey;
import net.fexcraft.mod.fvtm.sys.uni.SysObj;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.WorldW;

public class Junction
implements SysObj {
    private QV3D vecpos;
    public ArrayList<Track> tracks;
    public boolean switch0;
    public boolean switch1;
    public RailSystem root;
    public SystemRegion<RailSystem, Junction> region;
    public SignalType sigtype0 = SignalType.NONE;
    public SignalType sigtype1 = SignalType.NONE;
    public boolean sigstate0;
    public boolean sigstate1;
    public JuncType type;
    public String station;
    public EventHolder holder = new EventHolder(this);
    public ArrayList<V3I> entities = new ArrayList();
    protected AABB frustumbb;
    public V3D signalpos0;
    public V3D signalpos1;
    public double signalrot0;
    public double signalrot1;
    public Double bufferrot;

    public Junction(SystemRegion<RailSystem, Junction> reg, QV3D pos) {
        this(reg);
        this.vecpos = pos;
    }

    public Junction(SystemRegion<RailSystem, Junction> region) {
        this.root = (RailSystem)region.system;
        this.region = region;
        this.tracks = new ArrayList();
        this.switch1 = false;
        this.switch0 = false;
        this.type = JuncType.STRAIGHT;
    }

    public Junction setRoot(RailSystem data) {
        this.root = data;
        return this;
    }

    @Override
    public void read(TagCW compound) {
        this.vecpos = new QV3D(compound, "Pos");
        this.switch0 = compound.getBoolean("Switch0");
        this.switch1 = compound.getBoolean("Switch1");
        int trackam = compound.getInteger("Tracks");
        if (trackam > 0) {
            if (this.root.isRemote()) {
                for (Track track : this.tracks) {
                    if (track.railmodel != null) {
                        track.railmodel.clearGL();
                    }
                    if (track.restmodel != null) {
                        track.restmodel.clearGL();
                    }
                    track.restmodel = null;
                    track.railmodel = null;
                }
                this.signalpos1 = null;
                this.signalpos0 = null;
                this.bufferrot = null;
            }
            this.tracks.clear();
            for (int i = 0; i < trackam; ++i) {
                try {
                    this.tracks.add(new Track(this).read(compound.getCompound("Track" + i)));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            this.tracks.clear();
        }
        this.frustumbb = null;
        if (this.tracks.size() > 2) {
            this.type = compound.has("Type") ? JuncType.valueOf(compound.getString("Type")) : JuncType.byTracksAmount(this.size());
            this.sigtype0 = this.sigtype1 = SignalType.NONE;
        } else {
            this.type = JuncType.STRAIGHT;
            this.sigtype0 = SignalType.parse(compound.getString("SignalType0"));
            this.sigtype1 = SignalType.parse(compound.getString("SignalType1"));
        }
        this.station = compound.has("Station") ? compound.getString("Station") : null;
        this.sigstate0 = !this.sigtype0.none() && compound.getBoolean("Signal0");
        this.sigstate1 = !this.sigtype1.none() && compound.getBoolean("Signal1");
        this.holder.listeners.clear();
        for (EventType type : EventType.JUNCTION_EVENTS) {
            if (!compound.has("Ev_" + type.key)) continue;
            TagLW list = compound.getList("Ev_" + type.key);
            if (list.size() > 0) {
                this.holder.listeners.put(type, new ArrayList());
            }
            for (TagCW lt : list) {
                String[] stringArray;
                if (lt.has("arg")) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = lt.getString("arg");
                } else {
                    stringArray = new String[]{};
                }
                String[] arg = stringArray;
                this.holder.listeners.get(type).add(new EventListener(lt.getString("key"), lt.getString("cond"), lt.getString("act"), arg));
            }
        }
        this.entities.clear();
        if (compound.has("LinkedBlocks")) {
            TagLW list = (TagLW)compound.getList("LinkedBlocks").local();
            for (int i = 0; i < list.size(); ++i) {
                this.entities.add(new V3I(list.getList(i)));
            }
        }
    }

    @Override
    public void delete() {
    }

    @Override
    public TagCW write() {
        TagCW compound = TagCW.create();
        for (int i = 0; i < this.tracks.size(); ++i) {
            compound.set("Track" + i, this.tracks.get(i).write(null));
        }
        compound.set("Tracks", this.tracks.size());
        compound.set("Switch0", this.switch0);
        compound.set("Switch1", this.switch1);
        this.vecpos.write(compound, "Pos");
        if (!this.sigtype0.none()) {
            compound.set("SignalType0", this.sigtype0.save());
        }
        if (!this.sigtype1.none()) {
            compound.set("SignalType1", this.sigtype1.save());
        }
        if (this.tracks.size() > 2) {
            compound.set("Type", this.type.name());
        }
        if (this.station != null) {
            compound.set("Station", this.station);
        }
        if (!this.sigtype0.none()) {
            compound.set("Signal0", this.sigstate0);
        }
        if (!this.sigtype1.none()) {
            compound.set("Signal1", this.sigstate1);
        }
        for (EventType type : EventType.JUNCTION_EVENTS) {
            if (!this.holder.listeners.containsKey(type)) continue;
            TagLW list = TagLW.create();
            for (EventListener lis : this.holder.listeners.get(type)) {
                TagCW lt = TagCW.create();
                lt.set("key", lis.type.key);
                lt.set("cond", lis.cond.toString());
                lt.set("act", lis.action.key);
                if (lis.args.length > 0) {
                    lt.set("arg", lis.argString());
                }
                list.add(lt);
            }
            if (list.empty()) continue;
            compound.set("Ev_" + type.key, list);
        }
        if (!this.entities.isEmpty()) {
            TagLW list = TagLW.create();
            for (V3I pos : this.entities) {
                list.add(pos.toLW());
            }
            compound.set("LinkedBlocks", list);
        }
        return compound;
    }

    public QV3D getPos() {
        return this.vecpos;
    }

    public V3I getV3I() {
        return this.vecpos.pos;
    }

    public V3D getV3D() {
        return this.vecpos.vec;
    }

    public void addnew(Track track) {
        this.tracks.add(track);
        this.type = JuncType.byTracksAmount(this.size());
        if (this.hasSignals()) {
            this.setSignal(SignalType.NONE, null);
        }
        this.updateClient();
    }

    public void checkTrackSectionConsistency() {
        if (this.tracks.size() < 2) {
            return;
        }
        if (this.tracks.size() == 2 && this.hasSignals()) {
            Section sec0 = this.tracks.get((int)0).unit.section();
            Section sec1 = this.tracks.get((int)1).unit.section();
            if (sec0.getUID() == sec1.getUID()) {
                sec0.splitAtSignal(this);
            }
            return;
        }
        boolean fuse = false;
        Track zero = this.tracks.get(0);
        for (int i = 1; i < this.tracks.size(); ++i) {
            if (zero.unit.getSectionId() == this.tracks.get((int)i).unit.getSectionId()) continue;
            fuse = true;
            break;
        }
        if (fuse) {
            zero.unit.section().fuseAtTrack(zero);
        }
    }

    public void updateClient() {
        this.root.updateClient("junction", this.vecpos.pos);
    }

    public void remove(int index, boolean firstcall) {
        Track track = this.tracks.remove(index);
        if (track == null) {
            return;
        }
        if (this.hasSignals()) {
            this.setSignal(SignalType.NONE, null);
        }
        if (!firstcall) {
            track.unit.section().splitAtTrack(track);
            track.unit.section().remove(track);
        }
        this.type = JuncType.byTracksAmount(this.size());
        this.updateClient();
        if (firstcall) {
            Junction junk = this.root.getJunction(track.start.equals(this.vecpos) ? track.end.pos : track.start.pos);
            if (junk != null) {
                junk.remove(track.getOppositeId(), false);
            }
        } else {
            this.checkTrackSectionConsistency();
        }
    }

    private void remove(PathKey key, boolean firstcall) {
        for (int i = 0; i < this.tracks.size(); ++i) {
            if (!this.tracks.get(i).getId().equals(key)) continue;
            this.remove(i, firstcall);
            return;
        }
    }

    public void clear() {
        ArrayList<Track> trecks = new ArrayList<Track>();
        for (Track track : this.tracks) {
            trecks.add(track);
        }
        for (Track track : trecks) {
            this.remove(track.getId(), true);
        }
        this.tracks.clear();
        this.updateClient();
    }

    public Track getNext(RailEntity entity, PathKey track, boolean applystate, boolean event) {
        if (this.type == null) {
            JuncType juncType = this.size() <= 2 ? JuncType.STRAIGHT : (this.type = this.size() == 3 ? JuncType.FORK_2 : JuncType.CROSSING);
        }
        if (entity != null && event) {
            this.holder.run(EventType.JUNC_PASS, entity.vehicle, null, track);
        }
        switch (this.type) {
            case STRAIGHT: {
                switch (this.size()) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return this.eqTrack(track, 0) ? null : this.tracks.get(0);
                    }
                    case 2: {
                        return this.eqTrack(track, 0) ? this.tracks.get(1) : this.tracks.get(0);
                    }
                }
                break;
            }
            case FORK_2: {
                boolean bool;
                if (this.eqTrack(track, 0)) {
                    if (entity != null && event) {
                        this.holder.run(EventType.JUNC_SWITCH, entity.vehicle, null, track, this.getIndex(track));
                    }
                    return this.tracks.get(this.switch0 ? 1 : 2);
                }
                if (applystate && this.switch0 != (bool = this.eqTrack(track, 1))) {
                    this.switch0 = bool;
                    this.root.updateClient("junction_state", this.vecpos.pos);
                    this.updateLinkedTileEntities(false);
                }
                return this.tracks.get(0);
            }
            case FORK_3: {
                if (this.eqTrack(track, 0)) {
                    if (entity != null && event) {
                        this.holder.run(EventType.JUNC_SWITCH, entity.vehicle, null, track, this.getIndex(track));
                    }
                    return this.tracks.get(this.switch0 ? 1 : (this.switch1 ? 3 : 2));
                }
                if (applystate) {
                    boolean bool0 = this.eqTrack(track, 1);
                    boolean bool1 = this.eqTrack(track, 2);
                    if (bool0 && !this.switch0) {
                        this.switch0 = true;
                        this.switch1 = false;
                        this.root.updateClient("junction_state", this.vecpos.pos);
                        this.updateLinkedTileEntities(false);
                    } else if (bool1 && (this.switch0 || this.switch1)) {
                        this.switch0 = false;
                        this.switch1 = false;
                        this.root.updateClient("junction_state", this.vecpos.pos);
                        this.updateLinkedTileEntities(false);
                    } else if (!bool1 && !this.switch1) {
                        this.switch0 = false;
                        this.switch1 = true;
                        this.root.updateClient("junction_state", this.vecpos.pos);
                        this.updateLinkedTileEntities(false);
                    }
                }
                return this.tracks.get(0);
            }
            case CROSSING: {
                if (this.eqTrack(track, 0)) {
                    return this.tracks.get(1);
                }
                if (this.eqTrack(track, 1)) {
                    return this.tracks.get(0);
                }
                if (this.eqTrack(track, 2)) {
                    return this.tracks.get(3);
                }
                if (!this.eqTrack(track, 3)) break;
                return this.tracks.get(2);
            }
            case DOUBLE: {
                if (entity != null && event) {
                    this.holder.run(EventType.JUNC_SWITCH, entity.vehicle, null, track, this.getIndex(track));
                }
                if (this.eqTrack(track, 0)) {
                    if (applystate && !this.switch1) {
                        this.switch1 = true;
                        this.root.updateClient("junction_state", this.vecpos.pos);
                        this.updateLinkedTileEntities(false);
                    }
                    return this.tracks.get(this.switch0 ? 1 : 2);
                }
                if (this.eqTrack(track, 1)) {
                    if (applystate && !this.switch0) {
                        this.switch0 = true;
                        this.root.updateClient("junction_state", this.vecpos.pos);
                        this.updateLinkedTileEntities(false);
                    }
                    return this.tracks.get(this.switch1 ? 0 : 3);
                }
                if (this.eqTrack(track, 2)) {
                    if (applystate && this.switch0) {
                        this.switch0 = false;
                        this.root.updateClient("junction_state", this.vecpos.pos);
                        this.updateLinkedTileEntities(false);
                    }
                    return this.tracks.get(this.switch1 ? 0 : 3);
                }
                if (!this.eqTrack(track, 3)) break;
                if (applystate && this.switch1) {
                    this.switch1 = false;
                    this.root.updateClient("junction_state", this.vecpos.pos);
                    this.updateLinkedTileEntities(false);
                }
                return this.tracks.get(this.switch0 ? 1 : 2);
            }
        }
        return null;
    }

    public final boolean eqTrack(PathKey track, int i) {
        return this.tracks.get(i).getId().equals(track);
    }

    public boolean allowsSpawningOn() {
        return true;
    }

    public Track getTrack(PathKey key) {
        for (Track track : this.tracks) {
            if (!track.getId().equals(key)) continue;
            return track;
        }
        return null;
    }

    public int size() {
        return this.tracks.size();
    }

    @Override
    public void update() {
        if (this.isDecorational()) {
            return;
        }
        boolean oldsig0 = this.sigstate0;
        boolean oldsig1 = this.sigstate1;
        if (this.sigtype1.auto()) {
            this.sigstate1 = this.tracks.get((int)1).unit.section().isFree((Compound)null);
        }
        if (this.sigtype0.auto()) {
            this.sigstate0 = this.tracks.get((int)0).unit.section().isFree((Compound)null);
        }
        if (oldsig0 != this.sigstate0 || oldsig1 != this.sigstate1) {
            this.root.updateClient("junction_signal_state", this.vecpos.pos);
            this.updateLinkedTileEntities(true);
        }
    }

    private boolean isDecorational() {
        return this.tracks.size() == 0 || this.tracks.get((int)0).gauge.getWidth() < 0.0f;
    }

    public void pollSignal(RailEntity ent, EntryDirection dir) {
        if (this.sigtype0.none() && this.sigtype1.none()) {
            return;
        }
        boolean oldsig0 = this.sigstate0;
        boolean oldsig1 = this.sigstate1;
        if (dir.isForward()) {
            if (this.sigtype1.auto()) {
                this.sigstate1 = this.tracks.get((int)1).unit.section().isFree(ent);
            } else if (this.sigtype1.any()) {
                this.holder.run(EventType.JUNC_SIGNAL, ent.vehicle, ent.vehicle.driver(), new Object[]{this, EntryDirection.FORWARD});
            }
        } else if (this.sigtype0.auto()) {
            this.sigstate0 = this.tracks.get((int)0).unit.section().isFree(ent);
        } else if (this.sigtype0.any()) {
            this.holder.run(EventType.JUNC_SIGNAL, ent.vehicle, ent.vehicle.driver(), new Object[]{this, EntryDirection.BACKWARD});
        }
        if (oldsig0 != this.sigstate0 || oldsig1 != this.sigstate1) {
            this.root.updateClient("junction_signal_state", this.vecpos.pos);
            this.updateLinkedTileEntities(true);
        }
    }

    private boolean isInPlayerRange() {
        for (EntityW pl : this.root.getServerWorld().getPlayers()) {
            if (!(this.vecpos.vec.dis(pl.getPos()) < 1024.0)) continue;
            return true;
        }
        return false;
    }

    public boolean onSwitchInteract(EntityW player, Object tile, boolean left) {
        if (this.type == JuncType.STRAIGHT) {
            player.send("&cThis Junction has only 2 tracks! It cannot be switched.");
            return true;
        }
        if (this.type.isCrossing()) {
            player.send("&cThis Junction is a Crossing. It cannot be switched!");
            return true;
        }
        if (this.type.isSwitch()) {
            if (this.type == JuncType.FORK_2) {
                this.switch0 = !this.switch0;
                player.bar("&aChanged Junction State. [" + (this.switch0 ? 0 : 1) + "]");
            } else {
                if (this.switch1) {
                    this.switch1 = false;
                    this.switch0 = true;
                } else if (this.switch0) {
                    this.switch1 = false;
                    this.switch0 = false;
                } else if (!this.switch1) {
                    this.switch0 = false;
                    this.switch1 = true;
                }
                player.bar("&aChanged Junction State. [" + (this.switch0 ? 0 : (this.switch1 ? 2 : 1)) + "]");
            }
        }
        if (this.type.isDouble()) {
            if (left) {
                this.switch1 = !this.switch1;
            } else {
                this.switch0 = !this.switch0;
            }
            player.bar("&aChanged Junction State. [" + (this.switch0 ? 0 : 1) + "-" + (this.switch1 ? 0 : 1) + "]");
        }
        this.root.updateClient("junction_state", this.vecpos.pos);
        this.updateLinkedTileEntities(false);
        return true;
    }

    private void updateLinkedTileEntities(boolean signal) {
        this.entities.removeIf(pos -> {
            WorldW world = this.root.getServerWorld();
            if (!world.isPositionLoaded(pos)) {
                return false;
            }
            return false;
        });
    }

    public void unlinkLinkedTileEntities() {
        for (V3I pos : this.entities) {
            WorldW world = this.root.getServerWorld();
            if (world.isPositionLoaded(pos)) continue;
        }
    }

    public void addLinkedTileEntity(V3I pos) {
        if (!this.entities.contains(pos)) {
            this.entities.add(pos);
        }
    }

    public int getIndex(PathKey key) {
        for (int i = 0; i < this.tracks.size(); ++i) {
            if (!this.eqTrack(key, i)) continue;
            return i;
        }
        return -1;
    }

    public AABB getAABB() {
        if (this.frustumbb != null) {
            return this.frustumbb;
        }
        V3D min = new V3D();
        V3D max = new V3D();
        for (Track track : this.tracks) {
            V3D other = track.start.vec;
            if (other.x < min.x) {
                min.x = other.x;
            }
            if (other.y < min.y) {
                min.y = other.y;
            }
            if (other.z < min.z) {
                min.z = other.z;
            }
            if (other.x > max.x) {
                max.x = other.x;
            }
            if (other.y > max.y) {
                max.y = other.y;
            }
            if (other.z > max.z) {
                max.z = other.z;
            }
            other = track.end.vec;
            if (other.x < min.x) {
                min.x = other.x;
            }
            if (other.y < min.y) {
                min.y = other.y;
            }
            if (other.z < min.z) {
                min.z = other.z;
            }
            if (other.x > max.x) {
                max.x = other.x;
            }
            if (other.y > max.y) {
                max.y = other.y;
            }
            if (!(other.z > max.z)) continue;
            max.z = other.z;
        }
        if (this.size() == 0) {
            min = this.vecpos.vec.add(-0.5, -0.5, -0.5);
            max = this.vecpos.vec.add(0.5, 0.5, 0.5);
        }
        this.frustumbb = AABB.create(min.x, min.y, min.z, max.x, max.y, max.z);
        return this.frustumbb;
    }

    public void setSignal(SignalType signal, Boolean snd) {
        boolean has;
        boolean had;
        if (this.tracks.size() > 2) {
            signal = SignalType.NONE;
            snd = null;
        }
        boolean bl = had = this.sigtype0.any() || this.sigtype1.any();
        if (snd == null || !snd.booleanValue()) {
            this.sigtype0 = signal;
        }
        if (snd == null || snd.booleanValue()) {
            this.sigtype1 = signal;
        }
        boolean bl2 = has = this.sigtype0.any() || this.sigtype1.any();
        if (had && !has) {
            this.tracks.get((int)0).unit.section().fuseAtTrack(this.tracks.get(0));
        } else if (!had && has) {
            this.tracks.get((int)0).unit.section().splitAtSignal(this);
        }
        this.root.updateClient("junction_signal", this.vecpos.pos);
    }

    public void sendSigState() {
        this.root.updateClient("junction_signal_state", this.vecpos.pos);
    }

    public boolean getSignalState(EntryDirection dir) {
        return dir.isForward() ? this.sigtype1.none() || this.sigstate1 : this.sigtype0.none() || this.sigstate0;
    }

    public boolean hasSignal(PathKey track) {
        return this.eqTrack(track, 0) ? !this.sigtype1.none() : !this.sigtype0.none();
    }

    public boolean hasSignals() {
        return !this.sigtype0.none() || !this.sigtype1.none();
    }

    public boolean getSignalState(PathKey track) {
        return this.getSignalState(this.eqTrack(track, 0) ? EntryDirection.FORWARD : EntryDirection.BACKWARD);
    }

    public String toString() {
        return "Junction{ " + String.valueOf(this.vecpos) + ", " + this.tracks.size() + ", " + String.valueOf((Object)this.sigtype0) + "/" + String.valueOf((Object)this.sigtype1) + " }";
    }

    public String posString() {
        return this.vecpos.pos.x + ", " + this.vecpos.pos.y + ", " + this.vecpos.pos.z;
    }

    public Junction updateVecPos(QV3D vector) {
        this.vecpos = vector;
        return this;
    }

    public boolean full() {
        return this.tracks.size() >= 4;
    }
}

