/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.road;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.Time;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.uni.world.WrapperHolder;

public class RoadPlacingCache {
    private static final ConcurrentHashMap<UUID, HashMap<String, JsonArray>> UNDOCACHE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Timer> TIMERCACHE = new ConcurrentHashMap();

    public static void onLogIn(UUID uuid) {
        if (Config.ROAD_UNDO_CACHE_SIZE == 0) {
            return;
        }
        UNDOCACHE.put(uuid, new HashMap());
    }

    public static void onLogOut(final UUID uuid) {
        if (Config.ROAD_UNDO_CACHE_SIZE == 0) {
            return;
        }
        if (Config.ROAD_UNDO_CACHE_CLEARTIME == 0) {
            UNDOCACHE.remove(uuid);
        } else {
            if (TIMERCACHE.containsKey(uuid)) {
                TIMERCACHE.get(uuid).cancel();
            }
            final Timer timer = new Timer("RoadPlacingCache/" + String.valueOf(uuid) + "/Timer");
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        List uuids = WrapperHolder.getOnlinePlayerIDs();
                        for (UUID id : uuids) {
                            if (!id.equals(uuid)) continue;
                            return;
                        }
                        UNDOCACHE.remove(uuid);
                        timer.cancel();
                        TIMERCACHE.remove(uuid);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, new Date(Time.getDate() + (long)Config.ROAD_UNDO_CACHE_CLEARTIME * 60000L));
            TIMERCACHE.put(uuid, timer);
        }
    }

    public static void addEntry(UUID uuid, String dim, JsonMap map) {
        if (Config.ROAD_UNDO_CACHE_SIZE == 0) {
            return;
        }
        if (!UNDOCACHE.containsKey(uuid)) {
            UNDOCACHE.put(uuid, new HashMap());
        }
        if (!UNDOCACHE.get(uuid).containsKey(dim)) {
            UNDOCACHE.get(uuid).put(dim, new JsonArray());
        }
        JsonArray array = UNDOCACHE.get(uuid).get(dim);
        while (array.size() >= Config.ROAD_UNDO_CACHE_SIZE) {
            array.rem(0);
        }
        array.add((JsonValue)map);
    }

    public static void addEntry(UUID uuid, int dim, JsonMap map) {
        RoadPlacingCache.addEntry(uuid, "" + dim, map);
    }

    public static JsonMap getLastEntry(UUID uuid, String dim) {
        if (Config.ROAD_UNDO_CACHE_SIZE == 0) {
            return null;
        }
        if (!UNDOCACHE.containsKey(uuid)) {
            return null;
        }
        if (!UNDOCACHE.get(uuid).containsKey(dim)) {
            return null;
        }
        JsonArray array = UNDOCACHE.get(uuid).get(dim);
        if (array.empty()) {
            return null;
        }
        return array.get(array.size() - 1).asMap();
    }

    public static JsonMap getLastEntry(UUID uuid, int dim) {
        return RoadPlacingCache.getLastEntry(uuid, "" + dim);
    }

    public static void remLastEntry(UUID uuid, String dim) {
        if (Config.ROAD_UNDO_CACHE_SIZE == 0) {
            return;
        }
        if (!UNDOCACHE.containsKey(uuid)) {
            return;
        }
        if (!UNDOCACHE.get(uuid).containsKey(dim)) {
            return;
        }
        JsonArray array = UNDOCACHE.get(uuid).get(dim);
        if (array.empty()) {
            return;
        }
        array.rem(array.size() - 1);
    }

    public static void remLastEntry(UUID uuid, int dim) {
        RoadPlacingCache.remLastEntry(uuid, "" + dim);
    }
}

