/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.road;

import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.fvtm.sys.road.UniRoadTool;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.WorldW;

public class RoadPlacingUtil {
    public static final ConcurrentHashMap<UUID, NewRoad> QUEUE = new ConcurrentHashMap();
    public static final ConcurrentHashMap<UUID, UUID> CURRENT = new ConcurrentHashMap();
    public static NewRoad CL_CURRENT = null;

    public static void place(WorldW world, EntityW pass, TagCW com, QV3D vector) {
        UUID roadid = CURRENT.get(pass.getUUID());
        if (!com.has(UniRoadTool.TAG_KEY)) {
            pass.send("interact.fvtm.road_tool.empty");
            return;
        }
        int width = com.getCompound(UniRoadTool.TAG_KEY).getInteger("Width");
        if (roadid == null) {
            UUID newid = RoadPlacingUtil.genId();
            QUEUE.put(newid, new NewRoad(newid, vector, width));
            CURRENT.put(pass.getUUID(), newid);
            TagCW compound = TagCW.create();
            compound.set("uuid_l", newid.getMostSignificantBits());
            compound.set("uuid_m", newid.getLeastSignificantBits());
            compound.set("width", width);
            vector.write(compound, "vector");
            Packets.sendToAll(Packets.PKT_TAG, "road_tool_new", compound);
            FvtmResources.INSTANCE.spawnRoadMarker(world, vector, newid);
            return;
        }
        NewRoad road = QUEUE.get(roadid);
        if (road == null) {
            CURRENT.remove(pass.getUUID());
        }
        road.add(vector, width);
        TagCW compound = TagCW.create();
        compound.set("uuid_l", roadid.getMostSignificantBits());
        compound.set("uuid_m", roadid.getLeastSignificantBits());
        compound.set("width", width);
        vector.write(compound, "vector");
        Packets.sendToAll(Packets.PKT_TAG, "road_tool_add", compound);
        FvtmResources.INSTANCE.spawnRoadMarker(world, vector, roadid);
    }

    private static UUID genId() {
        UUID uuid = UUID.randomUUID();
        while (QUEUE.contains(uuid) || uuid.getMostSignificantBits() == 0L && uuid.getLeastSignificantBits() == 0L) {
            uuid = UUID.randomUUID();
        }
        return uuid;
    }

    public static class NewRoad {
        public ArrayList<QV3D> points = new ArrayList();
        public ArrayList<ArrayList<QV3D>> coords;
        public UniRoadTool.Road road;
        public int selected = -1;
        public int width;
        public UUID id;

        public NewRoad(UUID uuid, QV3D vector, int width) {
            this.points.add(vector);
            this.width = width;
            this.id = uuid;
        }

        public void add(QV3D vector, int width) {
            this.points.add(this.selected == -1 ? this.points.size() : (this.selected = this.selected + 1), vector);
            this.width = width;
            this.coords = null;
            this.genroad();
        }

        public void genroad() {
            this.road = this.points.size() > 1 ? new UniRoadTool.Road(this.points.toArray(new QV3D[0])) : null;
        }

        public void select(EntityW pass, QV3D vector) {
            int sel = -1;
            for (int i = 0; i < this.points.size(); ++i) {
                if (!vector.equals(this.points.get(i))) continue;
                sel = i;
                break;
            }
            this.selected = sel;
            TagCW compound = TagCW.create();
            compound.set("selected", this.selected);
            compound.set("uuid_l", this.id.getMostSignificantBits());
            compound.set("uuid_m", this.id.getLeastSignificantBits());
            Packets.sendToAll(Packets.PKT_TAG, "road_tool_selected", compound);
        }

        public void remove(EntityW pass, QV3D vector) {
            int rem = -1;
            for (int i = 0; i < this.points.size(); ++i) {
                if (!vector.equals(this.points.get(i))) continue;
                rem = i;
                break;
            }
            if (rem < 0) {
                return;
            }
            if (rem <= this.selected) {
                --this.selected;
            }
            if (this.selected < -1) {
                this.selected = -1;
            }
            this.points.remove(rem);
            this.genroad();
            this.coords = null;
            if (this.points.size() == 0) {
                this.reset();
                return;
            }
            TagCW compound = TagCW.create();
            compound.set("remove", rem);
            compound.set("uuid_l", this.id.getMostSignificantBits());
            compound.set("uuid_m", this.id.getLeastSignificantBits());
            vector.write(TagCW.wrap((Object)compound), "vector");
            Packets.sendToAll(Packets.PKT_TAG, "road_tool_remove", compound);
        }

        public void reset() {
            QUEUE.remove(this.id);
            CURRENT.entrySet().removeIf(entry -> ((UUID)entry.getValue()).equals(this.id));
            TagCW compound = TagCW.create();
            compound.set("uuid_l", this.id.getMostSignificantBits());
            compound.set("uuid_m", this.id.getLeastSignificantBits());
            Packets.sendToAll(Packets.PKT_TAG, "road_tool_reset", compound);
        }

        public int indexOf(QV3D vector) {
            for (int i = 0; i < this.points.size(); ++i) {
                if (!vector.equals(this.points.get(i))) continue;
                return i;
            }
            return -2;
        }

        public void create(EntityW pass, QV3D vector, StackWrapper stack) {
            UUID current = CURRENT.get(pass.getUUID());
            if (current == null) {
                pass.send("no_queue_entry / 0");
                return;
            }
            NewRoad nroad = QUEUE.get(current);
            if (nroad == null) {
                pass.send("no_queue_entry / 1");
                return;
            }
            if (!UniRoadTool.placeRoad(pass, stack, new UniRoadTool.Road(nroad.points.toArray(new QV3D[0])))) {
                return;
            }
            pass.send("interact.fvtm.road_tool.complete");
            nroad.reset();
        }

        public void genpreview() {
            ArrayList preview = new ArrayList();
            this.coords = new ArrayList();
            double half = (double)this.width * 0.5 - 0.5;
            V3D vec = this.road.vecpath[0];
            for (double passed = 0.001; passed < this.road.length; passed += 0.125) {
                V3D last = vec;
                vec = this.road.getVectorPosition(passed, false);
                double angle = Math.atan2(last.x - vec.x, last.z - vec.z);
                ArrayList<V3D> list = new ArrayList<V3D>();
                for (int i = 0; i < this.width; ++i) {
                    list.add(UniRoadTool.gen((V3D)vec, (double)angle, (double)(-half + 0.25 + (double)i), (double)0.0).vec);
                }
                preview.add(list);
                if (!(passed < 0.1)) continue;
                passed = 0.0;
            }
            this.coords = new ArrayList();
            for (ArrayList arrayList : preview) {
                ArrayList<QV3D> list = new ArrayList<QV3D>();
                for (V3D v : arrayList) {
                    QV3D pos = new QV3D(v);
                    if (list.contains(pos)) continue;
                    list.add(pos);
                }
                this.coords.add(list);
            }
        }
    }
}

