/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.uni;

import java.util.Map;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.function.part.TireFunction;
import net.fexcraft.mod.fvtm.handler.TireInstallationHandler;
import net.fexcraft.mod.fvtm.handler.WheelInstallationHandler;
import net.fexcraft.mod.fvtm.sys.uni.UniWheel;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.fvtm.sys.uni.VehicleMovement;
import net.fexcraft.mod.fvtm.sys.uni.WheelTireData;
import net.fexcraft.mod.fvtm.util.MathUtils;

public class ClassicVehMove
implements VehicleMovement {
    protected VehicleInstance inst;

    public ClassicVehMove(VehicleInstance vi) {
        this.inst = vi;
    }

    @Override
    public void initWheels() {
        this.inst.wheels.clear();
        for (Map.Entry<String, V3D> entry : this.inst.data.getWheelPositions().entrySet()) {
            if (entry.getKey().endsWith(":tire")) continue;
            WheelTireData wheel = new WheelTireData(entry.getKey());
            wheel.pos = entry.getValue();
            PartData part = this.inst.data.getPart(entry.getKey());
            if (!((WheelInstallationHandler.WheelData)((Part)part.getType()).getInstallHandlerData()).hasTire()) {
                part = this.inst.data.getPart(entry.getKey() + ":tire");
                wheel.radius = ((TireInstallationHandler.TireData)((Part)part.getType()).getInstallHandlerData()).getOuterRadius();
            } else {
                wheel.radius += ((WheelInstallationHandler.WheelData)((Part)part.getType()).getInstallHandlerData()).getRadius();
            }
            wheel.function = part.getFunction(TireFunction.class, "fvtm:tire").getTireAttr(part);
            wheel.slot = this.inst.data.getWheelSlots().get(entry.getKey());
            wheel.mirror = this.inst.data.getWheelSlots().get((Object)entry.getKey()).mirror;
            this.inst.wheeldata.put(entry.getKey(), wheel);
        }
        this.assignWheels();
        this.setupAxles();
    }

    @Override
    public void move(boolean nocons) {
        this.inst.entity.setOnGround(true);
        this.inst.moveto.set(0.0, 0.0, 0.0);
        if (!this.inst.type.isWaterVehicle()) {
            if (this.inst.throttle > -0.01 && this.inst.throttle < 0.01) {
                this.inst.throttle = 0.0;
            }
            double steer = Math.toRadians(this.inst.steer_yaw);
            double wyaw = MathUtils.valRad(this.inst.pivot().yaw());
            double syaw = MathUtils.valRad(wyaw + steer);
            double myaw = 0.0;
            double scal = 0.0;
            double decr = 0.0;
            boolean cons = nocons || this.inst.engine != null && this.inst.consumeFuel();
            for (UniWheel wheel : this.inst.wheels.values()) {
                if (wheel.wtd() == null) continue;
                V3D wm = wheel.wtd().move;
                scal = (-Math.sin(-wyaw) * wm.x + -Math.cos(-wyaw) * wm.z) * 0.05;
                wheel.prepare();
                wheel.yaw(this.inst.pivot().deg_yaw());
                if (this.inst.engine != null && cons && this.inst.throttle != 0.0) {
                    scal += 0.05 * this.inst.throttle * (double)(this.inst.throttle > 0.0 ? this.inst.spdata.max_throttle : this.inst.spdata.min_throttle) * (double)this.inst.engine.getSphEngineSpeed();
                }
                scal *= (double)Config.MOTION_SCALE;
                myaw = wyaw;
                if (wheel.wtd().slot.steering) {
                    myaw = syaw;
                }
                wm.x += -Math.sin(-myaw) * scal;
                wm.y = -0.4905000329017639;
                wm.z += -Math.cos(-myaw) * scal;
                decr = 0.95;
                if (this.inst.brake > 0.0 || this.inst.pbrake) {
                    decr = this.inst.pbrake ? 0.8 : decr - this.inst.brake * 0.1;
                }
                V3D.mul((double)decr, (double)1.0, (double)decr, (V3D)wm);
                wheel.setMotion(wm.x, wm.y, wm.z);
                wheel.move();
            }
        }
        if (!((Vehicle)this.inst.data.getType()).isTrailer() || this.inst.front == null) {
            this.inst.alignToWheels();
        }
    }

    public void assignWheels() {
        this.inst.w_rear_l = this.inst.w_rear_r = new WheelTireData();
        this.inst.w_front_r = this.inst.w_rear_r;
        this.inst.w_front_l = this.inst.w_rear_r;
        for (WheelTireData wheel : this.inst.wheeldata.values()) {
            if (!((Vehicle)this.inst.data.getType()).isTrailer()) {
                if (wheel.pos.x <= this.inst.w_front_l.pos.x && wheel.pos.z <= this.inst.w_front_l.pos.z) {
                    this.inst.w_front_l = wheel;
                    continue;
                }
                if (wheel.pos.x >= this.inst.w_front_r.pos.x && wheel.pos.z <= this.inst.w_front_r.pos.z) {
                    this.inst.w_front_r = wheel;
                    continue;
                }
            }
            if (wheel.pos.x <= this.inst.w_rear_l.pos.x && wheel.pos.z >= this.inst.w_rear_l.pos.z) {
                this.inst.w_rear_l = wheel;
                continue;
            }
            if (!(wheel.pos.x >= this.inst.w_rear_r.pos.x) || !(wheel.pos.z >= this.inst.w_rear_r.pos.z)) continue;
            this.inst.w_rear_r = wheel;
        }
        if (((Vehicle)this.inst.data.getType()).isTrailer()) {
            this.inst.w_front_l = new WheelTireData("_" + this.inst.w_rear_l.id);
            this.inst.w_front_l.asTrailerFront(this.inst.w_rear_l);
            this.inst.w_front_l.slot = this.inst.w_rear_l.slot;
            this.inst.wheeldata.put(this.inst.w_front_l.id, this.inst.w_front_l);
            this.inst.w_front_r = new WheelTireData("_" + this.inst.w_rear_r.id);
            this.inst.w_front_r.asTrailerFront(this.inst.w_rear_r);
            this.inst.w_front_r.slot = this.inst.w_rear_r.slot;
            this.inst.wheeldata.put(this.inst.w_front_r.id, this.inst.w_front_r);
        }
    }

    public void setupAxles() {
    }
}

